%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Tagging application
Name: content
Version: 2.0.6
Release: 1%{?dist}
License: BSD-2-Clause
Group: Development/Libraries
Source0: http://pear.horde.org/get/content-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/content
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Core >= 2.0.0
Requires: Horde_Core < 3.0.0alpha1
Requires: Horde_Date >= 2.0.0
Requires: Horde_Date < 3.0.0alpha1
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Db >= 2.0.0
Requires: Horde_Db < 3.0.0alpha1
Requires: Horde_Injector >= 2.0.0
Requires: Horde_Injector < 3.0.0alpha1
Requires: Horde_Rdo >= 2.0.0
Requires: Horde_Rdo < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0     
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
This application provides tagging support for the other Horde applications.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/content.xml

%clean
rm -rf %{buildroot}

%post
#sleep 2
pear install --nodeps --soft --force --register-only %{xmldir}/content.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/content >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/content/*
%doc %{pear_hordedir}
%{peardir}/*
%{xmldir}/content.xml
%{_bindir}/content-object-add
%{_bindir}/content-object-delete
%{_bindir}/content-tag
%{_bindir}/content-tag-add
%{_bindir}/content-tag-delete
%{_bindir}/content-untag


%changelog
* Wed Sep 20 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.6-1
- Updated to 2.0.6

* Fri Oct 23 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.5-1
- Updated to 2.0.5

* Mon Jun 9 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.4-1
- Updated to 2.0.4

* Tue Jul 16 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.3-1
- Updated to 2.0.3

* Mon Jun 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.2-1
- Initial release for SME Server
- Original build from pear make-rpm-spec
