%define peardir %(pear config-get php_dir 2> /dev/null || echo %{_datadir}/pear)
%define xmldir  /var/lib/pear
%global pear_name HTTP_Request2

Summary: Provides an easy way to perform HTTP requests
Name: php-pear-HTTP_Request2
Version: 2.3.0
Release: 1%{?dist}
License: BSD License
Group: Development/Libraries
Source0: http://pear.php.net/get/HTTP_Request2-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.php.net/package/HTTP_Request2

BuildRequires:  php-pear(PEAR) >= 1.4.7
Requires: php-pear(Net_URL2) >= 2.0.0
Requires: php-pear(PEAR) >= 1.9.2
Provides:       php-pear(%{pear_name}) = %{version}

#BuildRequires: PEAR::PEAR >= 1.4.7
#Requires: PEAR::Net_URL2 >= 2.0.0
#Requires: PEAR::PEAR >= 1.9.2

BuildArch: noarch

%description
PHP5 rewrite of HTTP_Request package (with parts of HTTP_Client). Provides
cleaner API and pluggable Adapters:
  * Socket adapter, based on old HTTP_Request code,
  * Curl adapter, wraps around PHP's cURL extension,
  * Mock adapter, to use for testing packages dependent on HTTP_Request2.
Supports POST requests with data and file uploads, basic and digest
authentication, cookies, managing cookies across requests, proxies, gzip
and
deflate encodings, redirects, monitoring the request progress with
Observers...

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=/docs \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/HTTP_Request2.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/HTTP_Request2.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.php.net/HTTP_Request2 >/dev/null || :
fi

%files
%defattr(-,root,root)
%doc docs/HTTP_Request2/*
%{peardir}/*
%{xmldir}/HTTP_Request2.xml

%changelog
* Tue Feb 24 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.0-1
- updated to 2.3.0

* Fri Jan 17 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.1-1
- updated to 2.2.1

* Mon May 6 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.1-2
- updated spec file requires section, and left original info remarked.

* Sun May 5 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.1-1
- Original from pear-make-rpm-spec.
