%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: MAPI utility library
Name: Horde_Mapi
Version: 1.0.10
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Mapi-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Mapi
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Date >= 2.0.0
Requires: Horde_Date < 3.0.0alpha1
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: php-bcmath >= 5.3
Requires: php-bcmath < 6.0
Requires: php-pear(PEAR) >= 1.7.0           
Requires: php-channel(pear.horde.org)   
BuildArch: noarch

Provides:       %{name} = %{version}

%description
Provides various utility classes for dealing with Microsoft MAPI structured
data.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Mapi.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Mapi.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Mapi >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Mapi/*
%{peardir}/*
%{xmldir}/Horde_Mapi.xml

%changelog
* Sat Mar 2 2019 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.10-1
- Updated to 1.0.10

* Sat Feb 16 2019 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.9-1
- Updated to 1.0.9

* Wed Mar 23 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.8-1
- Updated to 1.0.8

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.6-1
- Updated to 1.0.6

* Sat May 2 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.5-1
- Updated to 1.0.5

* Sat Jan 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.4-1
- Updated to 1.0.4

* Sat Jan 18 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.3-1
- Updated to 1.0.3

* Sat Jan 18 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.2-1
- Initial release for SME Server 9
- Original build from pear make-rpm-spec

