%{!?__pear: %{expand: %%global __pear %{_bindir}/pear}}
%global pear_name File

Name:           php-pear-File
Version:        1.4.1
Release:        1%{?dist}
Summary:        Common file and directory routines

Group:          Development/Languages
License:        PHP
URL:            http://pear.php.net/package/File
Source0:        http://pear.php.net/get/%{pear_name}-%{version}.tgz

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch
BuildRequires:  php-pear(PEAR) >= 1.6.0

Requires:       php-pear(PEAR) >= 1.6.0
# Yes, this are circular dependencies, from upstream
Requires:       php-pear(File_CSV)
Requires:       php-pear(File_Util)
Requires(post): %{__pear}
Requires(postun): %{__pear}
Provides:       php-pear(%{pear_name}) = %{version}

%description
Provides easy access to read/write to files along with some common routines
to deal with paths.


%prep
%setup -qc

cd %{pear_name}-%{version}
# Package is V2
mv ../package.xml %{name}.xml


%build
cd %{pear_name}-%{version}
# Empty build section, most likely nothing required.


%install
rm -rf %{buildroot}
cd %{pear_name}-%{version}
%{__pear} install --nodeps --packagingroot %{buildroot} %{name}.xml

# Clean up unnecessary files
rm -rf %{buildroot}%{pear_phpdir}/.??*

# Install XML package description
install -d %{buildroot}%{pear_xmldir}
install -pm 644 %{name}.xml %{buildroot}%{pear_xmldir}


%check
cd %{pear_name}-%{version}
%{__pear} \
   run-tests \
   --recur \
   --ini "-d include_path=%{buildroot}%{pear_phpdir}:%{pear_phpdir}" \
   tests | tee ../tests.log
grep "FAILED TESTS" ../tests.log && exit 1


%clean
rm -rf %{buildroot}


%post
%{__pear} install --nodeps --soft --force --register-only \
    %{pear_xmldir}/%{name}.xml >/dev/null || :

%postun
if [ $1 -eq 0 ] ; then
    %{__pear} uninstall --nodeps --ignore-errors --register-only \
        %{pear_name} >/dev/null || :
fi


%files
%defattr(-,root,root,-)
%{pear_xmldir}/%{name}.xml
%{pear_testdir}/%{pear_name}
%{pear_phpdir}/%{pear_name}*


%changelog
* Sun May 5 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.4.1-1
- Updated to 1.4.1

* Sun Apr 01 2012 Remi Collet <remi@fedoraproject.org> - 1.4.0-1
- update to 1.4.0
- run test suite during %%check
- splited in File, File_CSV and File_Util

* Sun Aug 15 2010 Remi Collet <Fedora@FamilleCollet.com> - 1.3.0-4
- clean spec
- rename File.xml to php-pear-File.xml
- add %%check for documentation

* Sun Jul 26 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.3.0-3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild

* Thu Feb 26 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.3.0-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild

* Sat Sep 08 2007 Christopher Stone <chris.stone@gmail.com> 1.3.0-1
- Upstream sync

* Wed Dec 13 2006 Christopher Stone <chris.stone@gmail.com> 1.2.2-1
- Initial Release
