# $Id: smeserver-kronolith.spec,v 1.2 2010/08/23 01:52:39 mrjhb3 Exp $
# Authority: mrjhb3
# Name: John H. Bennett III

Summary: SME Server specific Kronolith configuration and templates.
%define name smeserver-kronolith
Name: %{name}
%define version 2.3
%define release 20
Version: %{version}
Release: %{release}%{?dist}
License: GPL
Group: Networking/Daemons
Source: %{name}-%{version}.tar.gz
Patch0: smeserver-kronolith_3_upgrade.patch 
Patch1: smeserver-kronolith_Kronolith_Convert_Datatree-to-SQL.patch
Patch2: smeserver-kronolith_4_conf_php.patch
Patch3: smeserver-kronolith_convert-datatree-shares-to-sql.patch
Patch4: smeserver-kronolith_4_conf_menu_apps_php.patch
Patch5: smeserver-kronolith_dup_schema.patch
Patch6: smeserver-kronolith_reminder.patch
Patch7: smeserver-kronolith_migrate_db_hide.patch
Patch8: smeserver-kronolith_convert_to_utc_hack.patch
Patch9: smeserver-kronolith_share_cal_readonly.patch
Patch10: smeserver-kronolith_agenda_link.patch
Patch11: smeserver-kronolith_maps_providers.patch
Patch12: smeserver-kronolith_http_directive.patch
Patch13: smeserver-kronolith_99Kronolith_Datatree_to_SQL_typo_flx.patch
Patch14: smeserver-kronolith_85kronolith_utc_upgrade.patch
Patch15: smeserver-kronolith_agenda_reminder.patch
BuildRoot: /var/tmp/%{name}-%{version}-%{release}-buildroot
BuildArchitectures: noarch
Requires: e-smith-base >= 5.4
Requires: e-smith-apache >= 1.1.0-18
Requires: e-smith-lib >= 1.15.1-16
Requires: e-smith-base >= 4.18.1-5
Requires: e-smith-ldap >= 4.12.0-9
Requires: imp-h5 >= 6
Requires: kronolith-h5 >= 4
Requires: php-pear-HTTP-Request >= 1.4.0
Requires: php-pear-Net-Socket >= 1.0.6
Requires: php-pear-Net-URL >= 1.0.14
BuildRequires: e-smith-devtools >= 1.13.1-03
AutoReqProv: no
Obsoletes: e-smith-kronolith = 0.8.0-02db
Obsoletes: smeserver-kronolith-menuarray
Obsoletes: pear-http_request >= 1.4.0 
Obsoletes: pear-net_socket >= 1.0.6 
Obsoletes: pear-net_url >= 1.0.14 


%changelog
* Thu Jan 2 2020 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-20
- Patch to not output agenda and reminder crontab entries if horde is not enabled

* Wed Nov 21 2018 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-19
- Add Obsoletes: smeserver-kronolith-menuarray [SME: 10488] 

* Fri Jun 17 2016 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-18
- Patch to the Kronolith UTC script which determines if it needs to be run.

* Sun Jun 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-17
- Patch to type in 99Kronolith_Datatree_to_SQL file.

* Wed Dec 30 2015 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-16
- Patch to include additional apache ACL directory restrictions

* Tue Sep 30 2014 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-15
- Patch that removes Yahoo and Bing as default map providers.

* Fri Sep 12 2014 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-14
- Patch that changes reminder server name so that clickable links in daily agenda email work.

* Tue Sep 2 2014 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-13
- Automatically share calendars as read-only to all.  Individual user can change.

* Sun Mar 30 2014 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-12
- Hack to set a dummy file in /home/e-smith/db/kronolithutcrun to signal krononith 
  convert to utc script has already been run, and not to run again.  I don't know
  php, so I can't determine if Current php script yields ant way to signal it's 
  already been run.  Better fix for SME, but WFM for my needs.

* Wed Mar 26 2014 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-11
- Patch to send the majority of the output from horde table migration to /dev/null.                  
  Some log noise errors will still be seen depending on what tables are present from
  previous versions.

* Thu Nov 07 2013 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-10
- Patch to fix horde reminders that was using a not needed db variable.

* Wed Jun 05 2013 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-9 
- Updated spec file to require imp-h5 >= 6 and kronolith-h5 >= 4

* Wed Apr 24 2013 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-8
- Remark out requires until proper RPM's are built.

* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-7
- Patch to remove redundant rfc2739.schema file

* Tue Nov 27 2012 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-6
- Update to remove 120MenuSettings and conf.menu.apps.php file as they aren't used
  with horde 5.x.

* Sun Nov 25 2012 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-5
- Update to latest kronolith-convert-datatree-shares-to-sql script for automated 
  SME Server install.

* Sat Nov 24 2012 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-4
- Update file id and other misc. changes in conf.php so config shows up to date.

* Thu Aug 2 2012 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-3
- Add SME Server modified script to migrate Kronolith Datatree to SQL backend so that
  upgrades will migrate data to new DB structure

* Mon May 14 2012 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-2
- Update kronolith templates to reflect changes in kronolith 3.0.15

* Mon Apr 23 2012 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-1
- Re-rolled for kronolith 3.0.x

* Tue Jul 26 2011 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-14
- Remove duplicate template entries in slapd.conf

* Sun Jul 11 2010 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-13
- Re-Added migrate fragment to remove FreeBusy db entry from accounts since this
  information is now saved directly to LDAP on SME8.

* Sun Jul 11 2010 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-12
- Re-Added saving of user's calFBURL to LDAP for use with SME8. [SME: 5708]

* Sun Jun 27 2010 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-11
- Remove changes for -8, -9, -10 so that rpm can be installed on SME 7.x.
  Will re-add appropriate patches for SME8 when it is released.  [SME: 6080]

* Thu Apr 22 2010 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-10
- Added removal of user's calFBURL from LDAP smeserver-kronolith is uninstalled

* Thu Apr 22 2010 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-9
- Added migrate fragment to remove FreeBusy db entry from accounts since this
  information is now saved directly to LDAP on SME8.

* Thu Apr 22 2010 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-8
- Added saving of user's calFBURL to LDAP for use with SME8. [SME: 5708]

* Sun Jan 24 2010 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-7
- Update to change owner of alarm and reminder cron jobs from root to www [SME: 4851]

* Mon Dec 28 2009 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-6
- Updated templates to reflect Kronolith 2.3.3

* Fri Oct 9 2009 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-5
- Updated templates to reflect Kronolith 2.3.2

* Sun Dec 14 2008 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-4
- Patch to add more functionality to Kronolith for calendar reminders and daily agenda email
- config setprop horde reminders enabled - default is enabled and this is set to run every 5 minutes.
- The above sends calendar email alarms/reminders.
- config setprop horde remindertime x - will change the frequency, value in minutes.
- config setprop horde agendas enabled  - default is disabled set to run everyday at 5 am when enabled.
- The above sends daily calendar agenda emails.
- config setprop horde agenda time x - will change the frequency, value needs to be 0 - 24.

* Fri Dec 05 2008 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-3
- Patch to add forgotten changes from kronolith upgrade sql script

* Fri Dec 05 2008 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-2
- Updated templates to reflect Kronolith 2.3

* Sun Jun 22 2008 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-1
- Initial production build
- Jump in package name to reflect new version of kronolith

* Tue Jun 3 2008 John H. Bennett III <bennettj@johnbennettservices.com> 0.1-1
- Initial build
- Jump in package name to reflect new version of kronolith

%description
This package adds necessary templates and configuration items
so that Kronolith will work properly on SME Server

%prep
%setup

%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1

%build
perl createlinks

%install
rm -rf $RPM_BUILD_ROOT
(cd root   ; find . -depth -print | cpio -dump $RPM_BUILD_ROOT)
/sbin/e-smith/genfilelist $RPM_BUILD_ROOT > %{name}-%{version}-filelist
echo "%doc COPYING"          >> %{name}-%{version}-filelist

%clean 
rm -rf $RPM_BUILD_ROOT

%preun

%post

%postun

%files -f %{name}-%{version}-filelist
%defattr(-,root,root)
