#!/usr/bin/perl -w
#----------------------------------------------------------------------
# copyright (C) 2002-2005 Mitel Networks Corporation
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
# 
# Technical support for this program is available from Mitel Networks 
# Please visit our web site www.mitel.com/sme/ for details.
#----------------------------------------------------------------------

use strict;
use DBI;
use esmith::ConfigDB;
use esmith::util;

# Exit early if there is nothing to do
die("horde db must exist") unless ( -d "/var/lib/mysql/horde/");
die("turba db must exist") unless ( -f "/var/lib/mysql/horde/turba_objects.frm");

my $conf = esmith::ConfigDB->open_ro 
    or die "Can't open configuration database: $!\n";
our $username       = 'root';
our $password       = esmith::util::LdapPassword();
our $TURBA_DATABASE = 'horde';
our $dbi_options = {RaiseError => 1, ChopBlanks => 1, AutoCommit => 1};

my $db_turbahandle = DBI->connect
                   ("DBI:mysql:$TURBA_DATABASE",
                     $username, $password, $dbi_options )
                     || die ("Connection error: $DBI::errstr");

my $sth = $db_turbahandle->prepare("show columns from turba_objects");
$sth->execute;
my $turba_objects = $sth->fetchall_hashref('Field');


    unless (defined $turba_objects->{object_children})
{
    my $statement = 
        "ALTER TABLE turba_objects ADD COLUMN object_children ".
        "VARCHAR(255)";
    $statement = $db_turbahandle->prepare($statement) or 
        die "prepare: $$statement: $DBI::errstr";
    $statement->execute or die "execute: $$statement: $DBI::errstr";
}
