;;; nerd-icons-data-faicon.el --- glyphset faicon -*- lexical-binding: t -*-

;; Copyright (C) 2023 Hongyu Ding <rainstormstudio@yahoo.com>

;; Author: Hongyu Ding <rainstormstudio@yahoo.com>
;; Keywords: lisp

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; faicon
;; from Nerd Font Version: 3.4.0

;;; Code:

(defvar nerd-icons/faicon-alist
  '(
    ("nf-fa-500px" . "\xf26e")
    ("nf-fa-accessible_icon" . "\xf29b")
    ("nf-fa-accusoft" . "\xf0b7")
    ("nf-fa-address_book" . "\xf2b9")
    ("nf-fa-address_book_o" . "\xf2ba")
    ("nf-fa-address_card" . "\xf2bb")
    ("nf-fa-address_card_o" . "\xf2bc")
    ("nf-fa-adjust" . "\xf042")
    ("nf-fa-adn" . "\xf170")
    ("nf-fa-adversal" . "\xf0b8")
    ("nf-fa-affiliatetheme" . "\xf0b9")
    ("nf-fa-airbnb" . "\xef93")
    ("nf-fa-algolia" . "\xf0ba")
    ("nf-fa-align_center" . "\xf037")
    ("nf-fa-align_justify" . "\xf039")
    ("nf-fa-align_left" . "\xf036")
    ("nf-fa-align_right" . "\xf038")
    ("nf-fa-alipay" . "\xeebc")
    ("nf-fa-amazon" . "\xf270")
    ("nf-fa-amazon_pay" . "\xed56")
    ("nf-fa-ambulance" . "\xf0f9")
    ("nf-fa-american_sign_language_interpreting" . "\xf2a3")
    ("nf-fa-amilia" . "\xf0bb")
    ("nf-fa-anchor" . "\xf13d")
    ("nf-fa-android" . "\xf17b")
    ("nf-fa-angellist" . "\xf209")
    ("nf-fa-angle_double_down" . "\xf103")
    ("nf-fa-angle_double_left" . "\xf100")
    ("nf-fa-angle_double_right" . "\xf101")
    ("nf-fa-angle_double_up" . "\xf102")
    ("nf-fa-angle_down" . "\xf107")
    ("nf-fa-angle_left" . "\xf104")
    ("nf-fa-angle_right" . "\xf105")
    ("nf-fa-angle_up" . "\xf106")
    ("nf-fa-angles_down" . "\xf103")
    ("nf-fa-angles_left" . "\xf100")
    ("nf-fa-angles_right" . "\xf101")
    ("nf-fa-angles_up" . "\xf102")
    ("nf-fa-angrycreative" . "\xf0bc")
    ("nf-fa-angular" . "\xed4b")
    ("nf-fa-ankh" . "\xeebd")
    ("nf-fa-app_store" . "\xf0bd")
    ("nf-fa-app_store_ios" . "\xf0be")
    ("nf-fa-apper" . "\xf0bf")
    ("nf-fa-apple" . "\xf179")
    ("nf-fa-apple_pay" . "\xed41")
    ("nf-fa-apple_whole" . "\xee98")
    ("nf-fa-archive" . "\xf187")
    ("nf-fa-archway" . "\xee20")
    ("nf-fa-area_chart" . "\xf1fe")
    ("nf-fa-arrow_circle_down" . "\xf0ab")
    ("nf-fa-arrow_circle_left" . "\xf0a8")
    ("nf-fa-arrow_circle_o_down" . "\xf01a")
    ("nf-fa-arrow_circle_o_left" . "\xf190")
    ("nf-fa-arrow_circle_o_right" . "\xf18e")
    ("nf-fa-arrow_circle_o_up" . "\xf01b")
    ("nf-fa-arrow_circle_right" . "\xf0a9")
    ("nf-fa-arrow_circle_up" . "\xf0aa")
    ("nf-fa-arrow_down" . "\xf063")
    ("nf-fa-arrow_down_1_9" . "\xf162")
    ("nf-fa-arrow_down_9_1" . "\xefb1")
    ("nf-fa-arrow_down_a_z" . "\xf15d")
    ("nf-fa-arrow_down_long" . "\xf175")
    ("nf-fa-arrow_down_short_wide" . "\xefaf")
    ("nf-fa-arrow_down_wide_short" . "\xf160")
    ("nf-fa-arrow_down_z_a" . "\xefad")
    ("nf-fa-arrow_left" . "\xf060")
    ("nf-fa-arrow_left_long" . "\xf177")
    ("nf-fa-arrow_pointer" . "\xf245")
    ("nf-fa-arrow_right" . "\xf061")
    ("nf-fa-arrow_right_arrow_left" . "\xf0ec")
    ("nf-fa-arrow_right_from_bracket" . "\xf08b")
    ("nf-fa-arrow_right_long" . "\xf178")
    ("nf-fa-arrow_right_to_bracket" . "\xf090")
    ("nf-fa-arrow_rotate_left" . "\xf0e2")
    ("nf-fa-arrow_rotate_right" . "\xf01e")
    ("nf-fa-arrow_turn_down" . "\xf149")
    ("nf-fa-arrow_turn_up" . "\xf148")
    ("nf-fa-arrow_up" . "\xf062")
    ("nf-fa-arrow_up_1_9" . "\xf163")
    ("nf-fa-arrow_up_9_1" . "\xefb2")
    ("nf-fa-arrow_up_a_z" . "\xf15e")
    ("nf-fa-arrow_up_long" . "\xf176")
    ("nf-fa-arrow_up_right_from_square" . "\xf08e")
    ("nf-fa-arrow_up_short_wide" . "\xefb0")
    ("nf-fa-arrow_up_wide_short" . "\xf161")
    ("nf-fa-arrow_up_z_a" . "\xefae")
    ("nf-fa-arrows" . "\xf047")
    ("nf-fa-arrows_alt" . "\xf0b2")
    ("nf-fa-arrows_h" . "\xf07e")
    ("nf-fa-arrows_left_right" . "\xf07e")
    ("nf-fa-arrows_rotate" . "\xf021")
    ("nf-fa-arrows_up_down" . "\xf07d")
    ("nf-fa-arrows_up_down_left_right" . "\xf047")
    ("nf-fa-arrows_v" . "\xf07d")
    ("nf-fa-artstation" . "\xef31")
    ("nf-fa-asl_interpreting" . "\xf2a3")
    ("nf-fa-assistive_listening_systems" . "\xf2a2")
    ("nf-fa-asterisk" . "\xf069")
    ("nf-fa-asymmetrik" . "\xf0cf")
    ("nf-fa-at" . "\xf1fa")
    ("nf-fa-atlassian" . "\xef32")
    ("nf-fa-atom" . "\xee99")
    ("nf-fa-audible" . "\xf0df")
    ("nf-fa-audio_description" . "\xf29e")
    ("nf-fa-automobile" . "\xf1b9")
    ("nf-fa-autoprefixer" . "\xed47")
    ("nf-fa-avianex" . "\xefc2")
    ("nf-fa-aviato" . "\xed4c")
    ("nf-fa-award" . "\xee22")
    ("nf-fa-aws" . "\xf0ef")
    ("nf-fa-baby" . "\xef33")
    ("nf-fa-baby_carriage" . "\xef34")
    ("nf-fa-backward" . "\xf04a")
    ("nf-fa-backward_fast" . "\xf049")
    ("nf-fa-backward_step" . "\xf048")
    ("nf-fa-bacon" . "\xef77")
    ("nf-fa-bag_shopping" . "\xf290")
    ("nf-fa-bahai" . "\xeecb")
    ("nf-fa-balance_scale" . "\xf24e")
    ("nf-fa-ban" . "\xf05e")
    ("nf-fa-ban_smoking" . "\xee16")
    ("nf-fa-bandage" . "\xed74")
    ("nf-fa-bandcamp" . "\xf2d5")
    ("nf-fa-bank" . "\xf19c")
    ("nf-fa-bar_chart" . "\xf080")
    ("nf-fa-bar_chart_o" . "\xf080")
    ("nf-fa-barcode" . "\xf02a")
    ("nf-fa-bars" . "\xf0c9")
    ("nf-fa-bars_progress" . "\xef8f")
    ("nf-fa-bars_staggered" . "\xee19")
    ("nf-fa-baseball" . "\xed5c")
    ("nf-fa-baseball_bat_ball" . "\xed5b")
    ("nf-fa-basket_shopping" . "\xf291")
    ("nf-fa-basketball" . "\xed5d")
    ("nf-fa-bath" . "\xf2cd")
    ("nf-fa-bathtub" . "\xf2cd")
    ("nf-fa-battery" . "\xf240")
    ("nf-fa-battery_0" . "\xf244")
    ("nf-fa-battery_1" . "\xf243")
    ("nf-fa-battery_2" . "\xf242")
    ("nf-fa-battery_3" . "\xf241")
    ("nf-fa-battery_4" . "\xf240")
    ("nf-fa-battery_empty" . "\xf244")
    ("nf-fa-battery_full" . "\xf240")
    ("nf-fa-battery_half" . "\xf242")
    ("nf-fa-battery_quarter" . "\xf243")
    ("nf-fa-battery_three_quarters" . "\xf241")
    ("nf-fa-battle_net" . "\xef94")
    ("nf-fa-bed" . "\xf236")
    ("nf-fa-bed_pulse" . "\xed8a")
    ("nf-fa-beer" . "\xf0fc")
    ("nf-fa-beer_mug_empty" . "\xf0fc")
    ("nf-fa-behance" . "\xf1b4")
    ("nf-fa-behance_square" . "\xf1b5")
    ("nf-fa-bell" . "\xf0f3")
    ("nf-fa-bell_concierge" . "\xee2b")
    ("nf-fa-bell_o" . "\xf0a2")
    ("nf-fa-bell_slash" . "\xf1f6")
    ("nf-fa-bell_slash_o" . "\xf1f7")
    ("nf-fa-bezier_curve" . "\xee24")
    ("nf-fa-bicycle" . "\xf206")
    ("nf-fa-bimobject" . "\xf0ff")
    ("nf-fa-binoculars" . "\xf1e5")
    ("nf-fa-biohazard" . "\xef35")
    ("nf-fa-birthday_cake" . "\xf1fd")
    ("nf-fa-bitbucket" . "\xf171")
    ("nf-fa-bitbucket_square" . "\xf172")
    ("nf-fa-bitcoin" . "\xf10f")
    ("nf-fa-bity" . "\xf116")
    ("nf-fa-black_tie" . "\xf27e")
    ("nf-fa-blackberry" . "\xf117")
    ("nf-fa-blender" . "\xede1")
    ("nf-fa-blender_phone" . "\xeeea")
    ("nf-fa-blind" . "\xf29d")
    ("nf-fa-blog" . "\xef36")
    ("nf-fa-blogger" . "\xf11f")
    ("nf-fa-blogger_b" . "\xf12f")
    ("nf-fa-bluetooth" . "\xf293")
    ("nf-fa-bluetooth_b" . "\xf294")
    ("nf-fa-bold" . "\xf032")
    ("nf-fa-bolt" . "\xf0e7")
    ("nf-fa-bomb" . "\xf1e2")
    ("nf-fa-bone" . "\xee9a")
    ("nf-fa-bong" . "\xee25")
    ("nf-fa-book" . "\xf02d")
    ("nf-fa-book_atlas" . "\xee21")
    ("nf-fa-book_bible" . "\xeebe")
    ("nf-fa-book_journal_whills" . "\xeecd")
    ("nf-fa-book_medical" . "\xef78")
    ("nf-fa-book_open" . "\xede2")
    ("nf-fa-book_open_reader" . "\xee9b")
    ("nf-fa-book_quran" . "\xeedc")
    ("nf-fa-book_skull" . "\xeeeb")
    ("nf-fa-book_tanakh" . "\xef8e")
    ("nf-fa-bookmark" . "\xf02e")
    ("nf-fa-bookmark_o" . "\xf097")
    ("nf-fa-bootstrap" . "\xef95")
    ("nf-fa-border_all" . "\xefa3")
    ("nf-fa-border_none" . "\xefa4")
    ("nf-fa-border_top_left" . "\xefa5")
    ("nf-fa-bowling_ball" . "\xed5e")
    ("nf-fa-box" . "\xed75")
    ("nf-fa-box_archive" . "\xf187")
    ("nf-fa-box_open" . "\xed95")
    ("nf-fa-boxes_stacked" . "\xed76")
    ("nf-fa-braille" . "\xf2a1")
    ("nf-fa-brain" . "\xee9c")
    ("nf-fa-bread_slice" . "\xef79")
    ("nf-fa-briefcase" . "\xf0b1")
    ("nf-fa-briefcase_medical" . "\xed77")
    ("nf-fa-broom" . "\xede4")
    ("nf-fa-broom_ball" . "\xed6e")
    ("nf-fa-brush" . "\xee26")
    ("nf-fa-btc" . "\xf15a")
    ("nf-fa-buffer" . "\xef96")
    ("nf-fa-bug" . "\xf188")
    ("nf-fa-building" . "\xf1ad")
    ("nf-fa-building_columns" . "\xf19c")
    ("nf-fa-building_o" . "\xf0f7")
    ("nf-fa-bullhorn" . "\xf0a1")
    ("nf-fa-bullseye" . "\xf140")
    ("nf-fa-burger" . "\xef82")
    ("nf-fa-buromobelexperte" . "\xf13f")
    ("nf-fa-bus" . "\xf207")
    ("nf-fa-bus_simple" . "\xee27")
    ("nf-fa-business_time" . "\xeebf")
    ("nf-fa-buy_n_large" . "\xefb6")
    ("nf-fa-buysellads" . "\xf20d")
    ("nf-fa-cab" . "\xf1ba")
    ("nf-fa-cable_car" . "\xef71")
    ("nf-fa-cake_candles" . "\xf1fd")
    ("nf-fa-calculator" . "\xf1ec")
    ("nf-fa-calendar" . "\xf073")
    ("nf-fa-calendar_check" . "\xf274")
    ("nf-fa-calendar_check_o" . "\xf274")
    ("nf-fa-calendar_day" . "\xef37")
    ("nf-fa-calendar_days" . "\xf073")
    ("nf-fa-calendar_minus" . "\xf272")
    ("nf-fa-calendar_minus_o" . "\xf272")
    ("nf-fa-calendar_o" . "\xf133")
    ("nf-fa-calendar_plus" . "\xf271")
    ("nf-fa-calendar_plus_o" . "\xf271")
    ("nf-fa-calendar_times_o" . "\xf273")
    ("nf-fa-calendar_week" . "\xef38")
    ("nf-fa-calendar_xmark" . "\xf273")
    ("nf-fa-camera" . "\xf030")
    ("nf-fa-camera_retro" . "\xf083")
    ("nf-fa-campground" . "\xeeec")
    ("nf-fa-canadian_maple_leaf" . "\xef39")
    ("nf-fa-candy_cane" . "\xef3a")
    ("nf-fa-cannabis" . "\xee28")
    ("nf-fa-capsules" . "\xed79")
    ("nf-fa-car" . "\xf1b9")
    ("nf-fa-car_battery" . "\xee9e")
    ("nf-fa-car_burst" . "\xee9f")
    ("nf-fa-car_rear" . "\xee9d")
    ("nf-fa-car_side" . "\xeea0")
    ("nf-fa-caravan" . "\xefc1")
    ("nf-fa-caret_down" . "\xf0d7")
    ("nf-fa-caret_left" . "\xf0d9")
    ("nf-fa-caret_right" . "\xf0da")
    ("nf-fa-caret_square_o_down" . "\xf150")
    ("nf-fa-caret_square_o_left" . "\xf191")
    ("nf-fa-caret_square_o_right" . "\xf152")
    ("nf-fa-caret_square_o_up" . "\xf151")
    ("nf-fa-caret_up" . "\xf0d8")
    ("nf-fa-carrot" . "\xef3b")
    ("nf-fa-cart_arrow_down" . "\xf218")
    ("nf-fa-cart_flatbed" . "\xed7f")
    ("nf-fa-cart_flatbed_suitcase" . "\xee66")
    ("nf-fa-cart_plus" . "\xf217")
    ("nf-fa-cart_shopping" . "\xf07a")
    ("nf-fa-cash_register" . "\xef3c")
    ("nf-fa-cat" . "\xeeed")
    ("nf-fa-cc" . "\xf20a")
    ("nf-fa-cc_amazon_pay" . "\xed57")
    ("nf-fa-cc_amex" . "\xf1f3")
    ("nf-fa-cc_apple_pay" . "\xed42")
    ("nf-fa-cc_diners_club" . "\xf24c")
    ("nf-fa-cc_discover" . "\xf1f2")
    ("nf-fa-cc_jcb" . "\xf24b")
    ("nf-fa-cc_mastercard" . "\xf1f1")
    ("nf-fa-cc_paypal" . "\xf1f4")
    ("nf-fa-cc_stripe" . "\xf1f5")
    ("nf-fa-cc_visa" . "\xf1f0")
    ("nf-fa-centercode" . "\xf14f")
    ("nf-fa-centos" . "\xef3d")
    ("nf-fa-certificate" . "\xf0a3")
    ("nf-fa-chain" . "\xf0c1")
    ("nf-fa-chain_broken" . "\xf127")
    ("nf-fa-chair" . "\xeeee")
    ("nf-fa-chalkboard" . "\xede5")
    ("nf-fa-chalkboard_user" . "\xede6")
    ("nf-fa-champagne_glasses" . "\xef49")
    ("nf-fa-charging_station" . "\xeea1")
    ("nf-fa-chart_area" . "\xf1fe")
    ("nf-fa-chart_bar" . "\xf080")
    ("nf-fa-chart_line" . "\xf201")
    ("nf-fa-chart_pie" . "\xf200")
    ("nf-fa-check" . "\xf00c")
    ("nf-fa-check_circle" . "\xf058")
    ("nf-fa-check_circle_o" . "\xf05d")
    ("nf-fa-check_double" . "\xee29")
    ("nf-fa-check_square" . "\xf14a")
    ("nf-fa-check_square_o" . "\xf046")
    ("nf-fa-check_to_slot" . "\xef2f")
    ("nf-fa-cheese" . "\xef7a")
    ("nf-fa-chess" . "\xed5f")
    ("nf-fa-chess_bishop" . "\xed60")
    ("nf-fa-chess_board" . "\xed61")
    ("nf-fa-chess_king" . "\xed62")
    ("nf-fa-chess_knight" . "\xed63")
    ("nf-fa-chess_pawn" . "\xed64")
    ("nf-fa-chess_queen" . "\xed65")
    ("nf-fa-chess_rook" . "\xed66")
    ("nf-fa-chevron_circle_down" . "\xf13a")
    ("nf-fa-chevron_circle_left" . "\xf137")
    ("nf-fa-chevron_circle_right" . "\xf138")
    ("nf-fa-chevron_circle_up" . "\xf139")
    ("nf-fa-chevron_down" . "\xf078")
    ("nf-fa-chevron_left" . "\xf053")
    ("nf-fa-chevron_right" . "\xf054")
    ("nf-fa-chevron_up" . "\xf077")
    ("nf-fa-child" . "\xf1ae")
    ("nf-fa-chrome" . "\xf268")
    ("nf-fa-chromecast" . "\xef97")
    ("nf-fa-church" . "\xede7")
    ("nf-fa-circle" . "\xf111")
    ("nf-fa-circle_arrow_down" . "\xf0ab")
    ("nf-fa-circle_arrow_left" . "\xf0a8")
    ("nf-fa-circle_arrow_right" . "\xf0a9")
    ("nf-fa-circle_arrow_up" . "\xf0aa")
    ("nf-fa-circle_check" . "\xf05d")
    ("nf-fa-circle_chevron_down" . "\xf13a")
    ("nf-fa-circle_chevron_left" . "\xf137")
    ("nf-fa-circle_chevron_right" . "\xf138")
    ("nf-fa-circle_chevron_up" . "\xf139")
    ("nf-fa-circle_dollar_to_slot" . "\xed98")
    ("nf-fa-circle_dot" . "\xf192")
    ("nf-fa-circle_down" . "\xf01a")
    ("nf-fa-circle_exclamation" . "\xf06a")
    ("nf-fa-circle_h" . "\xed83")
    ("nf-fa-circle_half_stroke" . "\xf042")
    ("nf-fa-circle_info" . "\xf05a")
    ("nf-fa-circle_left" . "\xf190")
    ("nf-fa-circle_minus" . "\xf056")
    ("nf-fa-circle_notch" . "\xf1ce")
    ("nf-fa-circle_o" . "\xf10c")
    ("nf-fa-circle_o_notch" . "\xf1ce")
    ("nf-fa-circle_pause" . "\xf28b")
    ("nf-fa-circle_play" . "\xf144")
    ("nf-fa-circle_plus" . "\xf055")
    ("nf-fa-circle_question" . "\xf059")
    ("nf-fa-circle_radiation" . "\xef5b")
    ("nf-fa-circle_right" . "\xf18e")
    ("nf-fa-circle_stop" . "\xf28d")
    ("nf-fa-circle_thin" . "\xf1db")
    ("nf-fa-circle_up" . "\xf01b")
    ("nf-fa-circle_user" . "\xf2bd")
    ("nf-fa-circle_xmark" . "\xf05c")
    ("nf-fa-city" . "\xeec0")
    ("nf-fa-clipboard" . "\xf0ea")
    ("nf-fa-clipboard_alt" . "\xf07f")
    ("nf-fa-clipboard_check" . "\xed7a")
    ("nf-fa-clipboard_list" . "\xed7b")
    ("nf-fa-clipboard_user" . "\xef7c")
    ("nf-fa-clock" . "\xf017")
    ("nf-fa-clock_o" . "\xf017")
    ("nf-fa-clock_rotate_left" . "\xf1da")
    ("nf-fa-clone" . "\xf24d")
    ("nf-fa-close" . "\xf00d")
    ("nf-fa-closed_captioning" . "\xf20a")
    ("nf-fa-cloud" . "\xf0c2")
    ("nf-fa-cloud_arrow_down" . "\xf0ed")
    ("nf-fa-cloud_arrow_up" . "\xf0ee")
    ("nf-fa-cloud_bolt" . "\xef2c")
    ("nf-fa-cloud_download" . "\xf0ed")
    ("nf-fa-cloud_meatball" . "\xef1a")
    ("nf-fa-cloud_moon" . "\xeeef")
    ("nf-fa-cloud_moon_rain" . "\xef1b")
    ("nf-fa-cloud_rain" . "\xef1c")
    ("nf-fa-cloud_showers_heavy" . "\xef1d")
    ("nf-fa-cloud_sun" . "\xeef0")
    ("nf-fa-cloud_sun_rain" . "\xef1e")
    ("nf-fa-cloud_upload" . "\xf0ee")
    ("nf-fa-cloudscale" . "\xf15f")
    ("nf-fa-cloudsmith" . "\xf167")
    ("nf-fa-cloudversify" . "\xf16f")
    ("nf-fa-cny" . "\xf157")
    ("nf-fa-code" . "\xf121")
    ("nf-fa-code_branch" . "\xf126")
    ("nf-fa-code_commit" . "\xf172")
    ("nf-fa-code_fork" . "\xf126")
    ("nf-fa-code_merge" . "\xf17f")
    ("nf-fa-codepen" . "\xf1cb")
    ("nf-fa-codiepie" . "\xf284")
    ("nf-fa-coffee" . "\xf0f4")
    ("nf-fa-cog" . "\xf013")
    ("nf-fa-cogs" . "\xf085")
    ("nf-fa-coins" . "\xede8")
    ("nf-fa-columns" . "\xf0db")
    ("nf-fa-comment" . "\xf075")
    ("nf-fa-comment_dollar" . "\xeec1")
    ("nf-fa-comment_dots" . "\xf27b")
    ("nf-fa-comment_medical" . "\xef7d")
    ("nf-fa-comment_o" . "\xf0e5")
    ("nf-fa-comment_slash" . "\xed96")
    ("nf-fa-comment_sms" . "\xef68")
    ("nf-fa-commenting" . "\xf27a")
    ("nf-fa-commenting_o" . "\xf27b")
    ("nf-fa-comments" . "\xf086")
    ("nf-fa-comments_dollar" . "\xeec2")
    ("nf-fa-comments_o" . "\xf0e6")
    ("nf-fa-compact_disc" . "\xede9")
    ("nf-fa-compass" . "\xf14e")
    ("nf-fa-compass_drafting" . "\xee31")
    ("nf-fa-compress" . "\xf066")
    ("nf-fa-computer_mouse" . "\xefba")
    ("nf-fa-confluence" . "\xef3f")
    ("nf-fa-connectdevelop" . "\xf20e")
    ("nf-fa-contao" . "\xf26d")
    ("nf-fa-cookie" . "\xee2c")
    ("nf-fa-cookie_bite" . "\xee2d")
    ("nf-fa-copy" . "\xf0c5")
    ("nf-fa-copyright" . "\xf1f9")
    ("nf-fa-cotton_bureau" . "\xefb5")
    ("nf-fa-couch" . "\xed97")
    ("nf-fa-cow" . "\xeef1")
    ("nf-fa-cpanel" . "\xf18f")
    ("nf-fa-creative_commons" . "\xf25e")
    ("nf-fa-creative_commons_by" . "\xedb1")
    ("nf-fa-creative_commons_nc" . "\xedb2")
    ("nf-fa-creative_commons_nc_eu" . "\xedb3")
    ("nf-fa-creative_commons_nc_jp" . "\xedb4")
    ("nf-fa-creative_commons_nd" . "\xedb5")
    ("nf-fa-creative_commons_pd" . "\xedb6")
    ("nf-fa-creative_commons_pd_alt" . "\xedb7")
    ("nf-fa-creative_commons_remix" . "\xedb8")
    ("nf-fa-creative_commons_sa" . "\xedb9")
    ("nf-fa-creative_commons_sampling" . "\xedba")
    ("nf-fa-creative_commons_sampling_plus" . "\xedbb")
    ("nf-fa-creative_commons_share" . "\xedbc")
    ("nf-fa-creative_commons_zero" . "\xedbd")
    ("nf-fa-credit_card" . "\xf09d")
    ("nf-fa-credit_card_alt" . "\xf283")
    ("nf-fa-critical_role" . "\xeef2")
    ("nf-fa-crop" . "\xf125")
    ("nf-fa-crop_simple" . "\xee2e")
    ("nf-fa-cross" . "\xeec3")
    ("nf-fa-crosshairs" . "\xf05b")
    ("nf-fa-crow" . "\xedea")
    ("nf-fa-crown" . "\xedeb")
    ("nf-fa-crutch" . "\xef7e")
    ("nf-fa-css3" . "\xf13c")
    ("nf-fa-css3_alt" . "\xf19f")
    ("nf-fa-cube" . "\xf1b2")
    ("nf-fa-cubes" . "\xf1b3")
    ("nf-fa-cut" . "\xf0c4")
    ("nf-fa-cutlery" . "\xf0f5")
    ("nf-fa-cuttlefish" . "\xf1af")
    ("nf-fa-d_and_d" . "\xf1bf")
    ("nf-fa-d_and_d_beyond" . "\xeef3")
    ("nf-fa-dashboard" . "\xf0e4")
    ("nf-fa-dashcube" . "\xf210")
    ("nf-fa-database" . "\xf1c0")
    ("nf-fa-deaf" . "\xf2a4")
    ("nf-fa-deafness" . "\xf2a4")
    ("nf-fa-dedent" . "\xf03b")
    ("nf-fa-delete_left" . "\xee23")
    ("nf-fa-delicious" . "\xf1a5")
    ("nf-fa-democrat" . "\xef1f")
    ("nf-fa-deploydog" . "\xf1cf")
    ("nf-fa-deskpro" . "\xf1df")
    ("nf-fa-desktop" . "\xf108")
    ("nf-fa-dev" . "\xeef4")
    ("nf-fa-deviantart" . "\xf1bd")
    ("nf-fa-dharmachakra" . "\xeec4")
    ("nf-fa-dhl" . "\xef40")
    ("nf-fa-diagram_project" . "\xefce")
    ("nf-fa-diamond" . "\xf29f")
    ("nf-fa-diamond_turn_right" . "\xeea2")
    ("nf-fa-diaspora" . "\xef41")
    ("nf-fa-dice" . "\xedec")
    ("nf-fa-dice_d20" . "\xeef5")
    ("nf-fa-dice_d6" . "\xeef6")
    ("nf-fa-dice_five" . "\xeded")
    ("nf-fa-dice_four" . "\xedee")
    ("nf-fa-dice_one" . "\xedef")
    ("nf-fa-dice_six" . "\xedf0")
    ("nf-fa-dice_three" . "\xedf1")
    ("nf-fa-dice_two" . "\xedf2")
    ("nf-fa-digg" . "\xf1a6")
    ("nf-fa-digital_ocean" . "\xf1ef")
    ("nf-fa-discord" . "\xf1ff")
    ("nf-fa-discourse" . "\xf20c")
    ("nf-fa-disease" . "\xef7f")
    ("nf-fa-divide" . "\xedf3")
    ("nf-fa-dna" . "\xed7d")
    ("nf-fa-dochub" . "\xf20f")
    ("nf-fa-docker" . "\xf21f")
    ("nf-fa-dog" . "\xeef7")
    ("nf-fa-dollar" . "\xf155")
    ("nf-fa-dollar_sign" . "\xf155")
    ("nf-fa-dolly" . "\xed7e")
    ("nf-fa-door_closed" . "\xedf4")
    ("nf-fa-door_open" . "\xedf5")
    ("nf-fa-dot_circle_o" . "\xf192")
    ("nf-fa-dove" . "\xed99")
    ("nf-fa-down_left_and_up_right_to_center" . "\xed4d")
    ("nf-fa-down_long" . "\xf03f")
    ("nf-fa-download" . "\xf019")
    ("nf-fa-draft2digital" . "\xf220")
    ("nf-fa-dragon" . "\xeef8")
    ("nf-fa-draw_polygon" . "\xeea3")
    ("nf-fa-dribbble" . "\xf17d")
    ("nf-fa-drivers_license" . "\xf2c2")
    ("nf-fa-drivers_license_o" . "\xf2c3")
    ("nf-fa-dropbox" . "\xf16b")
    ("nf-fa-droplet" . "\xf043")
    ("nf-fa-droplet_slash" . "\xee8e")
    ("nf-fa-drum" . "\xee32")
    ("nf-fa-drum_steelpan" . "\xee33")
    ("nf-fa-drumstick_bite" . "\xeef9")
    ("nf-fa-drupal" . "\xf1a9")
    ("nf-fa-dumbbell" . "\xed67")
    ("nf-fa-dumpster" . "\xef42")
    ("nf-fa-dumpster_fire" . "\xef43")
    ("nf-fa-dungeon" . "\xeefa")
    ("nf-fa-dyalog" . "\xf22f")
    ("nf-fa-ear_deaf" . "\xf2a4")
    ("nf-fa-ear_listen" . "\xf2a2")
    ("nf-fa-earlybirds" . "\xf230")
    ("nf-fa-earth_africa" . "\xee45")
    ("nf-fa-earth_americas" . "\xee46")
    ("nf-fa-earth_asia" . "\xee47")
    ("nf-fa-earth_europe" . "\xef4b")
    ("nf-fa-ebay" . "\xedbe")
    ("nf-fa-edge" . "\xf282")
    ("nf-fa-edit" . "\xf044")
    ("nf-fa-eercast" . "\xf2da")
    ("nf-fa-egg" . "\xef80")
    ("nf-fa-eject" . "\xf052")
    ("nf-fa-elementor" . "\xed5a")
    ("nf-fa-ellipsis" . "\xf141")
    ("nf-fa-ellipsis_h" . "\xf141")
    ("nf-fa-ellipsis_v" . "\xf142")
    ("nf-fa-ellipsis_vertical" . "\xf142")
    ("nf-fa-ello" . "\xeea4")
    ("nf-fa-ember" . "\xed4e")
    ("nf-fa-empire" . "\xf1d1")
    ("nf-fa-envelope" . "\xf0e0")
    ("nf-fa-envelope_o" . "\xf003")
    ("nf-fa-envelope_open" . "\xf2b6")
    ("nf-fa-envelope_open_o" . "\xf2b7")
    ("nf-fa-envelope_open_text" . "\xeec5")
    ("nf-fa-envelope_square" . "\xf199")
    ("nf-fa-envelopes_bulk" . "\xeed1")
    ("nf-fa-envira" . "\xf299")
    ("nf-fa-equals" . "\xedf6")
    ("nf-fa-eraser" . "\xf12d")
    ("nf-fa-erlang" . "\xf23f")
    ("nf-fa-ethereum" . "\xed58")
    ("nf-fa-ethernet" . "\xef44")
    ("nf-fa-etsy" . "\xf2d7")
    ("nf-fa-eur" . "\xf153")
    ("nf-fa-euro" . "\xf153")
    ("nf-fa-euro_sign" . "\xf153")
    ("nf-fa-evernote" . "\xef98")
    ("nf-fa-exchange" . "\xf0ec")
    ("nf-fa-exclamation" . "\xf12a")
    ("nf-fa-exclamation_circle" . "\xf06a")
    ("nf-fa-exclamation_triangle" . "\xf071")
    ("nf-fa-expand" . "\xf065")
    ("nf-fa-expeditedssl" . "\xf23e")
    ("nf-fa-external_link" . "\xf08e")
    ("nf-fa-external_link_square" . "\xf14c")
    ("nf-fa-eye" . "\xf06e")
    ("nf-fa-eye_dropper" . "\xf1fb")
    ("nf-fa-eye_low_vision" . "\xf2a8")
    ("nf-fa-eye_slash" . "\xf070")
    ("nf-fa-eyedropper" . "\xf1fb")
    ("nf-fa-fa" . "\xf2b4")
    ("nf-fa-face_angry" . "\xee1f")
    ("nf-fa-face_dizzy" . "\xee30")
    ("nf-fa-face_flushed" . "\xee42")
    ("nf-fa-face_frown" . "\xf119")
    ("nf-fa-face_frown_open" . "\xee43")
    ("nf-fa-face_grimace" . "\xee48")
    ("nf-fa-face_grin" . "\xee49")
    ("nf-fa-face_grin_beam" . "\xee4b")
    ("nf-fa-face_grin_beam_sweat" . "\xee4c")
    ("nf-fa-face_grin_hearts" . "\xee4d")
    ("nf-fa-face_grin_squint" . "\xee4e")
    ("nf-fa-face_grin_squint_tears" . "\xee4f")
    ("nf-fa-face_grin_stars" . "\xee50")
    ("nf-fa-face_grin_tears" . "\xee51")
    ("nf-fa-face_grin_tongue" . "\xee52")
    ("nf-fa-face_grin_tongue_squint" . "\xee53")
    ("nf-fa-face_grin_tongue_wink" . "\xee54")
    ("nf-fa-face_grin_wide" . "\xee4a")
    ("nf-fa-face_grin_wink" . "\xee55")
    ("nf-fa-face_kiss" . "\xee5f")
    ("nf-fa-face_kiss_beam" . "\xee60")
    ("nf-fa-face_kiss_wink_heart" . "\xee61")
    ("nf-fa-face_laugh" . "\xee62")
    ("nf-fa-face_laugh_beam" . "\xee63")
    ("nf-fa-face_laugh_squint" . "\xee64")
    ("nf-fa-face_laugh_wink" . "\xee65")
    ("nf-fa-face_meh" . "\xf11a")
    ("nf-fa-face_meh_blank" . "\xee6d")
    ("nf-fa-face_rolling_eyes" . "\xee6e")
    ("nf-fa-face_sad_cry" . "\xee7b")
    ("nf-fa-face_sad_tear" . "\xee7c")
    ("nf-fa-face_smile" . "\xf118")
    ("nf-fa-face_smile_beam" . "\xee80")
    ("nf-fa-face_smile_wink" . "\xeda9")
    ("nf-fa-face_surprise" . "\xee89")
    ("nf-fa-face_tired" . "\xee8f")
    ("nf-fa-facebook" . "\xf09a")
    ("nf-fa-facebook_f" . "\xf24f")
    ("nf-fa-facebook_messenger" . "\xf25f")
    ("nf-fa-facebook_official" . "\xf230")
    ("nf-fa-facebook_square" . "\xf082")
    ("nf-fa-fan" . "\xefa7")
    ("nf-fa-fantasy_flight_games" . "\xeefb")
    ("nf-fa-fast_backward" . "\xf049")
    ("nf-fa-fast_forward" . "\xf050")
    ("nf-fa-fax" . "\xf1ac")
    ("nf-fa-feather" . "\xedf7")
    ("nf-fa-feather_pointed" . "\xee34")
    ("nf-fa-fedex" . "\xef45")
    ("nf-fa-fedora" . "\xef46")
    ("nf-fa-feed" . "\xf09e")
    ("nf-fa-female" . "\xf182")
    ("nf-fa-fighter_jet" . "\xf0fb")
    ("nf-fa-figma" . "\xef47")
    ("nf-fa-file" . "\xf15b")
    ("nf-fa-file_archive_o" . "\xf1c6")
    ("nf-fa-file_arrow_down" . "\xee36")
    ("nf-fa-file_arrow_up" . "\xee3d")
    ("nf-fa-file_audio" . "\xf1c7")
    ("nf-fa-file_audio_o" . "\xf1c7")
    ("nf-fa-file_code" . "\xf1c9")
    ("nf-fa-file_code_o" . "\xf1c9")
    ("nf-fa-file_contract" . "\xee35")
    ("nf-fa-file_csv" . "\xeefc")
    ("nf-fa-file_excel" . "\xf1c3")
    ("nf-fa-file_excel_o" . "\xf1c3")
    ("nf-fa-file_export" . "\xee37")
    ("nf-fa-file_image" . "\xf1c5")
    ("nf-fa-file_image_o" . "\xf1c5")
    ("nf-fa-file_import" . "\xee38")
    ("nf-fa-file_invoice" . "\xee39")
    ("nf-fa-file_invoice_dollar" . "\xee3a")
    ("nf-fa-file_lines" . "\xf15c")
    ("nf-fa-file_medical" . "\xed80")
    ("nf-fa-file_movie_o" . "\xf1c8")
    ("nf-fa-file_o" . "\xf016")
    ("nf-fa-file_pdf" . "\xf1c1")
    ("nf-fa-file_pdf_o" . "\xf1c1")
    ("nf-fa-file_pen" . "\xf05f")
    ("nf-fa-file_photo_o" . "\xf1c5")
    ("nf-fa-file_picture_o" . "\xf1c5")
    ("nf-fa-file_powerpoint" . "\xf1c4")
    ("nf-fa-file_powerpoint_o" . "\xf1c4")
    ("nf-fa-file_prescription" . "\xee3b")
    ("nf-fa-file_signature" . "\xee3c")
    ("nf-fa-file_sound_o" . "\xf1c7")
    ("nf-fa-file_text" . "\xf15c")
    ("nf-fa-file_text_o" . "\xf0f6")
    ("nf-fa-file_video" . "\xf1c8")
    ("nf-fa-file_video_o" . "\xf1c8")
    ("nf-fa-file_waveform" . "\xed81")
    ("nf-fa-file_word" . "\xf1c2")
    ("nf-fa-file_word_o" . "\xf1c2")
    ("nf-fa-file_zip_o" . "\xf1c6")
    ("nf-fa-file_zipper" . "\xf1c6")
    ("nf-fa-files_o" . "\xf0c5")
    ("nf-fa-fill" . "\xee3e")
    ("nf-fa-fill_drip" . "\xee3f")
    ("nf-fa-film" . "\xf008")
    ("nf-fa-filter" . "\xf0b0")
    ("nf-fa-filter_circle_dollar" . "\xeec8")
    ("nf-fa-fingerprint" . "\xee40")
    ("nf-fa-fire" . "\xf06d")
    ("nf-fa-fire_extinguisher" . "\xf134")
    ("nf-fa-fire_flame_curved" . "\xef76")
    ("nf-fa-fire_flame_simple" . "\xed78")
    ("nf-fa-firefox" . "\xf269")
    ("nf-fa-first_order" . "\xf2b0")
    ("nf-fa-first_order_alt" . "\xedd4")
    ("nf-fa-firstdraft" . "\xf262")
    ("nf-fa-fish" . "\xee41")
    ("nf-fa-flag" . "\xf024")
    ("nf-fa-flag_checkered" . "\xf11e")
    ("nf-fa-flag_o" . "\xf11d")
    ("nf-fa-flag_usa" . "\xef20")
    ("nf-fa-flash" . "\xf0e7")
    ("nf-fa-flask" . "\xf0c3")
    ("nf-fa-flickr" . "\xf16e")
    ("nf-fa-flipboard" . "\xed68")
    ("nf-fa-floppy_disk" . "\xf0c7")
    ("nf-fa-floppy_o" . "\xf0c7")
    ("nf-fa-fly" . "\xed43")
    ("nf-fa-folder" . "\xf07b")
    ("nf-fa-folder_minus" . "\xeec6")
    ("nf-fa-folder_o" . "\xf114")
    ("nf-fa-folder_open" . "\xf07c")
    ("nf-fa-folder_open_o" . "\xf115")
    ("nf-fa-folder_plus" . "\xeec7")
    ("nf-fa-folder_tree" . "\xef81")
    ("nf-fa-font" . "\xf031")
    ("nf-fa-font_awesome" . "\xf2b4")
    ("nf-fa-fonticons" . "\xf280")
    ("nf-fa-fonticons_fi" . "\xf26f")
    ("nf-fa-football" . "\xed69")
    ("nf-fa-fort_awesome" . "\xf286")
    ("nf-fa-fort_awesome_alt" . "\xf27f")
    ("nf-fa-forumbee" . "\xf211")
    ("nf-fa-forward" . "\xf04e")
    ("nf-fa-forward_fast" . "\xf050")
    ("nf-fa-forward_step" . "\xf051")
    ("nf-fa-foursquare" . "\xf180")
    ("nf-fa-free_code_camp" . "\xf2c5")
    ("nf-fa-freebsd" . "\xf28f")
    ("nf-fa-frog" . "\xedf8")
    ("nf-fa-frown_o" . "\xf119")
    ("nf-fa-fulcrum" . "\xedd5")
    ("nf-fa-futbol" . "\xf1e3")
    ("nf-fa-futbol_o" . "\xf1e3")
    ("nf-fa-galactic_republic" . "\xedd6")
    ("nf-fa-galactic_senate" . "\xedd7")
    ("nf-fa-gamepad" . "\xf11b")
    ("nf-fa-gas_pump" . "\xedf9")
    ("nf-fa-gauge" . "\xeeb2")
    ("nf-fa-gauge_high" . "\xed2f")
    ("nf-fa-gauge_simple" . "\xeeb3")
    ("nf-fa-gauge_simple_high" . "\xf0e4")
    ("nf-fa-gavel" . "\xf0e3")
    ("nf-fa-gbp" . "\xf154")
    ("nf-fa-ge" . "\xf1d1")
    ("nf-fa-gear" . "\xf013")
    ("nf-fa-gears" . "\xf085")
    ("nf-fa-gem" . "\xf219")
    ("nf-fa-genderless" . "\xf22d")
    ("nf-fa-get_pocket" . "\xf265")
    ("nf-fa-gg" . "\xf260")
    ("nf-fa-gg_circle" . "\xf261")
    ("nf-fa-ghost" . "\xeefe")
    ("nf-fa-gift" . "\xf06b")
    ("nf-fa-gifts" . "\xef48")
    ("nf-fa-git" . "\xf1d3")
    ("nf-fa-git_alt" . "\xefa0")
    ("nf-fa-git_square" . "\xf1d2")
    ("nf-fa-github" . "\xf09b")
    ("nf-fa-github_alt" . "\xf113")
    ("nf-fa-github_square" . "\xf092")
    ("nf-fa-gitkraken" . "\xf2ac")
    ("nf-fa-gitlab" . "\xf296")
    ("nf-fa-gitter" . "\xed50")
    ("nf-fa-gittip" . "\xf184")
    ("nf-fa-glass" . "\xf000")
    ("nf-fa-glasses" . "\xedfa")
    ("nf-fa-glide" . "\xf2a5")
    ("nf-fa-glide_g" . "\xf2a6")
    ("nf-fa-globe" . "\xf0ac")
    ("nf-fa-gofore" . "\xf2af")
    ("nf-fa-golf_ball_tee" . "\xed6a")
    ("nf-fa-goodreads" . "\xf2bf")
    ("nf-fa-goodreads_g" . "\xf2cf")
    ("nf-fa-google" . "\xf1a0")
    ("nf-fa-google_drive" . "\xf2df")
    ("nf-fa-google_play" . "\xf2e1")
    ("nf-fa-google_plus" . "\xf0d5")
    ("nf-fa-google_plus_circle" . "\xf2b3")
    ("nf-fa-google_plus_official" . "\xf2b3")
    ("nf-fa-google_plus_square" . "\xf0d4")
    ("nf-fa-google_wallet" . "\xf1ee")
    ("nf-fa-gopuram" . "\xeec9")
    ("nf-fa-graduation_cap" . "\xf19d")
    ("nf-fa-gratipay" . "\xf184")
    ("nf-fa-grav" . "\xf2d6")
    ("nf-fa-greater_than" . "\xedfb")
    ("nf-fa-greater_than_equal" . "\xedfc")
    ("nf-fa-grip" . "\xee56")
    ("nf-fa-grip_lines" . "\xef4c")
    ("nf-fa-grip_lines_vertical" . "\xef4d")
    ("nf-fa-grip_vertical" . "\xee57")
    ("nf-fa-gripfire" . "\xf2e2")
    ("nf-fa-group" . "\xf0c0")
    ("nf-fa-grunt" . "\xf2e3")
    ("nf-fa-guitar" . "\xef4e")
    ("nf-fa-gulp" . "\xf2e4")
    ("nf-fa-h_square" . "\xf0fd")
    ("nf-fa-hacker_news" . "\xf1d4")
    ("nf-fa-hackerrank" . "\xeea5")
    ("nf-fa-hammer" . "\xeeff")
    ("nf-fa-hamsa" . "\xeeca")
    ("nf-fa-hand" . "\xf256")
    ("nf-fa-hand_back_fist" . "\xf255")
    ("nf-fa-hand_dots" . "\xed73")
    ("nf-fa-hand_fist" . "\xeefd")
    ("nf-fa-hand_grab_o" . "\xf255")
    ("nf-fa-hand_holding" . "\xed9a")
    ("nf-fa-hand_holding_dollar" . "\xed9c")
    ("nf-fa-hand_holding_droplet" . "\xed9d")
    ("nf-fa-hand_holding_heart" . "\xed9b")
    ("nf-fa-hand_lizard" . "\xf258")
    ("nf-fa-hand_lizard_o" . "\xf258")
    ("nf-fa-hand_middle_finger" . "\xef83")
    ("nf-fa-hand_o_down" . "\xf0a7")
    ("nf-fa-hand_o_left" . "\xf0a5")
    ("nf-fa-hand_o_right" . "\xf0a4")
    ("nf-fa-hand_o_up" . "\xf0a6")
    ("nf-fa-hand_paper_o" . "\xf256")
    ("nf-fa-hand_peace" . "\xf25b")
    ("nf-fa-hand_peace_o" . "\xf25b")
    ("nf-fa-hand_point_down" . "\xf0a7")
    ("nf-fa-hand_point_left" . "\xf0a5")
    ("nf-fa-hand_point_right" . "\xf0a4")
    ("nf-fa-hand_point_up" . "\xf0a6")
    ("nf-fa-hand_pointer" . "\xf25a")
    ("nf-fa-hand_pointer_o" . "\xf25a")
    ("nf-fa-hand_rock_o" . "\xf255")
    ("nf-fa-hand_scissors" . "\xf257")
    ("nf-fa-hand_scissors_o" . "\xf257")
    ("nf-fa-hand_spock" . "\xf259")
    ("nf-fa-hand_spock_o" . "\xf259")
    ("nf-fa-hand_stop_o" . "\xf256")
    ("nf-fa-hands" . "\xf2a7")
    ("nf-fa-hands_asl_interpreting" . "\xf2a3")
    ("nf-fa-hands_holding" . "\xed9e")
    ("nf-fa-hands_praying" . "\xeedb")
    ("nf-fa-handshake" . "\xf2b5")
    ("nf-fa-handshake_angle" . "\xed9f")
    ("nf-fa-handshake_o" . "\xf2b5")
    ("nf-fa-handshake_simple" . "\xeda0")
    ("nf-fa-hanukiah" . "\xef00")
    ("nf-fa-hard_drive" . "\xf0a0")
    ("nf-fa-hard_of_hearing" . "\xf2a4")
    ("nf-fa-hashtag" . "\xf292")
    ("nf-fa-hat_cowboy" . "\xefb7")
    ("nf-fa-hat_cowboy_side" . "\xefb8")
    ("nf-fa-hat_wizard" . "\xef01")
    ("nf-fa-hdd_o" . "\xf0a0")
    ("nf-fa-header" . "\xf1dc")
    ("nf-fa-heading" . "\xf1dc")
    ("nf-fa-headphones" . "\xf025")
    ("nf-fa-headphones_simple" . "\xee58")
    ("nf-fa-headset" . "\xee59")
    ("nf-fa-heard_o" . "\xf08a")
    ("nf-fa-heart" . "\xf004")
    ("nf-fa-heart_crack" . "\xef4f")
    ("nf-fa-heart_o" . "\xf08a")
    ("nf-fa-heart_pulse" . "\xf21e")
    ("nf-fa-heartbeat" . "\xf21e")
    ("nf-fa-helicopter" . "\xedfd")
    ("nf-fa-helmet_safety" . "\xef84")
    ("nf-fa-highlighter" . "\xee5a")
    ("nf-fa-hippo" . "\xef03")
    ("nf-fa-hips" . "\xed6b")
    ("nf-fa-hire_a_helper" . "\xf2e6")
    ("nf-fa-history" . "\xf1da")
    ("nf-fa-hockey_puck" . "\xed6c")
    ("nf-fa-holly_berry" . "\xef50")
    ("nf-fa-home" . "\xf015")
    ("nf-fa-hooli" . "\xed51")
    ("nf-fa-hornbill" . "\xee5b")
    ("nf-fa-horse" . "\xef04")
    ("nf-fa-horse_head" . "\xef51")
    ("nf-fa-hospital" . "\xf0f8")
    ("nf-fa-hospital_o" . "\xf0f8")
    ("nf-fa-hospital_user" . "\xef86")
    ("nf-fa-hot_tub_person" . "\xee5c")
    ("nf-fa-hotdog" . "\xef87")
    ("nf-fa-hotel" . "\xf236")
    ("nf-fa-hotel_building" . "\xee5d")
    ("nf-fa-hotjar" . "\xf2e7")
    ("nf-fa-hourglass" . "\xf254")
    ("nf-fa-hourglass_1" . "\xf251")
    ("nf-fa-hourglass_2" . "\xf252")
    ("nf-fa-hourglass_3" . "\xf253")
    ("nf-fa-hourglass_end" . "\xf253")
    ("nf-fa-hourglass_half" . "\xf252")
    ("nf-fa-hourglass_o" . "\xf250")
    ("nf-fa-hourglass_start" . "\xf251")
    ("nf-fa-house" . "\xf015")
    ("nf-fa-house_chimney" . "\xef85")
    ("nf-fa-house_chimney_crack" . "\xef05")
    ("nf-fa-house_chimney_medical" . "\xef7b")
    ("nf-fa-houzz" . "\xf27c")
    ("nf-fa-hryvnia_sign" . "\xef06")
    ("nf-fa-html5" . "\xf13b")
    ("nf-fa-hubspot" . "\xf2e8")
    ("nf-fa-hurricane" . "\xef21")
    ("nf-fa-i_cursor" . "\xf246")
    ("nf-fa-ice_cream" . "\xef88")
    ("nf-fa-icicles" . "\xef52")
    ("nf-fa-icons" . "\xefa8")
    ("nf-fa-id_badge" . "\xf2c1")
    ("nf-fa-id_card" . "\xf2c2")
    ("nf-fa-id_card_clip" . "\xed84")
    ("nf-fa-id_card_o" . "\xf2c3")
    ("nf-fa-igloo" . "\xef53")
    ("nf-fa-ils" . "\xf20b")
    ("nf-fa-image" . "\xf03e")
    ("nf-fa-image_portrait" . "\xed19")
    ("nf-fa-images" . "\xf00f")
    ("nf-fa-imdb" . "\xf2d8")
    ("nf-fa-inbox" . "\xf01c")
    ("nf-fa-indent" . "\xf03c")
    ("nf-fa-industry" . "\xf275")
    ("nf-fa-infinity" . "\xedfe")
    ("nf-fa-info" . "\xf129")
    ("nf-fa-info_circle" . "\xf05a")
    ("nf-fa-inr" . "\xf156")
    ("nf-fa-instagram" . "\xf16d")
    ("nf-fa-institution" . "\xf19c")
    ("nf-fa-intercom" . "\xef54")
    ("nf-fa-internet_explorer" . "\xf26b")
    ("nf-fa-intersex" . "\xf224")
    ("nf-fa-invision" . "\xef55")
    ("nf-fa-ioxhost" . "\xf208")
    ("nf-fa-italic" . "\xf033")
    ("nf-fa-itch_io" . "\xef99")
    ("nf-fa-itunes" . "\xf2e9")
    ("nf-fa-itunes_note" . "\xf2eb")
    ("nf-fa-java" . "\xedaf")
    ("nf-fa-jedi" . "\xeecc")
    ("nf-fa-jedi_order" . "\xedd8")
    ("nf-fa-jenkins" . "\xf2ec")
    ("nf-fa-jet_fighter" . "\xf0fb")
    ("nf-fa-jira" . "\xef56")
    ("nf-fa-joget" . "\xf2ed")
    ("nf-fa-joint" . "\xee5e")
    ("nf-fa-joomla" . "\xf1aa")
    ("nf-fa-jpy" . "\xf157")
    ("nf-fa-js" . "\xf2ee")
    ("nf-fa-jsfiddle" . "\xf1cc")
    ("nf-fa-kaaba" . "\xeece")
    ("nf-fa-kaggle" . "\xeea6")
    ("nf-fa-key" . "\xf084")
    ("nf-fa-keybase" . "\xedbf")
    ("nf-fa-keyboard" . "\xf11c")
    ("nf-fa-keyboard_o" . "\xf11c")
    ("nf-fa-keycdn" . "\xf2f0")
    ("nf-fa-khanda" . "\xeecf")
    ("nf-fa-kickstarter" . "\xf2f3")
    ("nf-fa-kickstarter_k" . "\xf2f4")
    ("nf-fa-kit_medical" . "\xed82")
    ("nf-fa-kiwi_bird" . "\xedff")
    ("nf-fa-korvue" . "\xed59")
    ("nf-fa-krw" . "\xf159")
    ("nf-fa-landmark" . "\xeed0")
    ("nf-fa-landmark_dome" . "\xef22")
    ("nf-fa-language" . "\xf1ab")
    ("nf-fa-laptop" . "\xf109")
    ("nf-fa-laptop_code" . "\xeea7")
    ("nf-fa-laptop_medical" . "\xef89")
    ("nf-fa-laravel" . "\xf2f7")
    ("nf-fa-lastfm" . "\xf202")
    ("nf-fa-lastfm_square" . "\xf203")
    ("nf-fa-layer_group" . "\xeea8")
    ("nf-fa-leaf" . "\xf06c")
    ("nf-fa-leanpub" . "\xf212")
    ("nf-fa-left_long" . "\xf04f")
    ("nf-fa-left_right" . "\xf08f")
    ("nf-fa-legal" . "\xf0e3")
    ("nf-fa-lemon" . "\xf094")
    ("nf-fa-lemon_o" . "\xf094")
    ("nf-fa-less" . "\xed48")
    ("nf-fa-less_than" . "\xefc3")
    ("nf-fa-less_than_equal" . "\xefc4")
    ("nf-fa-level_down" . "\xf149")
    ("nf-fa-level_up" . "\xf148")
    ("nf-fa-life_bouy" . "\xf1cd")
    ("nf-fa-life_buoy" . "\xf1cd")
    ("nf-fa-life_ring" . "\xf1cd")
    ("nf-fa-life_saver" . "\xf1cd")
    ("nf-fa-lightbulb" . "\xf0eb")
    ("nf-fa-lightbulb_o" . "\xf0eb")
    ("nf-fa-line" . "\xf2fb")
    ("nf-fa-line_chart" . "\xf201")
    ("nf-fa-link" . "\xf0c1")
    ("nf-fa-link_slash" . "\xf127")
    ("nf-fa-linkedin" . "\xf0e1")
    ("nf-fa-linkedin_in" . "\xf0e1")
    ("nf-fa-linkedin_square" . "\xf08c")
    ("nf-fa-linode" . "\xf2b8")
    ("nf-fa-linux" . "\xf17c")
    ("nf-fa-lira_sign" . "\xf195")
    ("nf-fa-list" . "\xf03a")
    ("nf-fa-list_alt" . "\xf022")
    ("nf-fa-list_check" . "\xf0ae")
    ("nf-fa-list_ol" . "\xf0cb")
    ("nf-fa-list_ul" . "\xf0ca")
    ("nf-fa-location_arrow" . "\xf124")
    ("nf-fa-location_crosshairs" . "\xeea9")
    ("nf-fa-location_dot" . "\xed00")
    ("nf-fa-location_pin" . "\xf041")
    ("nf-fa-lock" . "\xf023")
    ("nf-fa-lock_open" . "\xf2fc")
    ("nf-fa-long_arrow_down" . "\xf175")
    ("nf-fa-long_arrow_left" . "\xf177")
    ("nf-fa-long_arrow_right" . "\xf178")
    ("nf-fa-long_arrow_up" . "\xf176")
    ("nf-fa-low_vision" . "\xf2a8")
    ("nf-fa-lungs" . "\xeeaa")
    ("nf-fa-lyft" . "\xf2fd")
    ("nf-fa-magento" . "\xf2ff")
    ("nf-fa-magic" . "\xf0d0")
    ("nf-fa-magnet" . "\xf076")
    ("nf-fa-magnifying_glass" . "\xf002")
    ("nf-fa-magnifying_glass_dollar" . "\xeedd")
    ("nf-fa-magnifying_glass_location" . "\xeede")
    ("nf-fa-magnifying_glass_minus" . "\xf010")
    ("nf-fa-magnifying_glass_plus" . "\xf00e")
    ("nf-fa-mail_forward" . "\xf064")
    ("nf-fa-mail_reply" . "\xf112")
    ("nf-fa-mail_reply_all" . "\xf122")
    ("nf-fa-mailchimp" . "\xee67")
    ("nf-fa-male" . "\xf183")
    ("nf-fa-mandalorian" . "\xedd9")
    ("nf-fa-map" . "\xf279")
    ("nf-fa-map_location" . "\xee68")
    ("nf-fa-map_location_dot" . "\xee69")
    ("nf-fa-map_marker" . "\xf041")
    ("nf-fa-map_o" . "\xf278")
    ("nf-fa-map_pin" . "\xf276")
    ("nf-fa-map_signs" . "\xf277")
    ("nf-fa-markdown" . "\xeeab")
    ("nf-fa-marker" . "\xee6a")
    ("nf-fa-mars" . "\xf222")
    ("nf-fa-mars_double" . "\xf227")
    ("nf-fa-mars_stroke" . "\xf229")
    ("nf-fa-mars_stroke_h" . "\xf22b")
    ("nf-fa-mars_stroke_right" . "\xf22b")
    ("nf-fa-mars_stroke_up" . "\xf22a")
    ("nf-fa-mars_stroke_v" . "\xf22a")
    ("nf-fa-martini_glass" . "\xee44")
    ("nf-fa-martini_glass_citrus" . "\xee2a")
    ("nf-fa-martini_glass_empty" . "\xf000")
    ("nf-fa-mask" . "\xef07")
    ("nf-fa-masks_theater" . "\xeeb6")
    ("nf-fa-mastodon" . "\xedc0")
    ("nf-fa-maxcdn" . "\xf136")
    ("nf-fa-maximize" . "\xf06f")
    ("nf-fa-mdb" . "\xefb9")
    ("nf-fa-meanpath" . "\xf20c")
    ("nf-fa-medal" . "\xee6b")
    ("nf-fa-medapps" . "\xed01")
    ("nf-fa-medium" . "\xf23a")
    ("nf-fa-medkit" . "\xf0fa")
    ("nf-fa-medrt" . "\xed02")
    ("nf-fa-meetup" . "\xf2e0")
    ("nf-fa-megaport" . "\xee6c")
    ("nf-fa-meh_o" . "\xf11a")
    ("nf-fa-memory" . "\xefc5")
    ("nf-fa-mendeley" . "\xef57")
    ("nf-fa-menorah" . "\xeed2")
    ("nf-fa-mercury" . "\xf223")
    ("nf-fa-message" . "\xf27a")
    ("nf-fa-meteor" . "\xef23")
    ("nf-fa-microchip" . "\xf2db")
    ("nf-fa-microphone" . "\xf130")
    ("nf-fa-microphone_lines" . "\xed03")
    ("nf-fa-microphone_lines_slash" . "\xefc6")
    ("nf-fa-microphone_slash" . "\xf131")
    ("nf-fa-microscope" . "\xeeac")
    ("nf-fa-microsoft" . "\xed04")
    ("nf-fa-minimize" . "\xef3e")
    ("nf-fa-minus" . "\xf068")
    ("nf-fa-minus_circle" . "\xf056")
    ("nf-fa-minus_square" . "\xf146")
    ("nf-fa-minus_square_o" . "\xf147")
    ("nf-fa-mitten" . "\xef58")
    ("nf-fa-mix" . "\xed05")
    ("nf-fa-mixcloud" . "\xf289")
    ("nf-fa-mizuni" . "\xed06")
    ("nf-fa-mobile" . "\xed08")
    ("nf-fa-mobile_button" . "\xed07")
    ("nf-fa-mobile_phone" . "\xf10b")
    ("nf-fa-mobile_screen" . "\xed09")
    ("nf-fa-mobile_screen_button" . "\xf10b")
    ("nf-fa-modx" . "\xf285")
    ("nf-fa-monero" . "\xed0a")
    ("nf-fa-money" . "\xf0d6")
    ("nf-fa-money_bill" . "\xf0d6")
    ("nf-fa-money_bill_1" . "\xed0b")
    ("nf-fa-money_bill_1_wave" . "\xefc8")
    ("nf-fa-money_bill_wave" . "\xefc7")
    ("nf-fa-money_check" . "\xefc9")
    ("nf-fa-money_check_dollar" . "\xefca")
    ("nf-fa-monument" . "\xee6f")
    ("nf-fa-moon" . "\xf186")
    ("nf-fa-moon_o" . "\xf186")
    ("nf-fa-mortar_board" . "\xf19d")
    ("nf-fa-mortar_pestle" . "\xee70")
    ("nf-fa-mosque" . "\xeed3")
    ("nf-fa-motorcycle" . "\xf21c")
    ("nf-fa-mountain" . "\xef08")
    ("nf-fa-mouse_pointer" . "\xf245")
    ("nf-fa-mug_hot" . "\xef59")
    ("nf-fa-mug_saucer" . "\xf0f4")
    ("nf-fa-music" . "\xf001")
    ("nf-fa-napster" . "\xed0c")
    ("nf-fa-navicon" . "\xf0c9")
    ("nf-fa-neos" . "\xeead")
    ("nf-fa-network_wired" . "\xef09")
    ("nf-fa-neuter" . "\xf22c")
    ("nf-fa-newspaper" . "\xf1ea")
    ("nf-fa-newspaper_o" . "\xf1ea")
    ("nf-fa-nimblr" . "\xee71")
    ("nf-fa-node" . "\xed44")
    ("nf-fa-node_js" . "\xed0d")
    ("nf-fa-not_equal" . "\xefcb")
    ("nf-fa-note_sticky" . "\xf249")
    ("nf-fa-notes_medical" . "\xed85")
    ("nf-fa-npm" . "\xed0e")
    ("nf-fa-ns8" . "\xed0f")
    ("nf-fa-nutritionix" . "\xed10")
    ("nf-fa-object_group" . "\xf247")
    ("nf-fa-object_ungroup" . "\xf248")
    ("nf-fa-odnoklassniki" . "\xf263")
    ("nf-fa-odnoklassniki_square" . "\xf264")
    ("nf-fa-oil_can" . "\xeeae")
    ("nf-fa-ok_sign" . "\xf058")
    ("nf-fa-old_republic" . "\xedda")
    ("nf-fa-om" . "\xeed4")
    ("nf-fa-opencart" . "\xf23d")
    ("nf-fa-openid" . "\xf19b")
    ("nf-fa-opera" . "\xf26a")
    ("nf-fa-optin_monster" . "\xf23c")
    ("nf-fa-orcid" . "\xefbb")
    ("nf-fa-osi" . "\xed45")
    ("nf-fa-otter" . "\xef0a")
    ("nf-fa-outdent" . "\xf03b")
    ("nf-fa-page4" . "\xed11")
    ("nf-fa-pagelines" . "\xf18c")
    ("nf-fa-pager" . "\xef8a")
    ("nf-fa-paint_brush" . "\xf1fc")
    ("nf-fa-paint_roller" . "\xee72")
    ("nf-fa-paintbrush" . "\xf1fc")
    ("nf-fa-palette" . "\xefcc")
    ("nf-fa-palfed" . "\xed12")
    ("nf-fa-pallet" . "\xed86")
    ("nf-fa-paper_plane" . "\xf1d8")
    ("nf-fa-paper_plane_o" . "\xf1d9")
    ("nf-fa-paperclip" . "\xf0c6")
    ("nf-fa-parachute_box" . "\xeda1")
    ("nf-fa-paragraph" . "\xf1dd")
    ("nf-fa-passport" . "\xee73")
    ("nf-fa-paste" . "\xf0ea")
    ("nf-fa-patreon" . "\xed13")
    ("nf-fa-pause" . "\xf04c")
    ("nf-fa-pause_circle" . "\xf28b")
    ("nf-fa-pause_circle_o" . "\xf28c")
    ("nf-fa-paw" . "\xf1b0")
    ("nf-fa-paypal" . "\xf1ed")
    ("nf-fa-peace" . "\xeed6")
    ("nf-fa-pen" . "\xf01f")
    ("nf-fa-pen_clip" . "\xf020")
    ("nf-fa-pen_fancy" . "\xee74")
    ("nf-fa-pen_nib" . "\xee75")
    ("nf-fa-pen_ruler" . "\xee76")
    ("nf-fa-pen_to_square" . "\xf044")
    ("nf-fa-pencil" . "\xf040")
    ("nf-fa-pencil_square" . "\xf14b")
    ("nf-fa-pencil_square_o" . "\xf044")
    ("nf-fa-people_carry_box" . "\xeda2")
    ("nf-fa-pepper_hot" . "\xef8b")
    ("nf-fa-percent" . "\xf295")
    ("nf-fa-periscope" . "\xed14")
    ("nf-fa-person" . "\xf183")
    ("nf-fa-person_biking" . "\xefa2")
    ("nf-fa-person_booth" . "\xef24")
    ("nf-fa-person_digging" . "\xefa6")
    ("nf-fa-person_dots_from_line" . "\xed7c")
    ("nf-fa-person_dress" . "\xf182")
    ("nf-fa-person_hiking" . "\xef02")
    ("nf-fa-person_praying" . "\xeeda")
    ("nf-fa-person_running" . "\xef0c")
    ("nf-fa-person_skating" . "\xef63")
    ("nf-fa-person_skiing" . "\xef65")
    ("nf-fa-person_skiing_nordic" . "\xef66")
    ("nf-fa-person_snowboarding" . "\xef69")
    ("nf-fa-person_swimming" . "\xee8b")
    ("nf-fa-person_walking" . "\xee1d")
    ("nf-fa-person_walking_with_cane" . "\xf29d")
    ("nf-fa-phabricator" . "\xed15")
    ("nf-fa-phoenix_framework" . "\xed16")
    ("nf-fa-phoenix_squadron" . "\xeddb")
    ("nf-fa-phone" . "\xf095")
    ("nf-fa-phone_flip" . "\xefa9")
    ("nf-fa-phone_slash" . "\xed17")
    ("nf-fa-phone_square" . "\xf098")
    ("nf-fa-phone_volume" . "\xf2a0")
    ("nf-fa-photo" . "\xf03e")
    ("nf-fa-photo_film" . "\xefab")
    ("nf-fa-php" . "\xed6d")
    ("nf-fa-picture_o" . "\xf03e")
    ("nf-fa-pie_chart" . "\xf200")
    ("nf-fa-pied_piper" . "\xf2ae")
    ("nf-fa-pied_piper_alt" . "\xf1a8")
    ("nf-fa-pied_piper_hat" . "\xedb0")
    ("nf-fa-pied_piper_pp" . "\xf1a7")
    ("nf-fa-piggy_bank" . "\xeda3")
    ("nf-fa-pills" . "\xed87")
    ("nf-fa-pinterest" . "\xf0d2")
    ("nf-fa-pinterest_p" . "\xf231")
    ("nf-fa-pinterest_square" . "\xf0d3")
    ("nf-fa-pizza_slice" . "\xef8c")
    ("nf-fa-place_of_worship" . "\xeed7")
    ("nf-fa-plane" . "\xf072")
    ("nf-fa-plane_arrival" . "\xee77")
    ("nf-fa-plane_departure" . "\xee78")
    ("nf-fa-play" . "\xf04b")
    ("nf-fa-play_circle" . "\xf144")
    ("nf-fa-play_circle_o" . "\xf01d")
    ("nf-fa-playstation" . "\xed18")
    ("nf-fa-plug" . "\xf1e6")
    ("nf-fa-plus" . "\xf067")
    ("nf-fa-plus_circle" . "\xf055")
    ("nf-fa-plus_square" . "\xf0fe")
    ("nf-fa-plus_square_o" . "\xf196")
    ("nf-fa-podcast" . "\xf2ce")
    ("nf-fa-poo" . "\xf2fe")
    ("nf-fa-poo_storm" . "\xef25")
    ("nf-fa-poop" . "\xeeaf")
    ("nf-fa-power_off" . "\xf011")
    ("nf-fa-prescription" . "\xee79")
    ("nf-fa-prescription_bottle" . "\xed88")
    ("nf-fa-prescription_bottle_medical" . "\xed89")
    ("nf-fa-print" . "\xf02f")
    ("nf-fa-product_hunt" . "\xf288")
    ("nf-fa-pushed" . "\xed1a")
    ("nf-fa-puzzle_piece" . "\xf12e")
    ("nf-fa-python" . "\xed1b")
    ("nf-fa-qq" . "\xf1d6")
    ("nf-fa-qrcode" . "\xf029")
    ("nf-fa-question" . "\xf128")
    ("nf-fa-question_circle" . "\xf059")
    ("nf-fa-question_circle_o" . "\xf29c")
    ("nf-fa-quinscape" . "\xed6f")
    ("nf-fa-quora" . "\xf2c4")
    ("nf-fa-quote_left" . "\xf10d")
    ("nf-fa-quote_right" . "\xf10e")
    ("nf-fa-r_project" . "\xedc1")
    ("nf-fa-ra" . "\xf1d0")
    ("nf-fa-radiation" . "\xef5a")
    ("nf-fa-radio" . "\xefbc")
    ("nf-fa-rainbow" . "\xef26")
    ("nf-fa-random" . "\xf074")
    ("nf-fa-raspberry_pi" . "\xef5c")
    ("nf-fa-ravelry" . "\xf2d9")
    ("nf-fa-react" . "\xed46")
    ("nf-fa-reacteurope" . "\xef27")
    ("nf-fa-readme" . "\xeda4")
    ("nf-fa-rebel" . "\xf1d0")
    ("nf-fa-receipt" . "\xee0c")
    ("nf-fa-record_vinyl" . "\xefbd")
    ("nf-fa-rectangle_ad" . "\xeebb")
    ("nf-fa-rectangle_list" . "\xf022")
    ("nf-fa-rectangle_xmark" . "\xf2d4")
    ("nf-fa-recycle" . "\xf1b8")
    ("nf-fa-red_river" . "\xed1c")
    ("nf-fa-reddit" . "\xf1a1")
    ("nf-fa-reddit_alien" . "\xf281")
    ("nf-fa-reddit_square" . "\xf1a2")
    ("nf-fa-redhat" . "\xef5d")
    ("nf-fa-refresh" . "\xf021")
    ("nf-fa-registered" . "\xf25d")
    ("nf-fa-remove" . "\xf00d")
    ("nf-fa-remove_sign" . "\xf057")
    ("nf-fa-renren" . "\xf18b")
    ("nf-fa-reorder" . "\xf0c9")
    ("nf-fa-repeat" . "\xf01e")
    ("nf-fa-repeat_alt" . "\xf0b6")
    ("nf-fa-reply" . "\xf112")
    ("nf-fa-reply_all" . "\xf122")
    ("nf-fa-replyd" . "\xed1e")
    ("nf-fa-republican" . "\xef28")
    ("nf-fa-researchgate" . "\xedc2")
    ("nf-fa-resistance" . "\xf1d0")
    ("nf-fa-resolving" . "\xed1f")
    ("nf-fa-restroom" . "\xef5e")
    ("nf-fa-retweet" . "\xf079")
    ("nf-fa-rev" . "\xee7a")
    ("nf-fa-ribbon" . "\xeda5")
    ("nf-fa-right_from_bracket" . "\xf2f5")
    ("nf-fa-right_left" . "\xf0b5")
    ("nf-fa-right_to_bracket" . "\xf2f6")
    ("nf-fa-ring" . "\xef0b")
    ("nf-fa-rmb" . "\xf157")
    ("nf-fa-road" . "\xf018")
    ("nf-fa-robot" . "\xee0d")
    ("nf-fa-rocket" . "\xf135")
    ("nf-fa-rocketchat" . "\xed20")
    ("nf-fa-rockrms" . "\xed21")
    ("nf-fa-rotate" . "\xf2f1")
    ("nf-fa-rotate_left" . "\xf2ea")
    ("nf-fa-rotate_right" . "\xf2f9")
    ("nf-fa-rouble" . "\xf158")
    ("nf-fa-route" . "\xeda6")
    ("nf-fa-rss" . "\xf09e")
    ("nf-fa-rss_square" . "\xf143")
    ("nf-fa-rub" . "\xf158")
    ("nf-fa-ruble" . "\xf158")
    ("nf-fa-ruble_sign" . "\xf158")
    ("nf-fa-ruler" . "\xee0e")
    ("nf-fa-ruler_combined" . "\xee0f")
    ("nf-fa-ruler_horizontal" . "\xee10")
    ("nf-fa-ruler_vertical" . "\xee11")
    ("nf-fa-rupee" . "\xf156")
    ("nf-fa-rupee_sign" . "\xf156")
    ("nf-fa-s15" . "\xf2cd")
    ("nf-fa-sack_dollar" . "\xef8d")
    ("nf-fa-safari" . "\xf267")
    ("nf-fa-salesforce" . "\xef9a")
    ("nf-fa-sass" . "\xed49")
    ("nf-fa-satellite" . "\xef5f")
    ("nf-fa-satellite_dish" . "\xef60")
    ("nf-fa-save" . "\xf0c7")
    ("nf-fa-scale_balanced" . "\xf24e")
    ("nf-fa-scale_unbalanced" . "\xeddf")
    ("nf-fa-scale_unbalanced_flip" . "\xede0")
    ("nf-fa-schlix" . "\xed22")
    ("nf-fa-school" . "\xee12")
    ("nf-fa-scissors" . "\xf0c4")
    ("nf-fa-screwdriver" . "\xee13")
    ("nf-fa-screwdriver_wrench" . "\xef70")
    ("nf-fa-scribd" . "\xf28a")
    ("nf-fa-scroll" . "\xef0d")
    ("nf-fa-scroll_torah" . "\xeee5")
    ("nf-fa-sd_card" . "\xef61")
    ("nf-fa-search" . "\xf002")
    ("nf-fa-search_minus" . "\xf010")
    ("nf-fa-search_plus" . "\xf00e")
    ("nf-fa-searchengin" . "\xed23")
    ("nf-fa-seedling" . "\xeda7")
    ("nf-fa-sellcast" . "\xf2da")
    ("nf-fa-sellsy" . "\xf213")
    ("nf-fa-send" . "\xf1d8")
    ("nf-fa-send_o" . "\xf1d9")
    ("nf-fa-server" . "\xf233")
    ("nf-fa-servicestack" . "\xed24")
    ("nf-fa-shapes" . "\xeeb0")
    ("nf-fa-share" . "\xf064")
    ("nf-fa-share_alt" . "\xf1e0")
    ("nf-fa-share_alt_square" . "\xf1e1")
    ("nf-fa-share_from_square" . "\xf14d")
    ("nf-fa-share_nodes" . "\xf1e0")
    ("nf-fa-share_square" . "\xf14d")
    ("nf-fa-share_square_o" . "\xf045")
    ("nf-fa-shekel" . "\xf20b")
    ("nf-fa-shekel_sign" . "\xf20b")
    ("nf-fa-sheqel" . "\xf20b")
    ("nf-fa-shield" . "\xf132")
    ("nf-fa-shield_halved" . "\xed25")
    ("nf-fa-ship" . "\xf21a")
    ("nf-fa-shirt" . "\xee1c")
    ("nf-fa-shirtsinbulk" . "\xf214")
    ("nf-fa-shoe_prints" . "\xee14")
    ("nf-fa-shop" . "\xee18")
    ("nf-fa-shopping_bag" . "\xf290")
    ("nf-fa-shopping_basket" . "\xf291")
    ("nf-fa-shopping_cart" . "\xf07a")
    ("nf-fa-shopware" . "\xee7d")
    ("nf-fa-shower" . "\xf2cc")
    ("nf-fa-shuffle" . "\xf074")
    ("nf-fa-shuttle_space" . "\xf197")
    ("nf-fa-sign_hanging" . "\xeda8")
    ("nf-fa-sign_in" . "\xf090")
    ("nf-fa-sign_language" . "\xf2a7")
    ("nf-fa-sign_out" . "\xf08b")
    ("nf-fa-signal" . "\xf012")
    ("nf-fa-signature" . "\xee7f")
    ("nf-fa-signing" . "\xf2a7")
    ("nf-fa-signs_post" . "\xf277")
    ("nf-fa-sim_card" . "\xef62")
    ("nf-fa-simplybuilt" . "\xf215")
    ("nf-fa-sistrix" . "\xed26")
    ("nf-fa-sitemap" . "\xf0e8")
    ("nf-fa-sith" . "\xeddc")
    ("nf-fa-sketch" . "\xef64")
    ("nf-fa-skull" . "\xee15")
    ("nf-fa-skull_crossbones" . "\xef0e")
    ("nf-fa-skyatlas" . "\xf216")
    ("nf-fa-skype" . "\xf17e")
    ("nf-fa-slack" . "\xf198")
    ("nf-fa-slash" . "\xef0f")
    ("nf-fa-sleigh" . "\xef67")
    ("nf-fa-sliders" . "\xf1de")
    ("nf-fa-slideshare" . "\xf1e7")
    ("nf-fa-smile_o" . "\xf118")
    ("nf-fa-smog" . "\xef29")
    ("nf-fa-smoking" . "\xed8c")
    ("nf-fa-snapchat" . "\xf2ab")
    ("nf-fa-snapchat_ghost" . "\xf2ac")
    ("nf-fa-snapchat_square" . "\xf2ad")
    ("nf-fa-snowflake" . "\xf2dc")
    ("nf-fa-snowflake_o" . "\xf2dc")
    ("nf-fa-snowman" . "\xef6a")
    ("nf-fa-snowplow" . "\xef6b")
    ("nf-fa-soccer_ball_o" . "\xf1e3")
    ("nf-fa-socks" . "\xeedf")
    ("nf-fa-solar_panel" . "\xee81")
    ("nf-fa-sort" . "\xf0dc")
    ("nf-fa-sort_alpha_asc" . "\xf15d")
    ("nf-fa-sort_alpha_desc" . "\xf15e")
    ("nf-fa-sort_amount_asc" . "\xf160")
    ("nf-fa-sort_amount_desc" . "\xf161")
    ("nf-fa-sort_asc" . "\xf0de")
    ("nf-fa-sort_desc" . "\xf0dd")
    ("nf-fa-sort_down" . "\xf0dd")
    ("nf-fa-sort_numeric_asc" . "\xf162")
    ("nf-fa-sort_numeric_desc" . "\xf163")
    ("nf-fa-sort_up" . "\xf0de")
    ("nf-fa-soundcloud" . "\xf1be")
    ("nf-fa-sourcetree" . "\xef6c")
    ("nf-fa-spa" . "\xee82")
    ("nf-fa-space_shuttle" . "\xf197")
    ("nf-fa-spaghetti_monster_flying" . "\xeed5")
    ("nf-fa-speakap" . "\xed27")
    ("nf-fa-speaker_deck" . "\xef9b")
    ("nf-fa-spell_check" . "\xefb3")
    ("nf-fa-spider" . "\xef10")
    ("nf-fa-spinner" . "\xf110")
    ("nf-fa-splotch" . "\xee83")
    ("nf-fa-spoon" . "\xf1b1")
    ("nf-fa-spotify" . "\xf1bc")
    ("nf-fa-spray_can" . "\xee84")
    ("nf-fa-spray_can_sparkles" . "\xee97")
    ("nf-fa-square" . "\xf0c8")
    ("nf-fa-square_arrow_up_right" . "\xf14c")
    ("nf-fa-square_behance" . "\xf1b5")
    ("nf-fa-square_caret_down" . "\xf150")
    ("nf-fa-square_caret_left" . "\xf191")
    ("nf-fa-square_caret_right" . "\xf152")
    ("nf-fa-square_caret_up" . "\xf151")
    ("nf-fa-square_check" . "\xf14a")
    ("nf-fa-square_dribbble" . "\xf22e")
    ("nf-fa-square_envelope" . "\xf199")
    ("nf-fa-square_facebook" . "\xf082")
    ("nf-fa-square_font_awesome_stroke" . "\xf0af")
    ("nf-fa-square_full" . "\xed70")
    ("nf-fa-square_git" . "\xf1d2")
    ("nf-fa-square_github" . "\xf092")
    ("nf-fa-square_google_plus" . "\xf0d4")
    ("nf-fa-square_h" . "\xf0fd")
    ("nf-fa-square_hacker_news" . "\xf2e5")
    ("nf-fa-square_js" . "\xf2ef")
    ("nf-fa-square_lastfm" . "\xf203")
    ("nf-fa-square_minus" . "\xf146")
    ("nf-fa-square_o" . "\xf096")
    ("nf-fa-square_odnoklassniki" . "\xf264")
    ("nf-fa-square_parking" . "\xefcd")
    ("nf-fa-square_pen" . "\xf14b")
    ("nf-fa-square_phone" . "\xf098")
    ("nf-fa-square_phone_flip" . "\xefaa")
    ("nf-fa-square_pinterest" . "\xf0d3")
    ("nf-fa-square_plus" . "\xf0fe")
    ("nf-fa-square_poll_horizontal" . "\xeed9")
    ("nf-fa-square_poll_vertical" . "\xeed8")
    ("nf-fa-square_reddit" . "\xf1a2")
    ("nf-fa-square_root_variable" . "\xeee0")
    ("nf-fa-square_rss" . "\xf143")
    ("nf-fa-square_share_nodes" . "\xf1e1")
    ("nf-fa-square_snapchat" . "\xf2ad")
    ("nf-fa-square_steam" . "\xf1b7")
    ("nf-fa-square_tumblr" . "\xf174")
    ("nf-fa-square_twitter" . "\xf081")
    ("nf-fa-square_up_right" . "\xf0b4")
    ("nf-fa-square_viadeo" . "\xf2aa")
    ("nf-fa-square_vimeo" . "\xf194")
    ("nf-fa-square_whatsapp" . "\xed3b")
    ("nf-fa-square_xing" . "\xf169")
    ("nf-fa-square_xmark" . "\xf2d3")
    ("nf-fa-square_youtube" . "\xf166")
    ("nf-fa-squarespace" . "\xee85")
    ("nf-fa-stack_exchange" . "\xf18d")
    ("nf-fa-stack_overflow" . "\xf16c")
    ("nf-fa-stackpath" . "\xefa1")
    ("nf-fa-stamp" . "\xee86")
    ("nf-fa-star" . "\xf005")
    ("nf-fa-star_and_crescent" . "\xeee1")
    ("nf-fa-star_half" . "\xf089")
    ("nf-fa-star_half_empty" . "\xf123")
    ("nf-fa-star_half_full" . "\xf123")
    ("nf-fa-star_half_o" . "\xf123")
    ("nf-fa-star_half_stroke" . "\xee87")
    ("nf-fa-star_o" . "\xf006")
    ("nf-fa-star_of_david" . "\xeee2")
    ("nf-fa-star_of_life" . "\xeeb1")
    ("nf-fa-staylinked" . "\xed28")
    ("nf-fa-steam" . "\xf1b6")
    ("nf-fa-steam_square" . "\xf1b7")
    ("nf-fa-steam_symbol" . "\xed29")
    ("nf-fa-step_backward" . "\xf048")
    ("nf-fa-step_forward" . "\xf051")
    ("nf-fa-sterling_sign" . "\xf154")
    ("nf-fa-stethoscope" . "\xf0f1")
    ("nf-fa-sticker_mule" . "\xed2a")
    ("nf-fa-sticky_note" . "\xf249")
    ("nf-fa-sticky_note_o" . "\xf24a")
    ("nf-fa-stop" . "\xf04d")
    ("nf-fa-stop_circle" . "\xf28d")
    ("nf-fa-stop_circle_o" . "\xf28e")
    ("nf-fa-stopwatch" . "\xf2f2")
    ("nf-fa-store" . "\xee17")
    ("nf-fa-strava" . "\xed52")
    ("nf-fa-street_view" . "\xf21d")
    ("nf-fa-strikethrough" . "\xf0cc")
    ("nf-fa-stripe" . "\xed53")
    ("nf-fa-stripe_s" . "\xed54")
    ("nf-fa-stroopwafel" . "\xee1a")
    ("nf-fa-studiovinari" . "\xed2b")
    ("nf-fa-stumbleupon" . "\xf1a4")
    ("nf-fa-stumbleupon_circle" . "\xf1a3")
    ("nf-fa-subscript" . "\xf12c")
    ("nf-fa-subway" . "\xf239")
    ("nf-fa-suitcase" . "\xf0f2")
    ("nf-fa-suitcase_medical" . "\xf0fa")
    ("nf-fa-suitcase_rolling" . "\xee88")
    ("nf-fa-sun" . "\xf185")
    ("nf-fa-sun_o" . "\xf185")
    ("nf-fa-superpowers" . "\xf2dd")
    ("nf-fa-superscript" . "\xf12b")
    ("nf-fa-supple" . "\xed2c")
    ("nf-fa-support" . "\xf1cd")
    ("nf-fa-suse" . "\xef6d")
    ("nf-fa-swatchbook" . "\xee8a")
    ("nf-fa-swift" . "\xefbe")
    ("nf-fa-symfony" . "\xef9c")
    ("nf-fa-synagogue" . "\xeee3")
    ("nf-fa-syringe" . "\xed8d")
    ("nf-fa-table" . "\xf0ce")
    ("nf-fa-table_cells" . "\xf00a")
    ("nf-fa-table_cells_large" . "\xf009")
    ("nf-fa-table_columns" . "\xf0db")
    ("nf-fa-table_list" . "\xf00b")
    ("nf-fa-table_tennis_paddle_ball" . "\xed71")
    ("nf-fa-tablet" . "\xed2e")
    ("nf-fa-tablet_button" . "\xed2d")
    ("nf-fa-tablet_screen_button" . "\xf10a")
    ("nf-fa-tablets" . "\xed8e")
    ("nf-fa-tachograph_digital" . "\xee2f")
    ("nf-fa-tachometer" . "\xf0e4")
    ("nf-fa-tag" . "\xf02b")
    ("nf-fa-tags" . "\xf02c")
    ("nf-fa-tape" . "\xedaa")
    ("nf-fa-tasks" . "\xf0ae")
    ("nf-fa-taxi" . "\xf1ba")
    ("nf-fa-teamspeak" . "\xedc3")
    ("nf-fa-teeth" . "\xeeb4")
    ("nf-fa-teeth_open" . "\xeeb5")
    ("nf-fa-telegram" . "\xf2c6")
    ("nf-fa-television" . "\xf26c")
    ("nf-fa-temperature_empty" . "\xf2cb")
    ("nf-fa-temperature_full" . "\xf2c7")
    ("nf-fa-temperature_half" . "\xf2c9")
    ("nf-fa-temperature_high" . "\xef2a")
    ("nf-fa-temperature_low" . "\xef2b")
    ("nf-fa-temperature_quarter" . "\xf2ca")
    ("nf-fa-temperature_three_quarters" . "\xf2c8")
    ("nf-fa-tencent_weibo" . "\xf1d5")
    ("nf-fa-tenge_sign" . "\xef6e")
    ("nf-fa-terminal" . "\xf120")
    ("nf-fa-text_height" . "\xf034")
    ("nf-fa-text_slash" . "\xefac")
    ("nf-fa-text_width" . "\xf035")
    ("nf-fa-th" . "\xf00a")
    ("nf-fa-th_large" . "\xf009")
    ("nf-fa-th_list" . "\xf00b")
    ("nf-fa-the_red_yeti" . "\xeee4")
    ("nf-fa-themeco" . "\xee8d")
    ("nf-fa-themeisle" . "\xf2b2")
    ("nf-fa-thermometer" . "\xf2c7")
    ("nf-fa-thermometer_0" . "\xf2cb")
    ("nf-fa-thermometer_1" . "\xf2ca")
    ("nf-fa-thermometer_2" . "\xf2c9")
    ("nf-fa-thermometer_3" . "\xf2c8")
    ("nf-fa-thermometer_4" . "\xf2c7")
    ("nf-fa-thermometer_alt" . "\xed8f")
    ("nf-fa-thermometer_empty" . "\xf2cb")
    ("nf-fa-thermometer_full" . "\xf2c7")
    ("nf-fa-thermometer_half" . "\xf2c9")
    ("nf-fa-thermometer_quarter" . "\xf2ca")
    ("nf-fa-thermometer_three_quarters" . "\xf2c8")
    ("nf-fa-think_peaks" . "\xef19")
    ("nf-fa-thumb_tack" . "\xf08d")
    ("nf-fa-thumbs_down" . "\xf165")
    ("nf-fa-thumbs_o_down" . "\xf088")
    ("nf-fa-thumbs_o_up" . "\xf087")
    ("nf-fa-thumbs_up" . "\xf164")
    ("nf-fa-thumbtack" . "\xf08d")
    ("nf-fa-ticket" . "\xf145")
    ("nf-fa-ticket_simple" . "\xed30")
    ("nf-fa-times" . "\xf00d")
    ("nf-fa-times_circle" . "\xf057")
    ("nf-fa-times_circle_o" . "\xf05c")
    ("nf-fa-times_rectangle" . "\xf2d3")
    ("nf-fa-times_rectangle_o" . "\xf2d4")
    ("nf-fa-tint" . "\xf043")
    ("nf-fa-toggle_down" . "\xf150")
    ("nf-fa-toggle_left" . "\xf191")
    ("nf-fa-toggle_off" . "\xf204")
    ("nf-fa-toggle_on" . "\xf205")
    ("nf-fa-toggle_right" . "\xf152")
    ("nf-fa-toggle_up" . "\xf151")
    ("nf-fa-toilet" . "\xef6f")
    ("nf-fa-toilet_paper" . "\xef11")
    ("nf-fa-toolbox" . "\xee1b")
    ("nf-fa-tooth" . "\xee90")
    ("nf-fa-torii_gate" . "\xeee6")
    ("nf-fa-tornado" . "\xef2d")
    ("nf-fa-tower_broadcast" . "\xede3")
    ("nf-fa-tractor" . "\xef12")
    ("nf-fa-trade_federation" . "\xeddd")
    ("nf-fa-trademark" . "\xf25c")
    ("nf-fa-traffic_light" . "\xeeb7")
    ("nf-fa-train" . "\xf238")
    ("nf-fa-train_subway" . "\xf239")
    ("nf-fa-transgender" . "\xf224")
    ("nf-fa-transgender_alt" . "\xf225")
    ("nf-fa-trash" . "\xf1f8")
    ("nf-fa-trash_arrow_up" . "\xef90")
    ("nf-fa-trash_can" . "\xf014")
    ("nf-fa-trash_can_arrow_up" . "\xef91")
    ("nf-fa-trash_o" . "\xf014")
    ("nf-fa-tree" . "\xf1bb")
    ("nf-fa-trello" . "\xf181")
    ("nf-fa-triangle_exclamation" . "\xf071")
    ("nf-fa-tripadvisor" . "\xf262")
    ("nf-fa-trophy" . "\xf091")
    ("nf-fa-truck" . "\xf0d1")
    ("nf-fa-truck_fast" . "\xed8b")
    ("nf-fa-truck_medical" . "\xf0f9")
    ("nf-fa-truck_monster" . "\xeeb8")
    ("nf-fa-truck_moving" . "\xedac")
    ("nf-fa-truck_pickup" . "\xeeb9")
    ("nf-fa-truck_ramp_box" . "\xedab")
    ("nf-fa-try" . "\xf195")
    ("nf-fa-tty" . "\xf1e4")
    ("nf-fa-tumblr" . "\xf173")
    ("nf-fa-tumblr_square" . "\xf174")
    ("nf-fa-turkish_lira" . "\xf195")
    ("nf-fa-turn_down" . "\xf2f8")
    ("nf-fa-turn_up" . "\xf2fa")
    ("nf-fa-tv" . "\xf26c")
    ("nf-fa-twitch" . "\xf1e8")
    ("nf-fa-twitter" . "\xf099")
    ("nf-fa-twitter_square" . "\xf081")
    ("nf-fa-typo3" . "\xed55")
    ("nf-fa-uber" . "\xed31")
    ("nf-fa-ubuntu" . "\xef72")
    ("nf-fa-uikit" . "\xed32")
    ("nf-fa-umbraco" . "\xefbf")
    ("nf-fa-umbrella" . "\xf0e9")
    ("nf-fa-umbrella_beach" . "\xee91")
    ("nf-fa-underline" . "\xf0cd")
    ("nf-fa-undo" . "\xf0e2")
    ("nf-fa-uniregistry" . "\xed33")
    ("nf-fa-universal_access" . "\xf29a")
    ("nf-fa-university" . "\xf19c")
    ("nf-fa-unlink" . "\xf127")
    ("nf-fa-unlock" . "\xf09c")
    ("nf-fa-unlock_alt" . "\xf13e")
    ("nf-fa-unlock_keyhole" . "\xf13e")
    ("nf-fa-unsorted" . "\xf0dc")
    ("nf-fa-untappd" . "\xed34")
    ("nf-fa-up_down" . "\xf09f")
    ("nf-fa-up_down_left_right" . "\xf0b2")
    ("nf-fa-up_right_and_down_left_from_center" . "\xed4f")
    ("nf-fa-up_right_from_square" . "\xf0b3")
    ("nf-fa-upload" . "\xf093")
    ("nf-fa-ups" . "\xef73")
    ("nf-fa-usb" . "\xf287")
    ("nf-fa-usd" . "\xf155")
    ("nf-fa-user" . "\xf007")
    ("nf-fa-user_astronaut" . "\xedc5")
    ("nf-fa-user_check" . "\xedc6")
    ("nf-fa-user_circle" . "\xf2bd")
    ("nf-fa-user_circle_o" . "\xf2be")
    ("nf-fa-user_clock" . "\xedc7")
    ("nf-fa-user_doctor" . "\xf0f0")
    ("nf-fa-user_gear" . "\xedc8")
    ("nf-fa-user_graduate" . "\xedcb")
    ("nf-fa-user_group" . "\xedca")
    ("nf-fa-user_injured" . "\xef13")
    ("nf-fa-user_large" . "\xed35")
    ("nf-fa-user_large_slash" . "\xedc4")
    ("nf-fa-user_lock" . "\xedcc")
    ("nf-fa-user_md" . "\xf0f0")
    ("nf-fa-user_minus" . "\xedcd")
    ("nf-fa-user_ninja" . "\xedce")
    ("nf-fa-user_nurse" . "\xef92")
    ("nf-fa-user_o" . "\xf2c0")
    ("nf-fa-user_pen" . "\xedc9")
    ("nf-fa-user_plus" . "\xf234")
    ("nf-fa-user_secret" . "\xf21b")
    ("nf-fa-user_shield" . "\xedcf")
    ("nf-fa-user_slash" . "\xedd0")
    ("nf-fa-user_tag" . "\xedd1")
    ("nf-fa-user_tie" . "\xedd2")
    ("nf-fa-user_times" . "\xf235")
    ("nf-fa-user_xmark" . "\xf235")
    ("nf-fa-users" . "\xf0c0")
    ("nf-fa-users_gear" . "\xedd3")
    ("nf-fa-usps" . "\xef74")
    ("nf-fa-ussunnah" . "\xed36")
    ("nf-fa-utensils" . "\xf0f5")
    ("nf-fa-vaadin" . "\xed37")
    ("nf-fa-van_shuttle" . "\xee7e")
    ("nf-fa-vcard" . "\xf2bb")
    ("nf-fa-vcard_o" . "\xf2bc")
    ("nf-fa-vector_square" . "\xee92")
    ("nf-fa-venus" . "\xf221")
    ("nf-fa-venus_double" . "\xf226")
    ("nf-fa-venus_mars" . "\xf228")
    ("nf-fa-viacoin" . "\xf237")
    ("nf-fa-viadeo" . "\xf2a9")
    ("nf-fa-viadeo_square" . "\xf2aa")
    ("nf-fa-vial" . "\xed90")
    ("nf-fa-vials" . "\xed91")
    ("nf-fa-viber" . "\xed38")
    ("nf-fa-video" . "\xf03d")
    ("nf-fa-video_camera" . "\xf03d")
    ("nf-fa-video_slash" . "\xedad")
    ("nf-fa-vihara" . "\xeee7")
    ("nf-fa-vimeo" . "\xed39")
    ("nf-fa-vimeo_square" . "\xf194")
    ("nf-fa-vimeo_v" . "\xf27d")
    ("nf-fa-vine" . "\xf1ca")
    ("nf-fa-vk" . "\xf189")
    ("nf-fa-vnv" . "\xed3a")
    ("nf-fa-voicemail" . "\xefb4")
    ("nf-fa-volcano" . "\xef2e")
    ("nf-fa-volleyball" . "\xed72")
    ("nf-fa-volume_control_phone" . "\xf2a0")
    ("nf-fa-volume_down" . "\xf027")
    ("nf-fa-volume_high" . "\xf028")
    ("nf-fa-volume_low" . "\xf027")
    ("nf-fa-volume_off" . "\xf026")
    ("nf-fa-volume_up" . "\xf028")
    ("nf-fa-volume_xmark" . "\xeee8")
    ("nf-fa-vr_cardboard" . "\xef14")
    ("nf-fa-vuejs" . "\xed4a")
    ("nf-fa-walkie_talkie" . "\xefc0")
    ("nf-fa-wallet" . "\xee1e")
    ("nf-fa-wand_magic" . "\xf0d0")
    ("nf-fa-wand_sparkles" . "\xef15")
    ("nf-fa-warehouse" . "\xed92")
    ("nf-fa-warning" . "\xf071")
    ("nf-fa-water" . "\xef30")
    ("nf-fa-water_ladder" . "\xee8c")
    ("nf-fa-wave_square" . "\xef9d")
    ("nf-fa-waze" . "\xef9e")
    ("nf-fa-wechat" . "\xf1d7")
    ("nf-fa-weebly" . "\xee93")
    ("nf-fa-weibo" . "\xf18a")
    ("nf-fa-weight_hanging" . "\xee94")
    ("nf-fa-weight_scale" . "\xed93")
    ("nf-fa-weixin" . "\xf1d7")
    ("nf-fa-whatsapp" . "\xf232")
    ("nf-fa-wheelchair" . "\xf193")
    ("nf-fa-wheelchair_alt" . "\xf29b")
    ("nf-fa-whiskey_glass" . "\xef4a")
    ("nf-fa-whmcs" . "\xed3c")
    ("nf-fa-wifi" . "\xf1eb")
    ("nf-fa-wikipedia_w" . "\xf266")
    ("nf-fa-wind" . "\xef16")
    ("nf-fa-window_close" . "\xf2d3")
    ("nf-fa-window_close_o" . "\xf2d4")
    ("nf-fa-window_maximize" . "\xf2d0")
    ("nf-fa-window_minimize" . "\xf2d1")
    ("nf-fa-window_restore" . "\xf2d2")
    ("nf-fa-windows" . "\xf17a")
    ("nf-fa-wine_bottle" . "\xef17")
    ("nf-fa-wine_glass" . "\xedae")
    ("nf-fa-wine_glass_empty" . "\xee95")
    ("nf-fa-wix" . "\xee96")
    ("nf-fa-wizards_of_the_coast" . "\xef18")
    ("nf-fa-wolf_pack_battalion" . "\xedde")
    ("nf-fa-won" . "\xf159")
    ("nf-fa-won_sign" . "\xf159")
    ("nf-fa-wordpress" . "\xf19a")
    ("nf-fa-wordpress_simple" . "\xed3d")
    ("nf-fa-wpbeginner" . "\xf297")
    ("nf-fa-wpexplorer" . "\xf2de")
    ("nf-fa-wpforms" . "\xf298")
    ("nf-fa-wpressr" . "\xed1d")
    ("nf-fa-wrench" . "\xf0ad")
    ("nf-fa-x_ray" . "\xed94")
    ("nf-fa-xbox" . "\xed3e")
    ("nf-fa-xing" . "\xf168")
    ("nf-fa-xing_square" . "\xf169")
    ("nf-fa-xmark" . "\xf00d")
    ("nf-fa-y_combinator" . "\xf23b")
    ("nf-fa-y_combinator_square" . "\xf1d4")
    ("nf-fa-yahoo" . "\xf19e")
    ("nf-fa-yammer" . "\xef9f")
    ("nf-fa-yandex" . "\xed3f")
    ("nf-fa-yandex_international" . "\xed40")
    ("nf-fa-yarn" . "\xef75")
    ("nf-fa-yc" . "\xf23b")
    ("nf-fa-yc_square" . "\xf1d4")
    ("nf-fa-yelp" . "\xf1e9")
    ("nf-fa-yen" . "\xf157")
    ("nf-fa-yen_sign" . "\xf157")
    ("nf-fa-yin_yang" . "\xeee9")
    ("nf-fa-yoast" . "\xf2b1")
    ("nf-fa-youtube" . "\xf16a")
    ("nf-fa-youtube_play" . "\xf16a")
    ("nf-fa-youtube_square" . "\xf166")
    ("nf-fa-zhihu" . "\xeeba")
    ("nf-fae-apple_fruit" . "\xe29e")
    ("nf-fae-atom" . "\xe27f")
    ("nf-fae-bacteria" . "\xe280")
    ("nf-fae-banana" . "\xe281")
    ("nf-fae-bath" . "\xe282")
    ("nf-fae-bed" . "\xe283")
    ("nf-fae-benzene" . "\xe284")
    ("nf-fae-bigger" . "\xe285")
    ("nf-fae-biohazard" . "\xe286")
    ("nf-fae-blogger_circle" . "\xe287")
    ("nf-fae-blogger_square" . "\xe288")
    ("nf-fae-bones" . "\xe289")
    ("nf-fae-book_open" . "\xe28a")
    ("nf-fae-book_open_o" . "\xe28b")
    ("nf-fae-brain" . "\xe28c")
    ("nf-fae-bread" . "\xe28d")
    ("nf-fae-butterfly" . "\xe28e")
    ("nf-fae-carot" . "\xe28f")
    ("nf-fae-cc_by" . "\xe290")
    ("nf-fae-cc_cc" . "\xe291")
    ("nf-fae-cc_nc" . "\xe292")
    ("nf-fae-cc_nc_eu" . "\xe293")
    ("nf-fae-cc_nc_jp" . "\xe294")
    ("nf-fae-cc_nd" . "\xe295")
    ("nf-fae-cc_remix" . "\xe296")
    ("nf-fae-cc_sa" . "\xe297")
    ("nf-fae-cc_share" . "\xe298")
    ("nf-fae-cc_zero" . "\xe299")
    ("nf-fae-checklist_o" . "\xe29a")
    ("nf-fae-cheese" . "\xe264")
    ("nf-fae-cherry" . "\xe29b")
    ("nf-fae-chess_bishop" . "\xe29c")
    ("nf-fae-chess_horse" . "\xe25f")
    ("nf-fae-chess_king" . "\xe260")
    ("nf-fae-chess_pawn" . "\xe261")
    ("nf-fae-chess_queen" . "\xe262")
    ("nf-fae-chess_tower" . "\xe263")
    ("nf-fae-chicken_thigh" . "\xe29f")
    ("nf-fae-chilli" . "\xe265")
    ("nf-fae-chip" . "\xe266")
    ("nf-fae-cicling" . "\xe267")
    ("nf-fae-cloud" . "\xe268")
    ("nf-fae-cockroach" . "\xe269")
    ("nf-fae-coffe_beans" . "\xe26a")
    ("nf-fae-coins" . "\xe26b")
    ("nf-fae-comb" . "\xe26c")
    ("nf-fae-comet" . "\xe26d")
    ("nf-fae-crown" . "\xe26e")
    ("nf-fae-cup_coffe" . "\xe26f")
    ("nf-fae-dice" . "\xe270")
    ("nf-fae-disco" . "\xe271")
    ("nf-fae-dna" . "\xe272")
    ("nf-fae-donut" . "\xe273")
    ("nf-fae-dress" . "\xe274")
    ("nf-fae-drop" . "\xe275")
    ("nf-fae-ello" . "\xe276")
    ("nf-fae-envelope_open" . "\xe277")
    ("nf-fae-envelope_open_o" . "\xe278")
    ("nf-fae-equal" . "\xe279")
    ("nf-fae-equal_bigger" . "\xe27a")
    ("nf-fae-feedly" . "\xe27b")
    ("nf-fae-file_export" . "\xe27c")
    ("nf-fae-file_import" . "\xe27d")
    ("nf-fae-fingerprint" . "\xe23f")
    ("nf-fae-floppy" . "\xe240")
    ("nf-fae-footprint" . "\xe241")
    ("nf-fae-freecodecamp" . "\xe242")
    ("nf-fae-galaxy" . "\xe243")
    ("nf-fae-galery" . "\xe244")
    ("nf-fae-gift_card" . "\xe2a0")
    ("nf-fae-glass" . "\xe245")
    ("nf-fae-google_drive" . "\xe246")
    ("nf-fae-google_play" . "\xe247")
    ("nf-fae-gps" . "\xe248")
    ("nf-fae-grav" . "\xe249")
    ("nf-fae-guitar" . "\xe24a")
    ("nf-fae-gut" . "\xe24b")
    ("nf-fae-halter" . "\xe24c")
    ("nf-fae-hamburger" . "\xe24d")
    ("nf-fae-hat" . "\xe24e")
    ("nf-fae-hexagon" . "\xe24f")
    ("nf-fae-high_heel" . "\xe250")
    ("nf-fae-hotdog" . "\xe251")
    ("nf-fae-ice_cream" . "\xe252")
    ("nf-fae-id_card" . "\xe253")
    ("nf-fae-imdb" . "\xe254")
    ("nf-fae-infinity" . "\xe255")
    ("nf-fae-injection" . "\xe2a1")
    ("nf-fae-isle" . "\xe2a2")
    ("nf-fae-java" . "\xe256")
    ("nf-fae-layers" . "\xe257")
    ("nf-fae-lips" . "\xe258")
    ("nf-fae-lipstick" . "\xe259")
    ("nf-fae-liver" . "\xe25a")
    ("nf-fae-lollipop" . "\xe2a3")
    ("nf-fae-loyalty_card" . "\xe2a4")
    ("nf-fae-lung" . "\xe25b")
    ("nf-fae-makeup_brushes" . "\xe25c")
    ("nf-fae-maximize" . "\xe25d")
    ("nf-fae-meat" . "\xe2a5")
    ("nf-fae-medicine" . "\xe221")
    ("nf-fae-microscope" . "\xe222")
    ("nf-fae-milk_bottle" . "\xe223")
    ("nf-fae-minimize" . "\xe224")
    ("nf-fae-molecule" . "\xe225")
    ("nf-fae-moon_cloud" . "\xe226")
    ("nf-fae-mountains" . "\xe2a6")
    ("nf-fae-mushroom" . "\xe227")
    ("nf-fae-mustache" . "\xe228")
    ("nf-fae-mysql" . "\xe229")
    ("nf-fae-nintendo" . "\xe22a")
    ("nf-fae-orange" . "\xe2a7")
    ("nf-fae-palette_color" . "\xe22b")
    ("nf-fae-peach" . "\xe2a8")
    ("nf-fae-pear" . "\xe2a9")
    ("nf-fae-pi" . "\xe22c")
    ("nf-fae-pizza" . "\xe22d")
    ("nf-fae-planet" . "\xe22e")
    ("nf-fae-plant" . "\xe22f")
    ("nf-fae-playstation" . "\xe230")
    ("nf-fae-poison" . "\xe231")
    ("nf-fae-popcorn" . "\xe232")
    ("nf-fae-popsicle" . "\xe233")
    ("nf-fae-pulse" . "\xe234")
    ("nf-fae-python" . "\xe235")
    ("nf-fae-quora_circle" . "\xe236")
    ("nf-fae-quora_square" . "\xe237")
    ("nf-fae-radioactive" . "\xe238")
    ("nf-fae-raining" . "\xe239")
    ("nf-fae-real_heart" . "\xe23a")
    ("nf-fae-refrigerator" . "\xe23b")
    ("nf-fae-restore" . "\xe23c")
    ("nf-fae-ring" . "\xe23d")
    ("nf-fae-ruby" . "\xe23e")
    ("nf-fae-ruby_o" . "\xe21e")
    ("nf-fae-ruler" . "\xe21f")
    ("nf-fae-shirt" . "\xe218")
    ("nf-fae-slash" . "\xe216")
    ("nf-fae-smaller" . "\xe200")
    ("nf-fae-snowing" . "\xe201")
    ("nf-fae-soda" . "\xe202")
    ("nf-fae-sofa" . "\xe203")
    ("nf-fae-soup" . "\xe204")
    ("nf-fae-spermatozoon" . "\xe205")
    ("nf-fae-spin_double" . "\xe206")
    ("nf-fae-stomach" . "\xe207")
    ("nf-fae-storm" . "\xe208")
    ("nf-fae-sun_cloud" . "\xe21d")
    ("nf-fae-sushi" . "\xe21a")
    ("nf-fae-tacos" . "\xe219")
    ("nf-fae-telegram" . "\xe217")
    ("nf-fae-telegram_circle" . "\xe215")
    ("nf-fae-telescope" . "\xe209")
    ("nf-fae-thermometer" . "\xe20a")
    ("nf-fae-thermometer_high" . "\xe20b")
    ("nf-fae-thermometer_low" . "\xe20c")
    ("nf-fae-thin_close" . "\xe20d")
    ("nf-fae-toilet" . "\xe20e")
    ("nf-fae-tools" . "\xe20f")
    ("nf-fae-tooth" . "\xe210")
    ("nf-fae-tree" . "\xe21c")
    ("nf-fae-triangle_ruler" . "\xe21b")
    ("nf-fae-umbrella" . "\xe220")
    ("nf-fae-uterus" . "\xe211")
    ("nf-fae-virus" . "\xe214")
    ("nf-fae-w3c" . "\xe212")
    ("nf-fae-walking" . "\xe213")
    ("nf-fae-wallet" . "\xe25e")
    ("nf-fae-wind" . "\xe27e")
    ("nf-fae-xbox" . "\xe29d")
    ))

(provide 'nerd-icons-data-faicon)
;;; nerd-icons-data-faicon.el ends here