;;; nerd-icons-data-devicon.el --- glyphset devicon -*- lexical-binding: t -*-

;; Copyright (C) 2023 Hongyu Ding <rainstormstudio@yahoo.com>

;; Author: Hongyu Ding <rainstormstudio@yahoo.com>
;; Keywords: lisp

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; devicon
;; from Nerd Font Version: 3.4.0

;;; Code:

(defvar nerd-icons/devicon-alist
  '(
    ("nf-dev-aarch64" . "\xe700")
    ("nf-dev-adonisjs" . "\xe701")
    ("nf-dev-aftereffects" . "\xe705")
    ("nf-dev-akka" . "\xe708")
    ("nf-dev-algolia" . "\xe70a")
    ("nf-dev-alpinejs" . "\xe713")
    ("nf-dev-amazonwebservices" . "\xe7ad")
    ("nf-dev-anaconda" . "\xe715")
    ("nf-dev-android" . "\xe70e")
    ("nf-dev-androidstudio" . "\xe71a")
    ("nf-dev-angular" . "\xe753")
    ("nf-dev-angularjs" . "\xe71c")
    ("nf-dev-angularmaterial" . "\xe720")
    ("nf-dev-ansible" . "\xe723")
    ("nf-dev-antdesign" . "\xe72a")
    ("nf-dev-apache" . "\xe72b")
    ("nf-dev-apacheairflow" . "\xe72c")
    ("nf-dev-apachekafka" . "\xe72e")
    ("nf-dev-apachespark" . "\xe72f")
    ("nf-dev-apl" . "\xe730")
    ("nf-dev-appcelerator" . "\xe7ab")
    ("nf-dev-apple" . "\xe711")
    ("nf-dev-appwrite" . "\xe731")
    ("nf-dev-archlinux" . "\xe732")
    ("nf-dev-arduino" . "\xe733")
    ("nf-dev-argocd" . "\xe734")
    ("nf-dev-astro" . "\xe735")
    ("nf-dev-atom" . "\xe764")
    ("nf-dev-awk" . "\xe741")
    ("nf-dev-aws" . "\xe7ad")
    ("nf-dev-axios" . "\xe74f")
    ("nf-dev-azure" . "\xe754")
    ("nf-dev-azuredevops" . "\xe756")
    ("nf-dev-azuresqldatabase" . "\xe75b")
    ("nf-dev-babel" . "\xe75d")
    ("nf-dev-backbone" . "\xe752")
    ("nf-dev-backbonejs" . "\xe752")
    ("nf-dev-ballerina" . "\xe75e")
    ("nf-dev-bamboo" . "\xe75f")
    ("nf-dev-bash" . "\xe760")
    ("nf-dev-beats" . "\xe761")
    ("nf-dev-behance" . "\xe762")
    ("nf-dev-bitbucket" . "\xe703")
    ("nf-dev-blazor" . "\xe765")
    ("nf-dev-blender" . "\xe766")
    ("nf-dev-bootstrap" . "\xe747")
    ("nf-dev-bower" . "\xe74d")
    ("nf-dev-browserstack" . "\xe76b")
    ("nf-dev-bulma" . "\xe76c")
    ("nf-dev-bun" . "\xe76f")
    ("nf-dev-c" . "\xe771")
    ("nf-dev-c_lang" . "\xe771")
    ("nf-dev-cairo" . "\xe773")
    ("nf-dev-cakephp" . "\xe77a")
    ("nf-dev-canva" . "\xe77c")
    ("nf-dev-capacitor" . "\xe785")
    ("nf-dev-carbon" . "\xe788")
    ("nf-dev-cassandra" . "\xe789")
    ("nf-dev-centos" . "\xe78a")
    ("nf-dev-ceylon" . "\xe78b")
    ("nf-dev-chrome" . "\xe743")
    ("nf-dev-circleci" . "\xe78c")
    ("nf-dev-clarity" . "\xe78d")
    ("nf-dev-clion" . "\xe78e")
    ("nf-dev-clojure" . "\xe768")
    ("nf-dev-clojure_alt" . "\xe76a")
    ("nf-dev-clojurescript" . "\xe790")
    ("nf-dev-cloudflare" . "\xe792")
    ("nf-dev-cloudflareworkers" . "\xe793")
    ("nf-dev-cmake" . "\xe794")
    ("nf-dev-codeac" . "\xe796")
    ("nf-dev-codecov" . "\xe797")
    ("nf-dev-codeigniter" . "\xe780")
    ("nf-dev-codepen" . "\xe716")
    ("nf-dev-coffeescript" . "\xe751")
    ("nf-dev-composer" . "\xe783")
    ("nf-dev-confluence" . "\xe799")
    ("nf-dev-consul" . "\xe79a")
    ("nf-dev-contao" . "\xe79b")
    ("nf-dev-corejs" . "\xe79d")
    ("nf-dev-cosmosdb" . "\xe79f")
    ("nf-dev-couchbase" . "\xe7a0")
    ("nf-dev-couchdb" . "\xe7a2")
    ("nf-dev-cplusplus" . "\xe7a3")
    ("nf-dev-crystal" . "\xe7ac")
    ("nf-dev-csharp" . "\xe7b2")
    ("nf-dev-css3" . "\xe749")
    ("nf-dev-css3_full" . "\xe74a")
    ("nf-dev-cucumber" . "\xe7b7")
    ("nf-dev-cypressio" . "\xe7b9")
    ("nf-dev-d3js" . "\xe7bc")
    ("nf-dev-dart" . "\xe798")
    ("nf-dev-database" . "\xe706")
    ("nf-dev-datagrip" . "\xe7bd")
    ("nf-dev-dataspell" . "\xe7be")
    ("nf-dev-dbeaver" . "\xe7bf")
    ("nf-dev-debian" . "\xe77d")
    ("nf-dev-denojs" . "\xe7c0")
    ("nf-dev-devicon" . "\xe7c1")
    ("nf-dev-digital_ocean" . "\xe7ae")
    ("nf-dev-digitalocean" . "\xe7ae")
    ("nf-dev-discordjs" . "\xe7c2")
    ("nf-dev-django" . "\xe71d")
    ("nf-dev-djangorest" . "\xe7c3")
    ("nf-dev-dlang" . "\xe7af")
    ("nf-dev-docker" . "\xe7b0")
    ("nf-dev-doctrine" . "\xe774")
    ("nf-dev-dotnet" . "\xe77f")
    ("nf-dev-dotnetcore" . "\xe7c6")
    ("nf-dev-dreamweaver" . "\xe79c")
    ("nf-dev-dropbox" . "\xe707")
    ("nf-dev-dropwizard" . "\xe7c7")
    ("nf-dev-drupal" . "\xe742")
    ("nf-dev-dynamodb" . "\xe7c8")
    ("nf-dev-eclipse" . "\xe79e")
    ("nf-dev-ecto" . "\xe7c9")
    ("nf-dev-elasticsearch" . "\xe7ca")
    ("nf-dev-electron" . "\xe7cb")
    ("nf-dev-eleventy" . "\xe7cc")
    ("nf-dev-elixir" . "\xe7cd")
    ("nf-dev-elm" . "\xe7ce")
    ("nf-dev-emacs" . "\xe7cf")
    ("nf-dev-embeddedc" . "\xe7d0")
    ("nf-dev-ember" . "\xe71b")
    ("nf-dev-envoy" . "\xe7d1")
    ("nf-dev-erlang" . "\xe7b1")
    ("nf-dev-eslint" . "\xe7d2")
    ("nf-dev-express" . "\xe7d3")
    ("nf-dev-facebook" . "\xe7d4")
    ("nf-dev-fastapi" . "\xe7d5")
    ("nf-dev-fastify" . "\xe7d6")
    ("nf-dev-faunadb" . "\xe7d7")
    ("nf-dev-feathersjs" . "\xe7d8")
    ("nf-dev-fedora" . "\xe7d9")
    ("nf-dev-figma" . "\xe7da")
    ("nf-dev-filezilla" . "\xe7db")
    ("nf-dev-firebase" . "\xe787")
    ("nf-dev-firefox" . "\xe745")
    ("nf-dev-flask" . "\xe7dc")
    ("nf-dev-flutter" . "\xe7dd")
    ("nf-dev-fortran" . "\xe7de")
    ("nf-dev-foundation" . "\xe7df")
    ("nf-dev-framermotion" . "\xe7e0")
    ("nf-dev-framework7" . "\xe7e1")
    ("nf-dev-fsharp" . "\xe7a7")
    ("nf-dev-gatling" . "\xe7e2")
    ("nf-dev-gatsby" . "\xe7e3")
    ("nf-dev-gazebo" . "\xe7e4")
    ("nf-dev-gcc" . "\xe7e5")
    ("nf-dev-gentoo" . "\xe7e6")
    ("nf-dev-ghost" . "\xe71f")
    ("nf-dev-ghost_small" . "\xe714")
    ("nf-dev-gimp" . "\xe7e7")
    ("nf-dev-git" . "\xe702")
    ("nf-dev-git_branch" . "\xe725")
    ("nf-dev-git_commit" . "\xe729")
    ("nf-dev-git_compare" . "\xe728")
    ("nf-dev-git_merge" . "\xe727")
    ("nf-dev-git_pull_request" . "\xe726")
    ("nf-dev-gitbook" . "\xe7e8")
    ("nf-dev-github" . "\xe709")
    ("nf-dev-github_badge" . "\xe709")
    ("nf-dev-github_full" . "\xe717")
    ("nf-dev-githubactions" . "\xe7e9")
    ("nf-dev-githubcodespaces" . "\xe7ea")
    ("nf-dev-gitlab" . "\xe7eb")
    ("nf-dev-gitpod" . "\xe7ec")
    ("nf-dev-gitter" . "\xe7ed")
    ("nf-dev-gnu" . "\xe779")
    ("nf-dev-go" . "\xe724")
    ("nf-dev-godot" . "\xe7ee")
    ("nf-dev-goland" . "\xe7ef")
    ("nf-dev-google" . "\xe7f0")
    ("nf-dev-googlecloud" . "\xe7f1")
    ("nf-dev-gradle" . "\xe7f2")
    ("nf-dev-grafana" . "\xe7f3")
    ("nf-dev-grails" . "\xe7b3")
    ("nf-dev-graphql" . "\xe7f4")
    ("nf-dev-groovy" . "\xe775")
    ("nf-dev-grpc" . "\xe7f5")
    ("nf-dev-grunt" . "\xe74c")
    ("nf-dev-gulp" . "\xe763")
    ("nf-dev-hadoop" . "\xe7f6")
    ("nf-dev-handlebars" . "\xe7f7")
    ("nf-dev-hardhat" . "\xe7f8")
    ("nf-dev-harvester" . "\xe7f9")
    ("nf-dev-haskell" . "\xe777")
    ("nf-dev-haxe" . "\xe7fa")
    ("nf-dev-helm" . "\xe7fb")
    ("nf-dev-heroku" . "\xe77b")
    ("nf-dev-hibernate" . "\xe7fc")
    ("nf-dev-homebrew" . "\xe7fd")
    ("nf-dev-html5" . "\xe736")
    ("nf-dev-hugo" . "\xe7fe")
    ("nf-dev-ie" . "\xe744")
    ("nf-dev-ifttt" . "\xe7ff")
    ("nf-dev-illustrator" . "\xe7b4")
    ("nf-dev-influxdb" . "\xe800")
    ("nf-dev-inkscape" . "\xe801")
    ("nf-dev-insomnia" . "\xe802")
    ("nf-dev-intellij" . "\xe7b5")
    ("nf-dev-ionic" . "\xe7a9")
    ("nf-dev-jaegertracing" . "\xe803")
    ("nf-dev-jamstack" . "\xe804")
    ("nf-dev-jasmine" . "\xe805")
    ("nf-dev-java" . "\xe738")
    ("nf-dev-javascript" . "\xe781")
    ("nf-dev-javascript_alt" . "\xe74e")
    ("nf-dev-javascript_badge" . "\xe781")
    ("nf-dev-jeet" . "\xe806")
    ("nf-dev-jekyll" . "\xe70d")
    ("nf-dev-jekyll_small" . "\xe70d")
    ("nf-dev-jenkins" . "\xe767")
    ("nf-dev-jest" . "\xe807")
    ("nf-dev-jetbrains" . "\xe808")
    ("nf-dev-jetpackcompose" . "\xe809")
    ("nf-dev-jira" . "\xe75c")
    ("nf-dev-jiraalign" . "\xe80a")
    ("nf-dev-jquery" . "\xe750")
    ("nf-dev-json" . "\xe80b")
    ("nf-dev-jule" . "\xe80c")
    ("nf-dev-julia" . "\xe80d")
    ("nf-dev-junit" . "\xe80e")
    ("nf-dev-jupyter" . "\xe80f")
    ("nf-dev-k3os" . "\xe810")
    ("nf-dev-k3s" . "\xe811")
    ("nf-dev-k6" . "\xe812")
    ("nf-dev-kaggle" . "\xe813")
    ("nf-dev-karatelabs" . "\xe814")
    ("nf-dev-karma" . "\xe815")
    ("nf-dev-kdeneon" . "\xe816")
    ("nf-dev-keras" . "\xe817")
    ("nf-dev-kibana" . "\xe818")
    ("nf-dev-knexjs" . "\xe819")
    ("nf-dev-knockout" . "\xe81a")
    ("nf-dev-kotlin" . "\xe81b")
    ("nf-dev-krakenjs" . "\xe784")
    ("nf-dev-krakenjs_badge" . "\xe784")
    ("nf-dev-ktor" . "\xe81c")
    ("nf-dev-kubernetes" . "\xe81d")
    ("nf-dev-labview" . "\xe81e")
    ("nf-dev-laravel" . "\xe73f")
    ("nf-dev-latex" . "\xe81f")
    ("nf-dev-less" . "\xe758")
    ("nf-dev-linkedin" . "\xe820")
    ("nf-dev-linux" . "\xe712")
    ("nf-dev-liquibase" . "\xe821")
    ("nf-dev-livewire" . "\xe822")
    ("nf-dev-llvm" . "\xe823")
    ("nf-dev-lodash" . "\xe824")
    ("nf-dev-logstash" . "\xe825")
    ("nf-dev-lua" . "\xe826")
    ("nf-dev-lumen" . "\xe827")
    ("nf-dev-magento" . "\xe740")
    ("nf-dev-mariadb" . "\xe828")
    ("nf-dev-markdown" . "\xe73e")
    ("nf-dev-materializecss" . "\xe7b6")
    ("nf-dev-materialui" . "\xe829")
    ("nf-dev-matlab" . "\xe82a")
    ("nf-dev-matplotlib" . "\xe82b")
    ("nf-dev-maven" . "\xe82c")
    ("nf-dev-maya" . "\xe82d")
    ("nf-dev-meteor" . "\xe7a5")
    ("nf-dev-meteorfull" . "\xe7a6")
    ("nf-dev-microsoftsqlserver" . "\xe82e")
    ("nf-dev-minitab" . "\xe82f")
    ("nf-dev-mithril" . "\xe830")
    ("nf-dev-mobx" . "\xe831")
    ("nf-dev-mocha" . "\xe832")
    ("nf-dev-modx" . "\xe833")
    ("nf-dev-moleculer" . "\xe834")
    ("nf-dev-mongodb" . "\xe7a4")
    ("nf-dev-mongoose" . "\xe835")
    ("nf-dev-moodle" . "\xe836")
    ("nf-dev-mootools_badge" . "\xe78f")
    ("nf-dev-mozilla" . "\xe786")
    ("nf-dev-msdos" . "\xe837")
    ("nf-dev-mysql" . "\xe704")
    ("nf-dev-nano" . "\xe838")
    ("nf-dev-neo4j" . "\xe839")
    ("nf-dev-neovim" . "\xe83a")
    ("nf-dev-nestjs" . "\xe83b")
    ("nf-dev-netlify" . "\xe83c")
    ("nf-dev-networkx" . "\xe83d")
    ("nf-dev-nextjs" . "\xe83e")
    ("nf-dev-nginx" . "\xe776")
    ("nf-dev-ngrx" . "\xe83f")
    ("nf-dev-nhibernate" . "\xe840")
    ("nf-dev-nim" . "\xe841")
    ("nf-dev-nimble" . "\xe842")
    ("nf-dev-nixos" . "\xe843")
    ("nf-dev-nodejs" . "\xe719")
    ("nf-dev-nodejs_small" . "\xe718")
    ("nf-dev-nodemon" . "\xe844")
    ("nf-dev-nodewebkit" . "\xe845")
    ("nf-dev-nomad" . "\xe846")
    ("nf-dev-norg" . "\xe847")
    ("nf-dev-notion" . "\xe848")
    ("nf-dev-npm" . "\xe71e")
    ("nf-dev-nuget" . "\xe849")
    ("nf-dev-numpy" . "\xe84a")
    ("nf-dev-nuxtjs" . "\xe84b")
    ("nf-dev-oauth" . "\xe84c")
    ("nf-dev-objectivec" . "\xe84d")
    ("nf-dev-ocaml" . "\xe84e")
    ("nf-dev-ohmyzsh" . "\xe84f")
    ("nf-dev-okta" . "\xe850")
    ("nf-dev-openal" . "\xe851")
    ("nf-dev-openapi" . "\xe852")
    ("nf-dev-opencl" . "\xe853")
    ("nf-dev-opencv" . "\xe854")
    ("nf-dev-opengl" . "\xe855")
    ("nf-dev-openstack" . "\xe856")
    ("nf-dev-opensuse" . "\xe857")
    ("nf-dev-opentelemetry" . "\xe858")
    ("nf-dev-opera" . "\xe746")
    ("nf-dev-oracle" . "\xe859")
    ("nf-dev-ory" . "\xe85a")
    ("nf-dev-p5js" . "\xe85b")
    ("nf-dev-packer" . "\xe85c")
    ("nf-dev-pandas" . "\xe85d")
    ("nf-dev-perl" . "\xe769")
    ("nf-dev-pfsense" . "\xe85e")
    ("nf-dev-phalcon" . "\xe85f")
    ("nf-dev-phoenix" . "\xe860")
    ("nf-dev-photonengine" . "\xe861")
    ("nf-dev-photoshop" . "\xe7b8")
    ("nf-dev-php" . "\xe73d")
    ("nf-dev-phpstorm" . "\xe862")
    ("nf-dev-playwright" . "\xe863")
    ("nf-dev-plotly" . "\xe864")
    ("nf-dev-pnpm" . "\xe865")
    ("nf-dev-podman" . "\xe866")
    ("nf-dev-poetry" . "\xe867")
    ("nf-dev-polygon" . "\xe868")
    ("nf-dev-portainer" . "\xe869")
    ("nf-dev-postcss" . "\xe86a")
    ("nf-dev-postgresql" . "\xe76e")
    ("nf-dev-postman" . "\xe86b")
    ("nf-dev-powershell" . "\xe86c")
    ("nf-dev-premierepro" . "\xe86d")
    ("nf-dev-prisma" . "\xe86e")
    ("nf-dev-processing" . "\xe86f")
    ("nf-dev-prolog" . "\xe7a1")
    ("nf-dev-prometheus" . "\xe870")
    ("nf-dev-protractor" . "\xe871")
    ("nf-dev-pulsar" . "\xe872")
    ("nf-dev-pulumi" . "\xe873")
    ("nf-dev-puppeteer" . "\xe874")
    ("nf-dev-purescript" . "\xe875")
    ("nf-dev-putty" . "\xe876")
    ("nf-dev-pycharm" . "\xe877")
    ("nf-dev-pypi" . "\xe878")
    ("nf-dev-pyscript" . "\xe879")
    ("nf-dev-pytest" . "\xe87a")
    ("nf-dev-python" . "\xe73c")
    ("nf-dev-pytorch" . "\xe87b")
    ("nf-dev-qodana" . "\xe87c")
    ("nf-dev-qt" . "\xe87d")
    ("nf-dev-quarkus" . "\xe87e")
    ("nf-dev-quasar" . "\xe87f")
    ("nf-dev-qwik" . "\xe880")
    ("nf-dev-r" . "\xe881")
    ("nf-dev-rabbitmq" . "\xe882")
    ("nf-dev-rails" . "\xe73b")
    ("nf-dev-railway" . "\xe883")
    ("nf-dev-rancher" . "\xe884")
    ("nf-dev-raspberry_pi" . "\xe722")
    ("nf-dev-reach" . "\xe885")
    ("nf-dev-react" . "\xe7ba")
    ("nf-dev-reactbootstrap" . "\xe886")
    ("nf-dev-reactnavigation" . "\xe887")
    ("nf-dev-reactrouter" . "\xe888")
    ("nf-dev-readthedocs" . "\xe889")
    ("nf-dev-realm" . "\xe88a")
    ("nf-dev-rect" . "\xe88b")
    ("nf-dev-redhat" . "\xe7bb")
    ("nf-dev-redis" . "\xe76d")
    ("nf-dev-redux" . "\xe88c")
    ("nf-dev-renpy" . "\xe88d")
    ("nf-dev-replit" . "\xe88e")
    ("nf-dev-requirejs" . "\xe770")
    ("nf-dev-rider" . "\xe88f")
    ("nf-dev-rocksdb" . "\xe890")
    ("nf-dev-rockylinux" . "\xe891")
    ("nf-dev-rollup" . "\xe892")
    ("nf-dev-ros" . "\xe893")
    ("nf-dev-rspec" . "\xe894")
    ("nf-dev-rstudio" . "\xe895")
    ("nf-dev-ruby" . "\xe739")
    ("nf-dev-ruby_on_rails" . "\xe73b")
    ("nf-dev-ruby_rough" . "\xe791")
    ("nf-dev-rubymine" . "\xe896")
    ("nf-dev-rust" . "\xe7a8")
    ("nf-dev-rxjs" . "\xe897")
    ("nf-dev-safari" . "\xe748")
    ("nf-dev-salesforce" . "\xe898")
    ("nf-dev-sanity" . "\xe899")
    ("nf-dev-sass" . "\xe74b")
    ("nf-dev-scala" . "\xe737")
    ("nf-dev-scalingo" . "\xe89a")
    ("nf-dev-scikitlearn" . "\xe89b")
    ("nf-dev-sdl" . "\xe89c")
    ("nf-dev-selenium" . "\xe89d")
    ("nf-dev-sema" . "\xe89e")
    ("nf-dev-sentry" . "\xe89f")
    ("nf-dev-sequelize" . "\xe8a0")
    ("nf-dev-shopware" . "\xe8a1")
    ("nf-dev-shotgrid" . "\xe8a2")
    ("nf-dev-sketch" . "\xe8a3")
    ("nf-dev-slack" . "\xe8a4")
    ("nf-dev-smashing_magazine" . "\xe72d")
    ("nf-dev-socketio" . "\xe8a5")
    ("nf-dev-solidity" . "\xe8a6")
    ("nf-dev-solidjs" . "\xe8a7")
    ("nf-dev-sonarqube" . "\xe8a8")
    ("nf-dev-sourcetree" . "\xe8a9")
    ("nf-dev-spack" . "\xe8aa")
    ("nf-dev-splunk" . "\xe8ab")
    ("nf-dev-spring" . "\xe8ac")
    ("nf-dev-spss" . "\xe8ad")
    ("nf-dev-spyder" . "\xe8ae")
    ("nf-dev-sqlalchemy" . "\xe8af")
    ("nf-dev-sqldeveloper" . "\xe8b0")
    ("nf-dev-sqlite" . "\xe7c4")
    ("nf-dev-ssh" . "\xe8b1")
    ("nf-dev-stackoverflow" . "\xe710")
    ("nf-dev-stata" . "\xe8b2")
    ("nf-dev-storybook" . "\xe8b3")
    ("nf-dev-streamlit" . "\xe8b4")
    ("nf-dev-stylus" . "\xe759")
    ("nf-dev-sublime" . "\xe7aa")
    ("nf-dev-subversion" . "\xe8b5")
    ("nf-dev-supabase" . "\xe8b6")
    ("nf-dev-svelte" . "\xe8b7")
    ("nf-dev-swagger" . "\xe8b8")
    ("nf-dev-swift" . "\xe755")
    ("nf-dev-swiper" . "\xe8b9")
    ("nf-dev-symfony" . "\xe757")
    ("nf-dev-symfony_badge" . "\xe757")
    ("nf-dev-tailwindcss" . "\xe8ba")
    ("nf-dev-tauri" . "\xe8bb")
    ("nf-dev-tensorflow" . "\xe8bc")
    ("nf-dev-terminal" . "\xe795")
    ("nf-dev-terraform" . "\xe8bd")
    ("nf-dev-tex" . "\xe8be")
    ("nf-dev-thealgorithms" . "\xe8bf")
    ("nf-dev-threedsmax" . "\xe8c0")
    ("nf-dev-threejs" . "\xe8c1")
    ("nf-dev-titaniumsdk" . "\xe8c2")
    ("nf-dev-tomcat" . "\xe8c3")
    ("nf-dev-tortoisegit" . "\xe8c4")
    ("nf-dev-towergit" . "\xe8c5")
    ("nf-dev-traefikmesh" . "\xe8c6")
    ("nf-dev-traefikproxy" . "\xe8c7")
    ("nf-dev-travis" . "\xe77e")
    ("nf-dev-trello" . "\xe75a")
    ("nf-dev-trpc" . "\xe8c8")
    ("nf-dev-twitter" . "\xe8c9")
    ("nf-dev-typescript" . "\xe8ca")
    ("nf-dev-typo3" . "\xe772")
    ("nf-dev-ubuntu" . "\xe73a")
    ("nf-dev-uml" . "\xe8cb")
    ("nf-dev-unifiedmodelinglanguage" . "\xe8cb")
    ("nf-dev-unity" . "\xe721")
    ("nf-dev-unity_small" . "\xe721")
    ("nf-dev-unix" . "\xe8cc")
    ("nf-dev-unrealengine" . "\xe8cd")
    ("nf-dev-uwsgi" . "\xe8ce")
    ("nf-dev-v8" . "\xe8cf")
    ("nf-dev-vagrant" . "\xe8d0")
    ("nf-dev-vala" . "\xe8d1")
    ("nf-dev-vault" . "\xe8d2")
    ("nf-dev-vercel" . "\xe8d3")
    ("nf-dev-vertx" . "\xe8d4")
    ("nf-dev-vim" . "\xe7c5")
    ("nf-dev-visualbasic" . "\xe8d5")
    ("nf-dev-visualstudio" . "\xe70c")
    ("nf-dev-vite" . "\xe8d6")
    ("nf-dev-vitejs" . "\xe8d7")
    ("nf-dev-vitess" . "\xe8d8")
    ("nf-dev-vitest" . "\xe8d9")
    ("nf-dev-vscode" . "\xe8da")
    ("nf-dev-vsphere" . "\xe8db")
    ("nf-dev-vuejs" . "\xe8dc")
    ("nf-dev-vuestorefront" . "\xe8dd")
    ("nf-dev-vuetify" . "\xe8de")
    ("nf-dev-vyper" . "\xe8df")
    ("nf-dev-wasm" . "\xe8e0")
    ("nf-dev-webflow" . "\xe8e1")
    ("nf-dev-weblate" . "\xe8e2")
    ("nf-dev-webpack" . "\xe8e3")
    ("nf-dev-webstorm" . "\xe8e4")
    ("nf-dev-windows" . "\xe70f")
    ("nf-dev-windows11" . "\xe8e5")
    ("nf-dev-woocommerce" . "\xe8e6")
    ("nf-dev-wordpress" . "\xe70b")
    ("nf-dev-xamarin" . "\xe8e7")
    ("nf-dev-xcode" . "\xe8e8")
    ("nf-dev-xd" . "\xe8e9")
    ("nf-dev-xml" . "\xe8ea")
    ("nf-dev-yaml" . "\xe8eb")
    ("nf-dev-yarn" . "\xe8ec")
    ("nf-dev-yii" . "\xe782")
    ("nf-dev-yugabytedb" . "\xe8ed")
    ("nf-dev-yunohost" . "\xe8ee")
    ("nf-dev-zend" . "\xe778")
    ("nf-dev-zig" . "\xe8ef")
    ))

(provide 'nerd-icons-data-devicon)
;;; nerd-icons-data-devicon.el ends here