;;; agda-lib-mode.el --- Major mode for Agda library files  -*- lexical-binding: t -*-

;; Author: "Nicholas Coltharp" <mail@heraplem.xyz>
;; Package-Version: 20251013.2307
;; Package-Revision: 1cf7d4867538
;; Keywords: text
;; URL: https://codeberg.org/heraplem/agda-lib-mode
;; Package-Requires: ((emacs "24.3"))

;; This file is not part of GNU Emacs.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;;; Commentary:

;; This package provides a major mode for editing Agda library files.
;; It binds files with suffix ‘.agda-lib’ to ‘agda-lib-mode’ in
;; ‘auto-mode-alist’.

;;; Code:

(defvar agda-lib-font-lock-keywords
  '(("\\(^\\| \\)-- .*" . font-lock-comment-face)
    ("^\\([^ ]+:\\)" (1 font-lock-keyword-face))))

;;;###autoload
(define-derived-mode agda-lib-mode text-mode "agda-lib"
  (setq-local font-lock-defaults '(agda-lib-font-lock-keywords t t nil nil)
              comment-start "-- "
              comment-start-skip "\\(^\\| \\)-- +"
              comment-end ""
              comment-end-skip "[ \t]*\\(\\s>\\|\n\\)"))

;;;###autoload
(add-to-list 'auto-mode-alist '("\\.agda-lib\\'" . agda-lib-mode))

(provide 'agda-lib-mode)

;;; agda-lib-mode.el ends here
