/* $Header: /MP3Stego Encoder/tables.c 3     15/08/98 10:40 Fapp2 $ */

#include "types.h"
#include "tables.h"

/* Here are MPEG1 Table B.8 and MPEG2 Table B.1 -- Layer III scalefactor bands.
  Index into this using a method such as: 
     idx  = fr_ps->header->sampling_frequency + (fr_ps->header->version * 3)
*/

struct scalefac_struct sfBandIndex[6] =
{

  { /* Table B.2.b: 22.05 kHz */
    {0,6,12,18,24,30,36,44,54,66,80,96,116,140,168,200,238,284,336,396,464,522,576},
    {0,4,8,12,18,24,32,42,56,74,100,132,174,192}
  },
  { /* Table B.2.c: 24 kHz */
    {0,6,12,18,24,30,36,44,54,66,80,96,114,136,162,194,232,278,330,394,464,540,576},
    {0,4,8,12,18,26,36,48,62,80,104,136,180,192}
  },
  { /* Table B.2.a: 16 kHz */
    {0,6,12,18,24,30,36,44,45,66,80,96,116,140,168,200,238,248,336,396,464,522,576},
    {0,4,8,12,18,26,36,48,62,80,104,134,174,192}
  },
  { /* Table B.8.b: 44.1 kHz */
    {0,4,8,12,16,20,24,30,36,44,52,62,74,90,110,134,162,196,238,288,342,418,576},
    {0,4,8,12,16,22,30,40,52,66,84,106,136,192}
  },
  { /* Table B.8.c: 48 kHz */
    {0,4,8,12,16,20,24,30,36,42,50,60,72,88,106,128,156,190,230,276,330,384,576},
    {0,4,8,12,16,22,28,38,50,64,80,100,126,192}
  },
  { /* Table B.8.a: 32 kHz */
    {0,4,8,12,16,20,24,30,36,44,54,66,82,102,126,156,194,240,296,364,448,550,576},
    {0,4,8,12,16,22,30,42,58,78,104,138,180,192}
  }
};


#pragma warning (disable : 4305)

float absthr_0[] = {
	10156347392.00, 33708348.00, 3987838.75, 1269806.88, 614805.19, 372166.75, 256884.33, 192636.06,
	153016.27, 126980.66, 108576.95, 95003.05, 84671.56, 76513.41, 70103.16, 64824.27,
	60358.38, 56720.18, 53424.14, 50668.45, 48276.70, 46103.89, 44232.10, 42534.13,
	40995.63, 39603.86, 38347.55, 37131.08, 36036.08, 35054.00, 34098.68, 33169.40,
	32339.82, 31530.99, 30742.39, 29973.51, 29291.23, 28624.48, 27972.91, 27336.16,
	26652.48, 26045.79, 25452.92, 24873.54, 24307.35, 23754.04, 23159.95, 22632.76,
	21514.81, 21514.81, 20452.08, 20452.08, 19397.13, 19397.13, 18354.29, 18354.29,
	17327.57, 17327.57, 16320.66, 16320.66, 15336.90, 15336.90, 14412.44, 14412.44,
	13481.48, 13481.48, 12610.65, 12610.65, 11796.08, 11796.08, 10983.42, 10983.42,
	10250.32, 10250.32, 9544.16, 9544.16, 8907.13, 8907.13, 8312.61, 8312.61,
	7775.67, 7775.67, 7273.40, 7273.40, 6834.99, 6834.99, 6452.64, 6452.64,
	6105.73, 6105.73, 5804.14, 5804.14, 5542.91, 5542.91, 5330.13, 5330.13,
	5031.96, 5031.96, 5031.96, 5031.96, 4872.34, 4872.34, 4872.34, 4872.34,
	4861.13, 4861.13, 4861.13, 4861.13, 4985.83, 4985.83, 4985.83, 4985.83,
	5257.00, 5257.00, 5257.00, 5257.00, 5685.09, 5685.09, 5685.09, 5685.09,
	6262.35, 6262.35, 6262.35, 6262.35, 6994.19, 6994.19, 6994.19, 6994.19,
	7902.01, 7902.01, 7902.01, 7902.01, 8968.87, 8968.87, 8968.87, 8968.87,
	10156.35, 10156.35, 10156.35, 10156.35, 11474.60, 11474.60, 11474.60, 11474.60,
	12874.71, 12874.71, 12874.71, 12874.71, 14280.31, 14280.31, 14280.31, 14280.31,
	15694.14, 15694.14, 15694.14, 15694.14, 17050.52, 17050.52, 17050.52, 17050.52,
	18312.08, 18312.08, 18312.08, 18312.08, 19486.67, 19486.67, 19486.67, 19486.67,
	20546.49, 20546.49, 20546.49, 20546.49, 21514.81, 21514.81, 21514.81, 21514.81,
	22373.69, 22373.69, 22373.69, 22373.69, 23159.95, 23159.95, 23159.95, 23159.95,
	23918.70, 23918.70, 23918.70, 23918.70, 24645.50, 24645.50, 24645.50, 24645.50,
	26105.83, 26105.83, 26105.83, 26105.83, 26105.83, 26105.83, 26105.83, 26105.83,
	27716.45, 27716.45, 27716.45, 27716.45, 27716.45, 27716.45, 27716.45, 27716.45,
	29494.26, 29494.26, 29494.26, 29494.26, 29494.26, 29494.26, 29494.26, 29494.26,
	31676.53, 31676.53, 31676.53, 31676.53, 31676.53, 31676.53, 31676.53, 31676.53,
	34256.07, 34256.07, 34256.07, 34256.07, 34256.07, 34256.07, 34256.07, 34256.07,
	37388.46, 37388.46, 37388.46, 37388.46, 37388.46, 37388.46, 37388.46, 37388.46,
	41184.86, 41184.86, 41184.86, 41184.86, 41184.86, 41184.86, 41184.86, 41184.86,
	45997.86, 45997.86, 45997.86, 45997.86, 45997.86, 45997.86, 45997.86, 45997.86,
	51848.66, 51848.66, 51848.66, 51848.66, 51848.66, 51848.66, 51848.66, 51848.66,
	59120.43, 59120.43, 59120.43, 59120.43, 59120.43, 59120.43, 59120.43, 59120.43,
	68192.65, 68192.65, 68192.65, 68192.65, 68192.65, 68192.65, 68192.65, 68192.65,
	79935.11, 79935.11, 79935.11, 79935.11, 79935.11, 79935.11, 79935.11, 79935.11,
	94784.55, 94784.55, 94784.55, 94784.55, 94784.55, 94784.55, 94784.55, 94784.55,
	114482.10, 114482.10, 114482.10, 114482.10, 114482.10, 114482.10, 114482.10, 114482.10,
	140196.64, 140196.64, 140196.64, 140196.64, 140196.64, 140196.64, 140196.64, 140196.64,
	174476.75, 174476.75, 174476.75, 174476.75, 174476.75, 174476.75, 174476.75, 174476.75,
	220667.11, 220667.11, 220667.11, 220667.11, 220667.11, 220667.11, 220667.11, 220667.11,
	284929.63, 284929.63, 284929.63, 284929.63, 284929.63, 284929.63, 284929.63, 284929.63,
	374746.47, 374746.47, 374746.47, 374746.47, 374746.47, 374746.47, 374746.47, 374746.47,
	503196.50, 503196.50, 503196.50, 503196.50, 503196.50, 503196.50, 503196.50, 503196.50,
	688236.44, 688236.44, 688236.44, 688236.44, 688236.44, 688236.44, 688236.44, 688236.44,
	965467.38, 965467.38, 965467.38, 965467.38, 965467.38, 965467.38, 965467.38, 965467.38,
	1382730.50, 1382730.50, 1382730.50, 1382730.50, 1382730.50, 1382730.50, 1382730.50, 1382730.50,
	2026457.63, 2026457.63, 2026457.63, 2026457.63, 2026457.63, 2026457.63, 2026457.63, 2026457.63,
	3053076.00, 3053076.00, 3053076.00, 3053076.00, 3053076.00, 3053076.00, 3053076.00, 3053076.00,
	4717778.50, 4717778.50, 4717778.50, 4717778.50, 4717778.50, 4717778.50, 4717778.50, 4717778.50,
	7477175.00, 7477175.00, 7477175.00, 7477175.00, 7477175.00, 7477175.00, 7477175.00, 7477175.00,
	12210618.00, 12210618.00, 12210618.00, 12210618.00, 12210618.00, 12210618.00, 12210618.00, 12210618.00,
	20499234.00, 20499234.00, 20499234.00, 20499234.00, 20499234.00, 20499234.00, 20499234.00, 20499234.00,
	35541636.00, 35541636.00, 35541636.00, 35541636.00, 35541636.00, 35541636.00, 35541636.00, 35541636.00,
	63494696.00, 63494696.00, 63494696.00, 63494696.00, 63494696.00, 63494696.00, 63494696.00, 63494696.00,
	117418800.00, 117418800.00, 117418800.00, 117418800.00, 117418800.00, 117418800.00, 117418800.00, 117418800.00,
	224252560.00, 224252560.00, 224252560.00, 224252560.00, 224252560.00, 224252560.00, 224252560.00, 224252560.00,
	443340800.00, 443340800.00, 443340800.00, 443340800.00, 443340800.00, 443340800.00, 443340800.00, 443340800.00,
	911459584.00, 911459584.00, 911459584.00, 911459584.00, 911459584.00, 911459584.00, 911459584.00, 911459584.00,
	1935251712.00, 1935251712.00, 1935251712.00, 1935251712.00, 1935251712.00, 1935251712.00, 1935251712.00, 1935251712.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00 };

float absthr_1[] = {
	488357088.00, 5898447.00, 1131716.50, 466377.53, 265911.78, 180192.88, 135125.59, 108078.07,
	90518.55, 78295.64, 69141.30, 62335.81, 56981.98, 52569.95, 49061.14, 45997.86,
	43524.88, 41279.80, 39331.23, 37647.63, 36119.16, 34732.62, 33399.32, 32265.44,
	31170.05, 30111.86, 29156.65, 28231.74, 27336.16, 26469.00, 25629.35, 24816.33,
	24029.10, 23266.85, 22476.96, 21713.89, 20976.72, 20264.58, 19531.59, 18781.82,
	18102.46, 17367.51, 16700.81, 16022.77, 15336.90, 14680.39, 14051.98, 13419.54,
	12238.76, 12238.76, 11136.21, 11136.21, 10109.68, 10109.68, 9177.78, 9177.78,
	8331.78, 8331.78, 7598.67, 7598.67, 6962.06, 6962.06, 6408.22, 6408.22,
	5953.02, 5953.02, 5581.33, 5581.33, 5293.44, 5293.44, 5078.52, 5078.52,
	4928.76, 4928.76, 4861.13, 4861.13, 4849.95, 4849.95, 4917.42, 4917.42,
	5043.56, 5043.56, 5232.84, 5232.84, 5504.75, 5504.75, 5844.37, 5844.37,
	6262.35, 6262.35, 6756.75, 6756.75, 7323.82, 7323.82, 7975.13, 7975.13,
	9500.31, 9500.31, 9500.31, 9500.31, 11239.26, 11239.26, 11239.26, 11239.26,
	13174.60, 13174.60, 13174.60, 13174.60, 15126.47, 15126.47, 15126.47, 15126.47,
	17011.30, 17011.30, 17011.30, 17011.30, 18738.62, 18738.62, 18738.62, 18738.62,
	20264.58, 20264.58, 20264.58, 20264.58, 21614.12, 21614.12, 21614.12, 21614.12,
	22789.65, 22789.65, 22789.65, 22789.65, 23808.80, 23808.80, 23808.80, 23808.80,
	24816.33, 24816.33, 24816.33, 24816.33, 25807.00, 25807.00, 25807.00, 25807.00,
	26837.22, 26837.22, 26837.22, 26837.22, 27972.91, 27972.91, 27972.91, 27972.91,
	29223.86, 29223.86, 29223.86, 29223.86, 30671.68, 30671.68, 30671.68, 30671.68,
	32265.44, 32265.44, 32265.44, 32265.44, 34098.68, 34098.68, 34098.68, 34098.68,
	36119.16, 36119.16, 36119.16, 36119.16, 38524.55, 38524.55, 38524.55, 38524.55,
	41279.80, 41279.80, 41279.80, 41279.80, 44436.27, 44436.27, 44436.27, 44436.27,
	48054.89, 48054.89, 48054.89, 48054.89, 52328.41, 52328.41, 52328.41, 52328.41,
	62912.59, 62912.59, 62912.59, 62912.59, 62912.59, 62912.59, 62912.59, 62912.59,
	77756.66, 77756.66, 77756.66, 77756.66, 77756.66, 77756.66, 77756.66, 77756.66,
	98568.38, 98568.38, 98568.38, 98568.38, 98568.38, 98568.38, 98568.38, 98568.38,
	128451.02, 128451.02, 128451.02, 128451.02, 128451.02, 128451.02, 128451.02, 128451.02,
	172877.14, 172877.14, 172877.14, 172877.14, 172877.14, 172877.14, 172877.14, 172877.14,
	240291.06, 240291.06, 240291.06, 240291.06, 240291.06, 240291.06, 240291.06, 240291.06,
	346527.44, 346527.44, 346527.44, 346527.44, 346527.44, 346527.44, 346527.44, 346527.44,
	517294.19, 517294.19, 517294.19, 517294.19, 517294.19, 517294.19, 517294.19, 517294.19,
	806747.31, 806747.31, 806747.31, 806747.31, 806747.31, 806747.31, 806747.31, 806747.31,
	1308391.13, 1308391.13, 1308391.13, 1308391.13, 1308391.13, 1308391.13, 1308391.13, 1308391.13,
	2227088.75, 2227088.75, 2227088.75, 2227088.75, 2227088.75, 2227088.75, 2227088.75, 2227088.75,
	3969516.00, 3969516.00, 3969516.00, 3969516.00, 3969516.00, 3969516.00, 3969516.00, 3969516.00,
	7442819.50, 7442819.50, 7442819.50, 7442819.50, 7442819.50, 7442819.50, 7442819.50, 7442819.50,
	14714232.00, 14714232.00, 14714232.00, 14714232.00, 14714232.00, 14714232.00, 14714232.00, 14714232.00,
	30742394.00, 30742394.00, 30742394.00, 30742394.00, 30742394.00, 30742394.00, 30742394.00, 30742394.00,
	68349824.00, 68349824.00, 68349824.00, 68349824.00, 68349824.00, 68349824.00, 68349824.00, 68349824.00,
	161338400.00, 161338400.00, 161338400.00, 161338400.00, 161338400.00, 161338400.00, 161338400.00, 161338400.00,
	407134048.00, 407134048.00, 407134048.00, 407134048.00, 407134048.00, 407134048.00, 407134048.00, 407134048.00,
	1100874368.00, 1100874368.00, 1100874368.00, 1100874368.00, 1100874368.00, 1100874368.00, 1100874368.00, 1100874368.00,
	3196962048.00, 3196962048.00, 3196962048.00, 3196962048.00, 3196962048.00, 3196962048.00, 3196962048.00, 3196962048.00,
	10016993280.00, 10016993280.00, 10016993280.00, 10016993280.00, 10016993280.00, 10016993280.00, 10016993280.00, 10016993280.00,
	34020253696.00, 34020253696.00, 34020253696.00, 34020253696.00, 34020253696.00, 34020253696.00, 34020253696.00, 34020253696.00,
	124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
	124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
	124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
	124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
	124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
	124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
	124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
	124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
	124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
	124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
	124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
	124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00, 124950298624.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00 };

float absthr_2[] = {
	247592464.00, 3987838.75, 852584.69, 372166.75, 220667.11, 153016.27, 116879.30, 95003.05,
	80489.19, 70103.16, 62479.50, 56720.18, 52087.99, 48276.70, 45158.30, 42534.13,
	40247.38, 38347.55, 36537.39, 35054.00, 33630.83, 32339.82, 31098.37, 29973.51,
	28955.93, 27972.91, 26961.10, 26045.79, 25161.56, 24307.35, 23428.13, 22632.76,
	21814.11, 20976.72, 20171.47, 19397.13, 18609.62, 17813.02, 17089.82, 16320.66,
	15586.10, 14884.61, 14182.00, 13481.48, 12845.10, 12210.62, 11580.77, 10983.42,
	9902.33, 9902.33, 8907.13, 8907.13, 8030.41, 8030.41, 7273.40, 7273.40,
	6633.42, 6633.42, 6105.73, 6105.73, 5672.02, 5672.02, 5330.13, 5330.13,
	5090.23, 5090.23, 4928.76, 4928.76, 4849.95, 4849.95, 4861.13, 4861.13,
	4940.12, 4940.12, 5101.97, 5101.97, 5354.73, 5354.73, 5685.09, 5685.09,
	6091.69, 6091.69, 6602.94, 6602.94, 7206.72, 7206.72, 7902.01, 7902.01,
	8684.36, 8684.36, 9544.16, 9544.16, 10489.08, 10489.08, 11474.60, 11474.60,
	13574.93, 13574.93, 13574.93, 13574.93, 15694.14, 15694.14, 15694.14, 15694.14,
	17690.40, 17690.40, 17690.40, 17690.40, 19486.67, 19486.67, 19486.67, 19486.67,
	21025.08, 21025.08, 21025.08, 21025.08, 22373.69, 22373.69, 22373.69, 22373.69,
	23536.27, 23536.27, 23536.27, 23536.27, 24645.50, 24645.50, 24645.50, 24645.50,
	25747.65, 25747.65, 25747.65, 25747.65, 26899.09, 26899.09, 26899.09, 26899.09,
	28102.02, 28102.02, 28102.02, 28102.02, 29494.26, 29494.26, 29494.26, 29494.26,
	31098.37, 31098.37, 31098.37, 31098.37, 32865.30, 32865.30, 32865.30, 32865.30,
	34973.38, 34973.38, 34973.38, 34973.38, 37388.46, 37388.46, 37388.46, 37388.46,
	40154.81, 40154.81, 40154.81, 40154.81, 43424.77, 43424.77, 43424.77, 43424.77,
	47286.54, 47286.54, 47286.54, 47286.54, 51848.66, 51848.66, 51848.66, 51848.66,
	57113.34, 57113.34, 57113.34, 57113.34, 63348.68, 63348.68, 63348.68, 63348.68,
	70914.91, 70914.91, 70914.91, 70914.91, 79935.11, 79935.11, 79935.11, 79935.11,
	103929.20, 103929.20, 103929.20, 103929.20, 103929.20, 103929.20, 103929.20, 103929.20,
	140196.64, 140196.64, 140196.64, 140196.64, 140196.64, 140196.64, 140196.64, 140196.64,
	195766.14, 195766.14, 195766.14, 195766.14, 195766.14, 195766.14, 195766.14, 195766.14,
	284929.63, 284929.63, 284929.63, 284929.63, 284929.63, 284929.63, 284929.63, 284929.63,
	433249.00, 433249.00, 433249.00, 433249.00, 433249.00, 433249.00, 433249.00, 433249.00,
	688236.44, 688236.44, 688236.44, 688236.44, 688236.44, 688236.44, 688236.44, 688236.44,
	1150105.38, 1150105.38, 1150105.38, 1150105.38, 1150105.38, 1150105.38, 1150105.38, 1150105.38,
	2026457.63, 2026457.63, 2026457.63, 2026457.63, 2026457.63, 2026457.63, 2026457.63, 2026457.63,
	3782140.25, 3782140.25, 3782140.25, 3782140.25, 3782140.25, 3782140.25, 3782140.25, 3782140.25,
	7477175.00, 7477175.00, 7477175.00, 7477175.00, 7477175.00, 7477175.00, 7477175.00, 7477175.00,
	15766581.00, 15766581.00, 15766581.00, 15766581.00, 15766581.00, 15766581.00, 15766581.00, 15766581.00,
	35541636.00, 35541636.00, 35541636.00, 35541636.00, 35541636.00, 35541636.00, 35541636.00, 35541636.00,
	86047336.00, 86047336.00, 86047336.00, 86047336.00, 86047336.00, 86047336.00, 86047336.00, 86047336.00,
	224252560.00, 224252560.00, 224252560.00, 224252560.00, 224252560.00, 224252560.00, 224252560.00, 224252560.00,
	632029568.00, 632029568.00, 632029568.00, 632029568.00, 632029568.00, 632029568.00, 632029568.00, 632029568.00,
	1939713920.00, 1939713920.00, 1939713920.00, 1939713920.00, 1939713920.00, 1939713920.00, 1939713920.00, 1939713920.00,
	6497371136.00, 6497371136.00, 6497371136.00, 6497371136.00, 6497371136.00, 6497371136.00, 6497371136.00, 6497371136.00,
	23863681024.00, 23863681024.00, 23863681024.00, 23863681024.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
	96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
	96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
	96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
	96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
	96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
	96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
	96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
	96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
	96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
	96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
	96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00,
	96324681728.00, 96324681728.00, 96324681728.00, 96324681728.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00, 60776765194240.00,
	60776765194240.00 };

#pragma warning (default : 4305)

	double enwindow[] = {
	0.000000, -0.000000, -0.000000, -0.000000, -0.000000, -0.000000, -0.000000, -0.000001, -0.000001, -0.000001,
	-0.000001, -0.000001, -0.000001, -0.000002, -0.000002, -0.000002, -0.000002, -0.000003, -0.000003, -0.000003,
	-0.000004, -0.000004, -0.000005, -0.000005, -0.000006, -0.000007, -0.000008, -0.000008, -0.000009, -0.000010,
	-0.000011, -0.000012, -0.000014, -0.000015, -0.000017, -0.000018, -0.000020, -0.000021, -0.000023, -0.000025,
	-0.000028, -0.000030, -0.000032, -0.000035, -0.000038, -0.000041, -0.000043, -0.000046, -0.000050, -0.000053,
	-0.000056, -0.000060, -0.000063, -0.000066, -0.000070, -0.000073, -0.000077, -0.000081, -0.000084, -0.000087,
	-0.000091, -0.000093, -0.000096, -0.000099, 0.000102, 0.000104, 0.000106, 0.000107, 0.000108, 0.000109,
	0.000109, 0.000108, 0.000107, 0.000105, 0.000103, 0.000099, 0.000095, 0.000090, 0.000084, 0.000078,
	0.000070, 0.000061, 0.000051, 0.000040, 0.000027, 0.000014, -0.000001, -0.000017, -0.000034, -0.000053,
	-0.000073, -0.000094, -0.000116, -0.000140, -0.000165, -0.000191, -0.000219, -0.000247, -0.000277, -0.000308,
	-0.000339, -0.000371, -0.000404, -0.000438, -0.000473, -0.000507, -0.000542, -0.000577, -0.000612, -0.000647,
	-0.000681, -0.000714, -0.000747, -0.000779, -0.000810, -0.000839, -0.000866, -0.000892, -0.000915, -0.000936,
	-0.000954, -0.000969, -0.000981, -0.000989, -0.000994, -0.000995, -0.000992, -0.000984, 0.000971, 0.000954,
	0.000931, 0.000903, 0.000869, 0.000829, 0.000784, 0.000732, 0.000674, 0.000610, 0.000539, 0.000463,
	0.000379, 0.000288, 0.000192, 0.000088, -0.000021, -0.000137, -0.000260, -0.000388, -0.000522, -0.000662,
	-0.000807, -0.000957, -0.001111, -0.001270, -0.001432, -0.001598, -0.001767, -0.001937, -0.002110, -0.002283,
	-0.002457, -0.002631, -0.002803, -0.002974, -0.003142, -0.003307, -0.003467, -0.003623, -0.003772, -0.003914,
	-0.004049, -0.004175, -0.004291, -0.004396, -0.004490, -0.004570, -0.004638, -0.004691, -0.004728, -0.004749,
	-0.004752, -0.004737, -0.004703, -0.004649, -0.004574, -0.004477, -0.004358, -0.004215, -0.004049, -0.003859,
	-0.003643, -0.003402, 0.003135, 0.002841, 0.002522, 0.002175, 0.001801, 0.001400, 0.000971, 0.000516,
	0.000033, -0.000476, -0.001012, -0.001574, -0.002162, -0.002774, -0.003411, -0.004072, -0.004756, -0.005462,
	-0.006189, -0.006937, -0.007703, -0.008487, -0.009288, -0.010104, -0.010933, -0.011775, -0.012628, -0.013489,
	-0.014359, -0.015234, -0.016113, -0.016994, -0.017876, -0.018757, -0.019634, -0.020507, -0.021372, -0.022229,
	-0.023074, -0.023907, -0.024725, -0.025527, -0.026311, -0.027074, -0.027815, -0.028533, -0.029225, -0.029890,
	-0.030527, -0.031133, -0.031707, -0.032248, -0.032755, -0.033226, -0.033660, -0.034056, -0.034413, -0.034730,
	-0.035007, -0.035242, -0.035435, -0.035586, -0.035694, -0.035759, 0.035781, 0.035759, 0.035694, 0.035586,
	0.035435, 0.035242, 0.035007, 0.034730, 0.034413, 0.034056, 0.033660, 0.033226, 0.032755, 0.032248,
	0.031707, 0.031133, 0.030527, 0.029890, 0.029225, 0.028533, 0.027815, 0.027074, 0.026311, 0.025527,
	0.024725, 0.023907, 0.023074, 0.022229, 0.021372, 0.020507, 0.019634, 0.018757, 0.017876, 0.016994,
	0.016113, 0.015234, 0.014359, 0.013489, 0.012628, 0.011775, 0.010933, 0.010104, 0.009288, 0.008487,
	0.007703, 0.006937, 0.006189, 0.005462, 0.004756, 0.004072, 0.003411, 0.002774, 0.002162, 0.001574,
	0.001012, 0.000476, -0.000033, -0.000516, -0.000971, -0.001400, -0.001801, -0.002175, -0.002522, -0.002841,
	0.003135, 0.003402, 0.003643, 0.003859, 0.004049, 0.004215, 0.004358, 0.004477, 0.004574, 0.004649,
	0.004703, 0.004737, 0.004752, 0.004749, 0.004728, 0.004691, 0.004638, 0.004570, 0.004490, 0.004396,
	0.004291, 0.004175, 0.004049, 0.003914, 0.003772, 0.003623, 0.003467, 0.003307, 0.003142, 0.002974,
	0.002803, 0.002631, 0.002457, 0.002283, 0.002110, 0.001937, 0.001767, 0.001598, 0.001432, 0.001270,
	0.001111, 0.000957, 0.000807, 0.000662, 0.000522, 0.000388, 0.000260, 0.000137, 0.000021, -0.000088,
	-0.000192, -0.000288, -0.000379, -0.000463, -0.000539, -0.000610, -0.000674, -0.000732, -0.000784, -0.000829,
	-0.000869, -0.000903, -0.000931, -0.000954, 0.000971, 0.000984, 0.000992, 0.000995, 0.000994, 0.000989,
	0.000981, 0.000969, 0.000954, 0.000936, 0.000915, 0.000892, 0.000866, 0.000839, 0.000810, 0.000779,
	0.000747, 0.000714, 0.000681, 0.000647, 0.000612, 0.000577, 0.000542, 0.000507, 0.000473, 0.000438,
	0.000404, 0.000371, 0.000339, 0.000308, 0.000277, 0.000247, 0.000219, 0.000191, 0.000165, 0.000140,
	0.000116, 0.000094, 0.000073, 0.000053, 0.000034, 0.000017, 0.000001, -0.000014, -0.000027, -0.000040,
	-0.000051, -0.000061, -0.000070, -0.000078, -0.000084, -0.000090, -0.000095, -0.000099, -0.000103, -0.000105,
	-0.000107, -0.000108, -0.000109, -0.000109, -0.000108, -0.000107, -0.000106, -0.000104, 0.000102, 0.000099,
	0.000096, 0.000093, 0.000091, 0.000087, 0.000084, 0.000081, 0.000077, 0.000073, 0.000070, 0.000066,
	0.000063, 0.000060, 0.000056, 0.000053, 0.000050, 0.000046, 0.000043, 0.000041, 0.000038, 0.000035,
	0.000032, 0.000030, 0.000028, 0.000025, 0.000023, 0.000021, 0.000020, 0.000018, 0.000017, 0.000015,
	0.000014, 0.000012, 0.000011, 0.000010, 0.000009, 0.000008, 0.000008, 0.000007, 0.000006, 0.000005,
	0.000005, 0.000004, 0.000004, 0.000003, 0.000003, 0.000003, 0.000002, 0.000002, 0.000002, 0.000002,
	0.000001, 0.000001, 0.000001, 0.000001, 0.000001, 0.000001, 0.000000, 0.000000, 0.000000, 0.000000,
	0.000000, 0.000000 };
