dnl Copyright (C) 2002 Doxpara
dnl Licensed under the BSD License

# We need a few things to compile with libnet:
#
# 1) The location of libnet-config.  Unfortunately, `libnet-config
#    --cflags` does not output a -I/usr/wherever statement, so
#    we have to also determine...
#
# 2) The base directory of the libnet headers, which looks like this:
#    ${includedir}/libnet.h
#    ${includedir}/libnet/libnet-asn1.h
#    ${includedir}/libnet/libnet-functions.h
#
# 3) The location of the libnet library, which should be
#    ${includedir}/../lib.
#
# Note that if the user requests not to build with the builtin libnet
# and we cannot find libnet-config, we exit.

AC_DEFUN(DXP_LIBNET,[
	AC_ARG_WITH([libnet-bin],
	[  --with-libnet-bin=DIR   define location of libnet-config],
	[dxp_libnet_bin="$withval"],[dxp_libnet_bin=/usr/lib]
	)

	AC_ARG_WITH([libnet-builtin],
	[  --with-builtin-libnet   use builtin libnet],
	[dxp_libnet_builtin="$withval"],[dxp_libnet_builtin=yes]
	)

	dxp_libnet_builddir="$PWD"
	cd "$srcdir"

	echo -n "Checking if builtin libnet is already built... "
	if test -s Libnet-1.0.2a/lib/libnet.a; then
		echo yes
		dxp_libnet_builtin_libnet_already_built=yes
	else
		echo no
		dxp_libnet_builtin_libnet_already_built=no
	fi

	if test "$dxp_libnet_builtin" = "yes"; then
		dxp_libnet_config_path="$srcdir/Libnet-1.0.2a"
		if test "$dxp_libnet_builtin_libnet_already_built" = no; then
			echo "*** Building libnet dependency ***"
			rm -rf Libnet-1.0.2a
			gzip -d -c - < libnet-1.0.2a.tar.gz | tar xvf -
			cd Libnet-1.0.2a
			./configure
			if which gmake>0; then gmake; else make; fi
			cd ..
		fi
	else
		dxp_libnet_config_path="$dxp_libnet_bin:/usr/bin:/usr/local/bin:/opt/bin"
	fi

	_path="$PATH"
	PATH="$PATH:Libnet-1.0.2a"
	AC_PATH_PROG(dxp_libnet_config, libnet-config, no, [$dxp_libnet_config_path])
	if test $dxp_libnet_config = no; then
		echo "Could not find libnet-config in the path: $dxp_libnet_config_path."
		echo "libnet is required to compile minewt.  Get it from: "
		echo "http://www.packetfactory.net/libnet/"
		exit 1
	fi
	if test "$dxp_libnet_builtin" = "yes"; then
		DXP_LIBNET_FLAGS="`libnet-config --defines` -I$srcdir/Libnet-1.0.2a/include"
		DXP_LIBNET_LIBS="-lnet -L$srcdir/Libnet-1.0.2a/lib"
	else
		# FIXME depending on dirname is probably bad...
		dxp_libnet_root="$(dirname $dxp_libnet_config_path)/.."
		DXP_LIBNET_FLAGS="`libnet-config --defines -I$dxp_libnet_root/include/libnet`"
		DXP_LIBNET_LIBS="-lnet -L$dxp_libnet_root/lib"
	fi
	PATH="$_path"
	cd "$dxp_libnet_builddir"
])

AC_SUBST(DXP_LIBNET_FLAGS)
AC_SUBST(DXP_LIBNET_LIBS)

