/*
 * (c) Copyright 1998-2001 by Rob Braun
 * All rights reserved.  The file named COPYRIGHT specifies the terms
 * and conditions for redistribution.
 */
#ifndef _X_SERVICEDEFS
#define _X_SERVICEDEFS
#include "access.h"
#include "server.h"
#include "connection.h"
#include "service.h"

struct service    *svc_new(struct service_config *) ;
struct service    *svc_make_special(struct service_config *, statfunc) ;
void               svc_free(struct service *) ;
status_e           svc_activate(struct service *) ;
void               svc_setup_address_control(struct service *) ;
void               svc_deactivate(struct service *) ;
void               svc_suspend(struct service *) ;
void               svc_resume(struct service *) ;
int                svc_release(struct service *) ;
void               svc_dump(struct service *, int) ;
void               svc_request(struct service *) ;
status_e           svc_child_access_control(struct service *, connection_s *) ;
status_e           svc_parent_access_control(struct service *, connection_s *) ;
void               svc_shutdown(struct service *, connection_s *, char **) ;
void               svc_log_success(struct service *, connection_s *, pid_t) ;
void               svc_log_failure(struct service *, connection_s *, access_e) ;
void               svc_log_exit(struct service *, struct server *) ;
void               svc_logprint(struct service *, char *, char *, ...);
void               svc_postmortem(struct service *, struct server *) ;

idresult_e log_remote_user(struct server *, unsigned);
char *idresult_explain( idresult_e );

char *get_shutdown_by_addr( voidfunc );
#endif
