/*
 * (c) Copyright 1992 by Panagiotis Tsirigotis
 * (c) Sections Copyright 1998-2001 by Rob Braun
 * All rights reserved.  The file named COPYRIGHT specifies the terms 
 * and conditions for redistribution.
 */

#ifndef PARSE_H
#define PARSE_H

#include "conf.h"
#include "defs.h"

/*
 * $Id: parse.h,v 1.1.1.1 1999/10/12 17:28:59 bbraun Exp $
 */

typedef enum { NO_ENTRY, 
               BAD_ENTRY, 
               SERVICE_ENTRY, 
               DEFAULTS_ENTRY, 
               INCLUDE_ENTRY,
               INCLUDEDIR_ENTRY
} entry_e ;

enum assign_op { SET_EQ, PLUS_EQ, MINUS_EQ } ;

struct attribute
{
   char		*a_name ;            /* name of attribute							*/
   unsigned a_id ;               /* attribute id								*/
   int		a_nvalues ;				/* number of values							*/
   status_e (*a_parser)() ;		/* function that parses the attribute	*/
} ;


#define ENTRY_BEGIN              '{'
#define ENTRY_END                '}'
#define COMMENT_BEGIN            '#'
#define KW_SERVICE					"service"
#define KW_DEFAULTS					"defaults"
#define KW_INCLUDE					"include"
#define KW_INCLUDEDIR					"includedir"

extern int line_count ;

void parse_conf_file( int, struct configuration *);
void parse_end() ;
void parsemsg( int, char *, char *, ...);

int line_has_only_1_char( char *, char );
char *next_line( int );
status_e parse_line( char *, char **, enum assign_op *, pset_h );
void skip_entry( int );

#endif	/* PARSE_H */

