/*
 * (c) Copyright 1992 by Panagiotis Tsirigotis
 * (c) Copyright 1998-2001 by Rob Braun
 * All rights reserved.  The file named COPYRIGHT specifies the terms 
 * and conditions for redistribution.
 */

#ifndef ADDR_H
#define ADDR_H

/*
 * $Id: addr.h,v 1.1.1.1 1999/10/12 17:28:59 bbraun Exp $
 */

#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif

#include "defs.h"

#ifdef INET6
void       xsetmask(char *mask, unsigned int bits, int len) ;
int        addrlist_match(pset_h, struct in6_addr *, struct in6_addr *) ;
void       xaddrmap(char *v4, char *v6);
#else
int        addrlist_match(pset_h, struct in_addr *, uint32_t *) ;
#endif
void       addrlist_dump(pset_h, int) ;
void       addrlist_free(pset_h) ;
status_e   addrlist_add(pset_h, char *) ;
status_e   addrlist_remove(pset_h, char *) ;
status_e   addrlist_copy(pset_h, pset_h *) ;

#endif   /* ADDR_H */

