/*
 * (c) Copyright 1992, 1993 by Panagiotis Tsirigotis
 * All rights reserved.  The file named COPYRIGHT specifies the terms 
 * and conditions for redistribution.
 */

static char RCSid[] = "$Id: util.c,v 1.1.1.1 1999/10/12 17:28:59 bbraun Exp $" ;

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>

#include "config.h"
#include "str.h"

#ifndef NUL
#define NUL					'\0'
#endif

#ifndef NULL
#define NULL					0
#endif

/*
 * Search the given buffer for an occurrence of "%m"
 */
char *__xlog_add_errno( char *buf, int len )
{
	register char *s ;

	for ( s = buf ; s < &buf[ len-1 ] ; s++ )
		if ( *s == '%' && *(s+1) == 'm' )
			return( s ) ;
	return( NULL ) ;
}


char *__xlog_explain_errno( char *buf, unsigned *size )
{
	strx_nprint(buf, *size, "%s (errno = %d)", strerror(errno), errno);
#if 0
	if ( errno < sys_nerr )
	{
		register int len ;

		(void) strncpy( buf, strerror( errno ), (int)*size ) ;
		for ( len = 0 ; len < *size ; len++ )
			if ( buf[ len ] == NUL )
				break ;
		*size = len ;
	}
	else
		(void) strx_nprint( buf, *size, "errno = %d", errno ) ;
#endif
	return( buf ) ;
}


char *__xlog_new_string( char *s )
{
   if ( s )
      return strdup( s ) ;
   else
      return 0;
}


