/*
 * (c) Copyright 1993 by Panagiotis Tsirigotis
 * All rights reserved.  The file named COPYRIGHT specifies the terms 
 * and conditions for redistribution.
 */

#ifndef __TIMER_DEFS_H
#define __TIMER_DEFS_H

/*
 * $Id: defs.h,v 1.1.1.1 1999/10/12 17:28:59 bbraun Exp $
 */

#define PRIVATE					static

#ifndef NULL
#define NULL						0
#endif

#ifndef FALSE
#define FALSE						0
#define TRUE						1
#endif

#define TIMER_NULL				((timer_s *)0)
#define SIGVEC_NULL				((struct sigvec *)0)
#define SIGACTION_NULL			((struct sigaction *)0)

#define HANDLE_ERROR( flags, retval, errp, errval, msg )	\
		if ( flags & TIMER_RETURN_ERROR )            \
		{                                            \
			*errp = errval ;                        \
			return( retval ) ;                      \
		}                                            \
		else                                         \
		{									\
			char *s = msg ;                         \
																									\
			(void) write( 2, s, strlen( s ) ) ;     \
			abort() ;                               \
			_exit( 1 ) ;                            \
			/* NOTREACHED */                        \
		}
/* timer.h */
#include <setjmp.h>
enum timer_types { TIMER_REAL, TIMER_VIRTUAL, TIMER_PROF } ;
enum timer_timetypes { TIMER_ABSOLUTE, TIMER_RELATIVE } ;

struct timer_action
{
	int		ta_flags ;
	void		(*ta_func)() ;
	void		*ta_arg ;
	jmp_buf	ta_env ;
};

typedef void *timer_h ;
/* timer.h */

/* impl.h */
enum timer_state { INACTIVE, TICKING, DESTROYED } ;
enum action_state { IDLE, PENDING, SCHEDULED, INVOKED } ;


struct timer
{
	enum timer_state 	t_state ;
	enum action_state 	t_act ;
	int				t_blocked ;

	int 				t_flags ;
	int				*t_errnop ;
	struct os_timer	*t_ostimer ;
	struct timer_action	t_action ;

	/*
	 * The following fields are managed by the ostimer code.
	 * t_expiration is the (absolute) time when the timer will expire.
	 * t_interval is the repeat interval for the timer.
	 * t_expirations is the number of expirations of the timer when
	 * the function associated with the timer is invoked.
	 * t_count is the number of times that the timer has expired before
	 * the function was invoked.
	 */
	struct timeval		t_expiration ;
	struct timeval		t_interval ;
	unsigned			t_count ;
	unsigned			t_expirations ;
} ;

typedef struct timer timer_s ;
/* impl.h */


#endif /* __TIMER_DEFS_H */

