/*
 * (c) Copyright 1993 by Panagiotis Tsirigotis
 * All rights reserved.  The file named COPYRIGHT specifies the terms 
 * and conditions for redistribution.
 */

#ifndef IMPL_H
#define IMPL_H

/*
 * $Id: impl.h,v 1.1.1.1 1999/10/12 17:28:59 bbraun Exp $
 */

#include <sys/time.h>
#include <setjmp.h>

#include "pq.h"
#include "timer.h"
#include "ostimer.h"


#define TP( p )			( (struct timer *) (p) )
#define TIMER_ALLOC()		TP( malloc( sizeof( timer_s ) ) )
#define TIMER_FREE( tp )		(void) free( (char *)(tp) )

/*
 * The following are masks for the expected flags of timer_create and
 * timer_start
 */
#define TIMER_CREATE_FLAGS		TIMER_RETURN_ERROR
#define TIMER_START_FLAGS		\
			( TIMER_INC_VAR + TIMER_BLOCK_SAME + TIMER_BLOCK_ALL + TIMER_LONGJMP )


enum timer_state __timer_invoke( register timer_s *tp );	/* timer.c */
/* void __timer_terminate() ; */


#endif	/* IMPL_H */

