/*
 * (c) Copyright 1992 by Panagiotis Tsirigotis
 * (c) Sections Copyright 1998-2001 by Rob Braun
 * All rights reserved.  The file named COPYRIGHT specifies the terms 
 * and conditions for redistribution.
 */

#ifndef INT_H
#define INT_H

/*
 * $Id: int.h,v 1.1.1.1 1999/10/12 17:28:59 bbraun Exp $
 */

#include <sys/types.h>
#include <netinet/in.h>

#include "pset.h"

#include "defs.h"
#include "server.h"

typedef enum { GOOD_CHANNEL, BAD_CHANNEL } channel_state_e ;

struct channel
{
   channel_state_e      ch_state ;
#ifdef INET6
   struct sockaddr_in6  ch_from ;
#else
   struct sockaddr_in   ch_from ;
#endif
   int                  ch_local_socket ;
   int                  ch_remote_socket ;
} ;

typedef struct channel channel_s ;

#define CHP( p )                 ((struct channel *)(p))

#define CHANNEL_NULL             CHP( NULL )

#define NEW_CHANNEL()            NEW( channel_s )
#define FREE_CHANNEL( chp )      FREE( chp )


struct intercept_common
{
   bool_int             ic_intercept ;
   int                  ic_remote_socket ;
#ifdef INET6
   struct sockaddr_in6  ic_local_addr ;
#else
   struct sockaddr_in   ic_local_addr ;
#endif
   pset_h               ic_connections ;
   struct server        ic_server ;
} ;


struct intercept_ops
{
   void (*mux)() ;
   void (*exit)() ;
} ;


struct intercept
{
   int                        int_socket_type ;
   struct intercept_common    int_common ;
   void                      *int_priv ;
   struct intercept_ops      *int_ops ;
} ;

#define INT_TYPE( p )                ((p)->int_socket_type)
#define INT_SERVER( p )              (&(p)->int_common.ic_server)
#define INT_LOCALADDR( p )           (&(p)->int_common.ic_local_addr)
#define INT_REMOTE( p )              ((p)->int_common.ic_remote_socket)
#define INT_ALLOCATOR( p )           ((p)->int_common.ic_channel_allocator)
#define INT_CONNECTIONS( p )         ((p)->int_common.ic_connections)
#define INTERCEPT( p )               ((p)->int_common.ic_intercept)

void         intercept( struct server * ) ;
void         int_fail(struct intercept *, char *) ;
int          int_select(int, fd_set *) ;
void         int_exit(struct intercept *) ;
void         int_init(struct intercept *, struct server *) ;
void         int_sighandler( int );
#ifdef INET6
channel_s *int_newconn(struct intercept *, struct sockaddr_in6 *, int) ;
channel_s *int_lookupconn(struct intercept *, struct sockaddr_in6 *, bool_int *);
#else
channel_s *int_newconn(struct intercept *, struct sockaddr_in *, int) ;
channel_s *int_lookupconn(struct intercept *, struct sockaddr_in *, bool_int *);
#endif

#endif   /* INT_H */
