/*
 * (c) Copyright 1992 by Panagiotis Tsirigotis
 * All rights reserved.  The file named COPYRIGHT specifies the terms 
 * and conditions for redistribution.
 */

static char RCSid[] = "$Id: misc.c,v 1.1.1.1 1999/10/12 17:28:59 bbraun Exp $" ;
#include "config.h"
#ifdef MISC_VERSION
static char misc_version[] = MISC_VERSION ;
#endif

#include <stdarg.h>
#include <stdlib.h>
#include <string.h>

/*
 * MISCELLANEOUS FUNCTIONS
 */

#include "misc.h"


/*
 * Create a new argv array,
 * copy the original to the new one,
 * and clear the old one
 */
char **argv_copy_and_clear( char **org_argv, int start, int count )
{
   char **new_argv ;
   char *p ;
   int i ;
   int j ;

   new_argv = (char **) malloc( count * sizeof( char * ) ) ;
   if ( new_argv == NULL )
      return( NULL ) ;

   for ( i = 0 ; i < count ; i++ )
   {
      new_argv[ i ] = make_string_cat( 1, org_argv[ start+i ] ) ;
      if ( new_argv[ i ] == NULL )
      {
         for ( j = i-1 ; j >= 0 ; j-- )
            free( new_argv[ j ] ) ;
         free( (char *) new_argv ) ;
         return( NULL ) ;
      }
      for ( p = org_argv[ start+i ] ; *p ; p++ )
         *p = ' ' ;
   }
   return( new_argv ) ;
}


/*
 * We always return a pointer in pathname
 */
#if !defined(linux)
char *basename( char *pathname )
{
   char *s = strrchr( pathname, '/' ) ;

   if ( s == NULL )
      return( pathname ) ;
   else
      return( s+1 ) ;
}
#endif


/*
 * We always return a malloced string
 *
 * There are 2 special cases:
 *
 *      1) pathname == "/"
 *            In this case we return "/"
 *      2) pathname does not contain a '/'
 *            In this case we return "."
 */
char *dirname( const char *pathname )
{
   int len ;
   char *s = strrchr( pathname, '/' ) ;
   char *p ;

   if ( s == NULL )
      return( make_string_cat( 1, "." ) ) ;
   else
   {
      len = s - pathname ;
      if ( len == 0 )
         return( make_string_cat( 1, "/" ) ) ;
   }

   p = (char *)malloc( len+1 ) ;
   if ( p == NULL )
      return( NULL ) ;
   else
   {
      strncpy( p, pathname, len )[ len ] = '\0' ;
      return( p ) ;
   }
}


char *make_string_cat( register unsigned count, ... )
{
   va_list ap ;
   register unsigned i ;
   register unsigned len = 0 ;
   register char *s, *p ;
   char *newstring ;

   if ( count == 0 )
      return( NULL ) ;

   va_start( ap, count ) ;
   if (count == 1)
   {  /* 9 out of 10 have just 1, so this optimizes it */
      s = va_arg( ap, char * ) ;
      va_end( ap );
      if ( s == NULL )
         return strdup("");
      else
         return strdup(s);
   }
   for ( i = 0 ; i < count ; i++ )
   {
      s = va_arg( ap, char * ) ;
      if ( s == NULL )
         continue ;
      len += strlen( s ) ;
   }
   va_end( ap ) ;

   newstring = (char *)malloc( len + 1 ) ;
   if ( newstring == NULL )
      return( NULL ) ;

   p = newstring ;
   va_start( ap, count ) ;
   for ( i = 0 ; i < count ; i++ )
   {
      s = va_arg( ap, char * ) ;
      if ( s == NULL )
         continue ;
      while ( (*p++ = *s++) ) ;
      p-- ;
   }
   va_end( ap ) ;
   newstring[len] = 0;	/* if len == 0, must terminate or boom! */
   return newstring ;
}


char *make_pathname( register unsigned count, ... )
{
   va_list ap ;
   register unsigned i ;
   register unsigned len = 0 ;
   register char *s, *p ;
   char *pathname ;

   if ( count == 0 )
      return( NULL ) ;

   va_start( ap, count ) ;
   for ( i = 0 ; i < count ; i++ )
   {
      s = va_arg( ap, char * ) ;
      len += strlen( s ) ;
   }
   va_end( ap ) ;

   pathname = (char *)malloc( len + count ) ;
   if ( pathname == NULL )
      return( NULL ) ;

   p = pathname ;
   va_start( ap, count ) ;
   for ( i = 0 ; i < count ; i++ )
   {
      s = va_arg( ap, char * ) ;
      while ( (*p++ = *s++) ) ;
      *(p-1) = '/' ;         /* change '\0' to '/' */
   }
   *(p-1) = '\0' ;
   va_end( ap ) ;
   return( pathname ) ;
}


