#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <syslog.h>
#include <errno.h>
#include <pwd.h>
#include <fcntl.h>
#include <stdio.h>
#include <sys/wait.h>
#include <signal.h>
#include <netinet/tcp.h>
#ifdef bsdi
#include <arpa/inet.h>
#endif

#if defined(linux) && !defined(SIGHUP)
#define        SIGHUP          1       /* Hangup (POSIX).  */
#endif

#include "str.h"
#include "pset.h"

#include "options.h"

#include "attr.h"
#include "server.h"
#include "state.h"
#include "sconst.h"
#include "config.h"

#ifdef sun
#include <sys/signal.h>
#endif

#define NET_BUFFER 1500

int RedirServerFd, RedirDescript;

/* Theoretically, this gets invoked when the remote side is no
 * longer available for reading or writing.
 * So, we send a HUP to the child process, wait(), then exit.
 */
void redir_sigpipe() 
{
	close(RedirServerFd);
	exit(0);
}

/* Do the redirection of a service */
/* This function gets called from child.c after we have been forked */
void redir_handler( struct server *serp )
{
	struct service *sp = SERVER_SERVICE( serp );
	struct service_config *scp = SVC_CONF( sp );
	int RedirDescrip = SERVER_FD( serp );
	int maxfd, num_read, num_wrote=0, ret=0;
	int no_to_nagle = 1;
	int on = 1;
	char buff[NET_BUFFER];
	fd_set rdfd, msfd;
	struct timeval *timep = NULL;
#ifdef INET6
	struct sockaddr_in6 serveraddr;
#else
	struct sockaddr_in serveraddr;
#endif

	if( signal(SIGPIPE, redir_sigpipe) == SIG_ERR ) {
		syslog(LOG_ERR, "redir_hander: unable to setup signal handler");
	}

	/* If it's a tcp service we are redirecting */
	if( scp->sc_protocol.value == IPPROTO_TCP )
	{
#ifdef INET6
		char foo[128];
		RedirServerFd = socket(AF_INET6, SOCK_STREAM, 0);
		bzero(foo, 128);
#else
		char *foo;
		RedirServerFd = socket(AF_INET, SOCK_STREAM, 0);
#endif

		if( RedirServerFd < 0 )
		{
			syslog(LOG_ERR, "redir_handler:socket: cannot create socket.");
			exit(0);
		}

		if( SC_KEEPALIVE( scp ) )
			if(setsockopt(RedirServerFd, SOL_SOCKET, SO_KEEPALIVE, (char *)&on, sizeof(on)) < 0 )
				syslog(LOG_ERR, "REDIR: setsockopt SO_KEEPALIVE RedirServerFd failed");
		
		bzero(&serveraddr, sizeof(serveraddr));

#ifdef INET6
		serveraddr.sin6_family = AF_INET6;
		serveraddr.sin6_port = htons(scp->sc_redir_port);
		memcpy(&serveraddr.sin6_addr, &scp->sc_redir_addr, \
			sizeof(struct in6_addr));

		inet_ntop(AF_INET6, &serveraddr.sin6_addr, foo, 128);
#else
		serveraddr.sin_family = AF_INET;
		serveraddr.sin_port = htons(scp->sc_redir_port);
		serveraddr.sin_addr.s_addr = scp->sc_redir_addr->s_addr;

		foo = (char *)inet_ntoa( serveraddr.sin_addr );
#endif
		
		if( connect(RedirServerFd, (struct sockaddr *)&serveraddr, \
			sizeof(struct sockaddr_in)) < 0 )
		{
			syslog(LOG_ERR, "redir_handler:connect: can't connect to remote host %s", foo);
			exit(0);
		}

		/* connection now established */

		if (setsockopt(RedirServerFd, IPPROTO_TCP, TCP_NODELAY, 
			(char *) &no_to_nagle, sizeof(int)) < 0) {

			syslog(LOG_ERR, "REDIR: setsockopt RedirServerFd failed");
		}

		if (setsockopt(RedirDescrip, IPPROTO_TCP, TCP_NODELAY, 
			(char *) &no_to_nagle, sizeof(int)) < 0) {

			syslog(LOG_ERR, "REDIR: setsockopt RedirDescrip failed");
		}

		maxfd = (RedirServerFd > RedirDescrip)?RedirServerFd:RedirDescrip;
		FD_ZERO(&msfd);
		FD_SET(RedirDescrip, &msfd);
		FD_SET(RedirServerFd, &msfd);

		while(1) {
			(void)bcopy(&msfd, &rdfd, sizeof(fd_set));
			if (select(maxfd + 1, &rdfd, (fd_set *)0, (fd_set *)0, timep) <= 0) {
				/* place for timeout code, currently does not time out */
				break;
			}

			if (FD_ISSET(RedirDescrip, &rdfd)) {
				if ((num_read = read(RedirDescrip,buff, NET_BUFFER)) <= 0)
					goto REDIROUT;

				/* Loop until we have written everything that was read */
				num_wrote = 0;
				while( num_wrote < num_read ) {
					ret = write(RedirServerFd, buff+num_wrote, num_read-num_wrote);
					if( ret < 0 ) {
						goto REDIROUT;
					}

					num_wrote += ret;
				}
			}
	
			if (FD_ISSET(RedirServerFd, &rdfd)) {
				if ((num_read = read(RedirServerFd, buff, NET_BUFFER)) <= 0)
					goto REDIROUT;

				/* Loop until we have written everything that was read */
				num_wrote = 0;
				while( num_wrote < num_read ) {
					ret = write(RedirDescrip, buff+num_wrote, num_read-num_wrote);
					if( ret < 0 ) {
						goto REDIROUT;
					}

					num_wrote += ret;
				}
			}

		}
REDIROUT:
		exit(0);
	}
	
	syslog(LOG_ERR, "redir_handler: redirect with any protocol other than tcp is not supported at this time.");
	exit(0);
}
