Summary: A privileged helper for utmp/wtmp updates.
Name: utempter
%define version 0.5.2
Version: %{version}
Release: 3
Copyright: MIT
Group: System Environment/Base
Source: utempter-%{version}.tar.gz
Prereq: /usr/sbin/groupadd, /sbin/ldconfig, fileutils
BuildRoot: /var/tmp/%{name}-root

%description
Utempter is a utility which allows some non-privileged programs to
have required root access without compromising system
security. Utempter accomplishes this feat by acting as a buffer
between root and the programs.

%prep
%setup  -q

%build
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS"

%install
rm -rf $RPM_BUILD_ROOT
make PREFIX=$RPM_BUILD_ROOT install
strip $RPM_BUILD_ROOT/usr/sbin/utempter

%clean
rm -rf $RPM_BUILD_ROOT

%pre 
/usr/sbin/groupadd -g 22 -r -f utmp

%post
/sbin/ldconfig

if [ -f /var/log/wtmp ]; then
    chown root.utmp /var/log/wtmp
    chmod 664 /var/log/wtmp
fi

if [ -f /var/run/utmp ]; then
    chown root.utmp /var/run/utmp
    chmod 664 /var/run/utmp
fi

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%attr(02755, root, utmp) /usr/sbin/utempter
%doc COPYING
/usr/lib/libutempter.so*
/usr/include/utempter.h

%changelog
* Sat Jun 17 2000 Matt Wilson <msw@redhat.com>
- defattr root

* Thu Feb 24 2000 Erik Troan <ewt@redhat.com>
- added LGPL notice

* Mon Sep 13 1999 Bill Nottingham <notting@redhat.com>
- strip utempter

* Mon Aug 30 1999 Bill Nottingham <notting@redhat.com>
- add utmp as group 22

* Fri Jun  4 1999 Jeff Johnson <jbj@redhat.com>
- ignore SIGCHLD while processing utmp.
