#ifndef _QUOTAOPS_H
#define _QUOTAOPS_H

struct quotause {
   struct quotause *next;
   long flags;
   struct dqblk dqblk;
   char fsname[MAXPATHLEN + 1];
   char qfname[1];
};

__BEGIN_DECLS 
extern int read_quota_from_file __P (( const char *qfpathname, long id, struct dqblk *dqblk));
extern int write_quota_to_file __P ((const char *qfpathname, long id, struct dqblk *dqblk));
extern struct quotause *getprivs __P ((long id, int quotatype, char local_only));
extern int putprivs __P ((long id, int quotatype, struct quotause *quplist));
extern int editprivs __P ((char *tmpfile));
extern int writeprivs __P ((struct quotause *quplist, int outfd, char *name, int quotatype));
extern int readprivs __P ((struct quotause *quplist, int infd));
extern int writetimes __P ((struct quotause *quplist, int outfd, int quotatype));
extern int readtimes __P ((struct quotause *quplist, int infd));
extern int freeprivs __P ((struct quotause *quplist));
__END_DECLS

#endif /* _QUOTAOPS_H */
