/*
 * Miscellaneous syscall wrappers.
 */

#ifndef _POP_MISC_H
#define _POP_MISC_H

/*
 * A select(2)-based sleep() equivalent: no more problems with SIGALRM,
 * subsecond precision.
 */
extern int sleep_select(int sec, int usec);

/*
 * Obtains an exclusive lock, restarting on possible EBUSY errors.
 */
extern int flock_loop(int fd);

/*
 * Attempts to write all the supplied data. Returns the number of bytes
 * written. Any value that differs from the requested count means that
 * an error has occured; if the value is -1, errno is set appropriately.
 */
extern int write_loop(int fd, char *buffer, int count);

#endif
