#include <string.h>
#include <stdlib.h>

#define PAM_SM_AUTH
#include <security/pam_modules.h>
#include <security/pam_client.h>

#include <security/_pam_userpass.h>

PAM_EXTERN int pam_sm_authenticate(pam_handle_t *pamh, int flags,
	int argc, const char **argv)
{
	struct pam_conv *conv;
	pamc_bp_t prompt;
	struct pam_message msg, *pmsg;
	struct pam_response *resp;
	char *user, *data;
	int status;

	status = pam_get_item(pamh, PAM_CONV, (const void **)&conv);
	if (status != PAM_SUCCESS)
		return status;

	status = pam_get_item(pamh, PAM_USER, (const void **)&user);
	if (status != PAM_SUCCESS)
		return status;

	prompt = NULL;
	PAM_BP_RENEW(&prompt, PAM_BPC_SELECT,
		USERPASS_AGENT_ID_LENGTH + 1 + 1 + (user ? strlen(user) : 0));
	data = PAM_BP_DATA(prompt);

	memcpy(data, USERPASS_AGENT_ID "/", USERPASS_AGENT_ID_LENGTH + 1);
	data += USERPASS_AGENT_ID_LENGTH + 1;
	if (user && *user) {
		*data++ = USERPASS_USER_KNOWN;
		memcpy(data, user, strlen(user));
	} else
		*data = USERPASS_USER_REQUIRED;

	pmsg = &msg;
	msg.msg_style = PAM_BINARY_PROMPT;
	msg.msg = (const char *)prompt;

	resp = NULL;
	status = conv->conv(1, (const struct pam_message **)&pmsg, &resp,
		conv->appdata_ptr);

	PAM_BP_RENEW(&prompt, 0, 0);

	if (status != PAM_SUCCESS)
		return status;

	if (!resp)
		return PAM_AUTH_ERR;

	prompt = (pamc_bp_t)resp->resp;
	data = PAM_BP_DATA(prompt);

	if (PAM_BP_CONTROL(prompt) == PAM_BPC_DONE &&
	    strlen(data) + 1 < PAM_BP_LENGTH(prompt)) {
		status = pam_set_item(pamh, PAM_USER, data);
		if (status == PAM_SUCCESS) {
			data += strlen(data) + 1;
			status = pam_set_item(pamh, PAM_AUTHTOK, data);
		}
	} else
		status = PAM_AUTH_ERR;

	PAM_BP_RENEW(&prompt, 0, 0);
	free(resp);

	return status;
}

PAM_EXTERN int pam_sm_setcred(pam_handle_t *pamh, int flags,
	int argc, const char **argv)
{
	return PAM_SUCCESS;
}

#ifdef PAM_STATIC
struct pam_module _pam_userpass_modstruct = {
	"pam_userpass",
	pam_sm_authenticate,
	pam_sm_setcred,
	NULL,
	NULL,
	NULL,
	NULL
};
#endif
