/*
 * Copyright (c) 2000 by Solar Designer. See LICENSE.
 */

#ifndef _PASSWDQC_H
#define _PASSWDQC_H

#include <pwd.h>

struct passwdqc_params {
	int min[5], max;
	int passphrase_words;
	int match_length;
	int similar_deny;
	int random_bits;
};

extern char _passwdqc_wordset_4k[0x1000][6];

extern char *_passwdqc_check(struct passwdqc_params *params,
	char *newpass, char *oldpass, struct passwd *pw);
extern char *_passwdqc_random(struct passwdqc_params *params);

#endif
