/* @(#)align.h	1.3 06/09/26 Copyright 1995-2006 J. Schilling */
/*
 *	Platform dependent definitions for aligning data.
 *
 *	Copyright (c) 1995-2006 J. Schilling
 */
/*
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * See the file CDDL.Schily.txt in this distribution for details.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file CDDL.Schily.txt from this distribution.
 */

/*
 *	The automatically created included file defines the following macros:
 *
 *	saligned(a)	One parameter aligned for a "short int"
 *	s2aligned(a, b)	Both parameters aligned for a "short int"
 *	ialigned(a)	One parameter aligned for a "int"
 *	i2aligned(a, b)	Both parameters aligned for a "int"
 *	laligned(a)	One parameter aligned for a "long"
 *	l2aligned(a, b)	Both parameters aligned for a "long"
 *	llaligned(a)	One parameter aligned for a "long long"
 *	ll2aligned(a, b) Both parameters aligned for a "long long"
 *	faligned(a)	One parameter aligned for a "float"
 *	f2aligned(a, b)	Both parameters aligned for a "float"
 *	daligned(a)	One parameter aligned for a "double"
 *	d2aligned(a, b)	Both parameters aligned for a "double"
 *	paligned(a)	One parameter aligned for a "pointer"
 *	p2aligned(a, b)	Both parameters aligned for a "pointe"
 *
 *	salign(x)	Align for a "short int"
 *	ialign(x)	Align for a "int"
 *	lalign(x)	Align for a "long"
 *	llalign(x)	Align for a "long long"
 *	falign(x)	Align for a "float"
 *	dalign(x)	Align for a "double"
 *	palign(x)	Align for a "pointer"
 */
#ifndef _SCHILY_ALIGN_H
#define	_SCHILY_ALIGN_H

#ifndef	_SCHILY_UTYPES_H
#include <schily/utypes.h>
#endif

#ifdef	SCHILY_BUILD	/* #defined by Schily makefile system */
	/*
	 * Include $(SRCROOT)/incs/$(OARCH)/align.h via
	 * -I$(SRCROOT)/incs/$(OARCH)/
	 */
#	include <align.h>
#else
/*
 * XXX Here belongs the stuff for non-dynamic autoconfiguration.
 */
#endif

#endif /* _SCHILY_ALIGN_H */
