.\" Copyright (c) 1999 Ottavio G. Rizzo <rizzo@pluto.linux.it>
.\"
.\" This is free documentation; you can redistribute it and/or
.\" modify it under the terms of the GNU General Public License as
.\" published by the Free Software Foundation; either version 2 of
.\" the License, or (at your option) any later version.
.\"
.\" The GNU General Public License's references to "object code"
.\" and "executables" are to be interpreted as the output of any
.\" document formatting or typesetting system, including
.\" intermediate and printed output.
.\"
.\" This manual is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public
.\" License along with this manual; if not, write to the Free
.\" Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
.\" USA.
.\" 
.TH MAKEWHATIS 8 "22 January 1999" 
.SH NAME
makewhatis \- Create the whatis database
.SH SYNOPSIS
.BI "makewhatis [-u] [-v] [-w] [-s " sections " ] [-c [" catpath "]] [" manpath "]"
.SH DESCRIPTION
.B makewhatis
reads all the manual pages contained in the given
.IR sections " of " manpath 
or the preformatted pages contained in the given
.IR sections " of " catpath .
For each page, it writes a line in the whatis database; each line
consists of the name of the page and a short description, separated
by a dash. The description is extracted using the content of the
NAME section of the manual page.
.LP
Since other languages use a different term for the NAME section,
.B makewhatis
recognizes the equivalent terms in Czech, Italian, Finnish, French,
German and Spanish.
.LP
If no
.I manpath
argument is given,
.I /usr/man
is assumed by default.
.SH OPTIONS
.TP
.B -u
Update database with new pages.
.TP
.B -v
Verbose output
.TP
.B -w
Use manpath obtained from `man --path`
.TP 
.BI -s " sections"
Looks in the
.I sections
of
.IR manpath " or " catpath .
If the option is absent, its value is assumed to be
.I  \'1 2 3 4 5 6 7 8 9 n l\'
.TP 
.BI -c " catpath"
The preformatted manual pages located in
.I catpath
are scanned. If the argument is not provided, it is assumed to be the
first existing directory between
.IR /usr/man/preformat " and " /usr/man .
.SH EXAMPLES
.PP
To rebuild only 
.IR /usr/X11R6/man/whatis " and " /usr/local/man/whatis
.IP 
makewhatis /usr/X11R6/man /usr/local/man
.PP
To rebuild all the databases, including those of the Finnish, French
and Italian translations
.IP
LANGUAGE=fi:fr:it makewhatis -w
.SH BUGS
.B makewhatis
may not handle too well manual pages written with non-standard troff
macros, such as the Tcl/Tk pages.
.PP
.B makewhatis
does not work on preformatted translations.
.SH SEE ALSO
.BR apropos (1),
.BR man (1),
.BR whatis (1)
