;  chain.S  -  LILO boot chainer 
;
; Copyright 1992-1998 Werner Almesberger.
; Copyright 1999-2001 John Coffman.
; All rights reserved.
;
; Licensed under the terms contained in the file 'COPYING' in the 
; source directory.
;

#define REVERSE_DL 1

#if defined(LCF_SOLO_CHAIN) && !defined(DOS_D)

#ifndef DOS_D
#define DOS_D
#endif

#ifndef CHECK
#define CHECK
#endif

#endif		/* LCF_SOLO_CHAIN */

#define LILO_ASM
#include "lilo.h"

#if VERSION_MINOR >= 50
#define DEBUG
#endif

	.text

	.globl	_main
	.org	0

_main:	jmp	start

	
	.org	6

	.ascii	"LILO"
	.word	STAGE_CHAIN
	.word	VERSION

offset:	.word	0
drive:	.byte	0			! drive, 0x80, 0x81
	.byte	0			! head, always zero

hint:	.word	drvmap			! pointer to drive map

ptable:	.blkw	0x20			! partition table to preload

start:
	xor	ax,ax			! set SS:SP to 0:7C00
	mov	ss,ax
	mov	sp,#BOOTSEG*16		! #0x7C00
	mov	bp,sp			! address from BP
	push	cs
	pop	ds			! DS = SETUPSEG
	mov	es,ax
	mov	cx,#SECTOR_SIZE/2
mtmp = SETUPSECS-1			! broken math ...
	mov	si,#mtmp*SECTOR_SIZE
	mov	di,bp			! #0x7C00
	rep
	  movsw
#ifdef DOS_D
#ifdef CHECK
	mov	si,#BOOTSEG*16+0x24	; address of first byte to test

	cmp	byte (bp+0x15),#0xf8		; check media descriptor
	jne	ck_failed

	seg	es
	  lodsb
	cmp	al,#0x80		; check range of device codes
	jb	ck_failed
	cmp	al,#0x8f
	ja	ck_failed

	seg	es
	  lodsb
	or	al,al			; check hi-byte is empty
	jnz	ck_failed

	seg	es
	  lodsb
	cmp	al,#0x29		; I do not know what this byte means
	je	ck_okay
	cmp	al,#0x28		; HPFS marker
	jne	ck_failed

ck_okay:
	lea	si,(si+4)		; address of vol label & fs type
	mov	cx,#11			; volume label (11)
ck_next:
	seg	es
	  lodsb
	or	al,al
	js	ck_failed		; not alphabetic if >= 0x80
	jz	ck_loop			; NUL allowed for HPFS
	cmp	al,#0x20
	jb	ck_failed		; not alphabetic if < SPACE
ck_loop:
	loop	ck_next

	mov	cx,#8			; check Filesystem type
ck_fstype:
	seg	es
	  lodsb
	or	al,al			; not alphabetic if >= 0x80
	js	ck_failed
	cmp	al,#0x20		; not alphabetic if < SPACE
	jb	ck_failed
	loop	ck_fstype

#endif
dos4:
	call	revmap1

	mov	(bp+0x24),dx		! fill in 0x24 and 0x25
	mov	si,offset
#ifdef LCF_M386
	mov	edx,ptable+8(si)
	mov	(bp+0x1C),edx
#else
	mov	dx,ptable+8(si)
	seg	es
	  mov	BOOTSEG*16+0x1C,dx
	mov	dx,ptable+10(si)
	seg	es
	  mov     BOOTSEG*16+0x1E,dx
#endif

#ifdef DEBUG
	mov	si,#update
	jmp	ck_say   
ck_failed:
	mov	si,#no_update
ck_say:
	call	say
	jmp	ck_beyond
no_update:
	.ascii	"NO "
update:
	.ascii	"24-25 update has occurred"
	.byte	13,10,13,10,13,10,13,10,13,10,13,10,0
ck_beyond:
#else
ck_failed:
#endif

#endif
	mov	cx,#0x20		! move partition table
	mov	si,#ptable
	mov	di,#PART_TABLE
	rep
	movsw
					! mess with the partition table
#if defined(LCF_REWRITE_TABLE) && !defined(LCF_READONLY)
	mov	si,#prtmap		! get partition table change rules
prtclp:	lodsw				! bios == 0 indicates end
	or	al,al
	jz	pmend			! at end -> quit
	cmp	al,cache		! already in cache ?
	je	incache			! yes -> no loading required
	push	ax			! save table data
	call	flush			! flush the cache
	pop	ax
	push	ax
	mov	cache,al		! remember drive in cache
	cmp	al,drive		! boot drive ?
	jne	noc			! no -> load into scratch area
	xor	ax,ax			! load at 0000:0600
	mov	bx,#PARTS_LOAD
	jmp	loadit
noc:	mov	ax,ds
	mov	bx,#PARTS_SCR		! scratch area
loadit:	mov	es,ax			! set up pointers and remember them
	mov	ces,ax
	mov	cbx,bx
	mov	ax,#0x201		! load partition table, one sector
	mov	dx,cache		! drive from cache (DH = 0)
	mov	cx,#1
	int	0x13			! load it
	jc	wrfail			! error -> abort
	pop	ax			! get BIOS and offset
incache:les	bx,cbx			! load pointer
	add	bx,#PART_TABLE_OFFSET	! move to partition table
	add	bl,ah			! offset is always in [0x1be,0x1fd]
	lodsw				! see what we need to do
	seg	es			! match ?
	cmp	byte ptr (bx),al
	jne	nocng			! no -> do not change
	seg	es			! change
	mov	byte ptr (bx),ah
	mov	byte ptr dirty,#1	! mark as dirty
nocng:	br	prtclp			! next one

flush:	test	byte ptr dirty,#1	! dirty ?
	jz	noflush			! no -> do not write
	mov	ax,#0x301		! write one sector
	mov	dx,cache		! get the drive
	or	dl,dl			! nothing cached ?
	jz	noflush			! no -> do not flush
	les	bx,cbx			! reload pointer
	int	0x13			! write ...
	jc	wrfail			! argl
noflush:ret
pmend:	call	flush			! flush table
	br	nopp			! and proceed
wrfail:	mov	si,#failmsg		! complain
	call	say
	mov	ax,#FIRSTSEG		! try to restart LILO
	jmpi	#GO,FIRSTSEG

cache:	.byte	0			! drive, 0 means not cached
	.byte	0			! head, always 0
cbx:	.blkw	1
ces:	.blkw	1
dirty:	.byte	0

#endif

; reverse drive mapping
;	uses AX, SI
;       may update DL
;
revmap1:  mov	dx,drive	; get drive/head pair
revmap:
	mov	si,#drvmap
rev0:	lodsw			; get to, from pair
	or	ax,ax		; test for end
	jz	rev9		; done
	cmp	ah,dl		; booting from "to"
	jne	rev0		; loop if not
	mov	dl,al		; substitute the "from"
rev9:	ret

nopp:
	mov	ax,drvmap		! need to install mapper ?
	or	ax,ax
	jz	noimap			! no -> go on
	call	swap13
noimap:

#if REVERSE_DL
	call	revmap1
#else
	mov	dx,drive		! initialize DX (drive and head)
#endif
	mov	si,offset		! DS:SI and ES:SI point to the partition
	add	si,#PART_TABLE
#ifdef XXX
	mov	ax,ds
	mov	es,ax
	mov	si,#lilosig
	mov	bx,#cmd
	mov	dl,#0xfe
#else
	xor	ax,ax			! set DS and ES to zero
	mov	ds,ax
	mov	es,ax
#endif
#if 0
	mov	bp,#0			! might help some boot problems
	mov	ax,#0xaa55		! boot signature (just in case ...)
	jmpi	#BOOTSEG*16,0		! start boot sector
#else
	mov	bx,#BOOTSEG*16
	
	mov	ss,ax			! on all processors since the 186
	mov	sp,bx			! these instructions are locked
	
#ifdef LCF_COHERENT
	mov	(si),dl			! yes, put it in the partition table
#endif
	mov	bp,si			! BP==SI flags hard disk boot
	push	ax
	push	bx
	retf
#endif


#ifdef XXX
lilosig:.ascii	"LILO"
cmd:	.ascii	"98"
	.byte	0
#endif

#if defined(LCF_REWRITE_TABLE) || defined(DEBUG)

! Display a NUL-terminated string on the console

say:	lodsb			! get byte
	or	al,al		! NUL ?
	jz	aret		! yes -> done
	mov	ah,#14		! display, tty-style
	xor	bh,bh
	int	0x10
	jmp	say		! next one
aret:	ret			! done

failmsg:.ascii	"Rewrite error."
	.byte	13,10,0

#endif

swap13: seg	es		! allocate 1 kB
	dec	word ptr [0x413]
	int	0x12		! get start segment
	shl	ax,#6		! we are running on a 386
	cli			! disable interrupts
	xor	bx,bx		! zero a few registers
	mov	di,bx
	seg	es		! change offset
	xchg	bx,[4*0x13]	! 0x4c
	mov	old13of,bx
	mov	bx,ax		! change segment
	seg	es
	xchg	bx,[4*0x13+2]	! 0x4e
	mov	old13sg,bx
	mov	es,ax		! move drive swapper
	mov	si,#new13
	mov	cx,#new13end-new13
	rep
	movsb
	sti			! enable interrupts
	ret			! done

new13:	push	ax		! save AX (contains function code in AH)
	push	bp		! need BP to mess with stack
	mov	bp,sp
	jmp	new13a		! make space for signature

	.org	new13+6
	.ascii	"LILO"
	.word	STAGE_DRIVE_MAP
	.word	VERSION
	.word	drvmap-new13	! relative pointer to drive map

new13a:
	! Stack layout:
	!
	!   +8	INT flags
	!   +6	INT CS
	!   +4	INT IP
	!   +2	AX
	! BP+0 BP
	pushf			! push flags (to act like interrupt)
	push	si
	mov	si,#drvmap-new13
mapfl:	seg	cs		! get next entry
	mov	ax,(si) 	! do not depend on DIRECTION flag
	lea	si,(si+2)	! **
	or	ax,ax		! at end ?
	jz	nomap		! yes -> do not map
	cmp	dl,al		! match ?
	jne	mapfl		! no -> continue
	mov	dl,ah		! map drive
nomap:	pop	si		! restore SI
	mov	8(bp),ax	! overwrite old flags (to remember mapping)
	mov	ax,2(bp)	! restore AX
	mov	bp,(bp)		! restore BP
	.byte	0x9a		! CALL FAR
old13of:.word	0
old13sg:.word	0
	push	bp		! save BP again
	mov	bp,sp
	! New stack layout:
	!
	!   +10	mapping (was flags)
	!   +8	INT CS
	!   +6	INT IP
	!   +4	AX
	!   +2  obsolete BP
	! BP+0  BP
	xchg	ax,4(bp)	! save AX and get command
	pushf			! fix driver number, if necessary
	cmp	ah,#8 ! do not fix
	je	done13
	cmp	ah,#0x15 ! do not fix
	je	done13
	mov	ax,10(bp)	! no mapping ?
	or	ax,ax
	jz	done13
	mov	dl,al		! fix mapping
done13:	mov	ax,4(bp)	! restore AX
	pop	10(bp)		! restore flags
	pop	bp		! get BP
	add	sp,#4		! fix SP
	iret			! done

drvmap:	.blkw	DRVMAP_SIZE+1

new13end:

#if defined(LCF_REWRITE_TABLE)
prtmap:	.blkw	PRTMAP_SIZE*2+1	! only first word of last entry is read
#endif

theend:
