/*

Busted ass gui routines for karpski
Brian Costello

These routines were expelled to this location because they were
making the rest of my code look even worse.  Most of this comes
from Gtk example code that I cannibalized from the Gtk crew. So
beware -- there are no comments, but it's fairly straightforward
code if you know how to work with Gtk.

This code cries out for optimizations -- there are lots of windows
that are VERY similar to one another (logs ~ protocols ~ watchwindows).

I'll leave this for a later version @@

*/

#include <stdio.h>
#include <config.h>
#include <unistd.h>
#include <fcntl.h>
#include <gtk/gtk.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <arpa/inet.h>
#include <netinet/tcp.h>
#include <netinet/ip.h>
#include <pthread.h>
#ifdef TM_IN_SYS_TIME
 #include <sys/time.h>
#else
 #include <time.h>
#endif
#include "proto.h"
#include "connects.h"
#include "karpski.h"
#include "vendors.h"
#include "help.h"
#include "smashy.h"
#include "gtk_misc.h"
#include "scrupdate.h"

/* GLOBALS */

char strbuf[256];
GtkWidget *main_clist;
GtkWidget *statswindow=NULL;
GtkWidget *infowindow=NULL;
GtkWidget *label1, *label2, *label3, *label4, *nb_read_label, *ndgrams_label;
GtkWidget *label_info_title, *label_info_1, *label_info_2, *label_info_3, *label_info_4, *label_info_5, *label_info_6, *label_info_7, *label_info_8, *label_info_9, *label_info_10; 
GtkWidget *logwindow=NULL;	/* Log window */
GtkWidget *aboutwindow=NULL;	/* About window */
GtkWidget *mainwindow;		/* Main window */
GtkWidget *protowindow=NULL;	/* Protocols window */
GtkWidget *protoconfigwindow=NULL;	/* Protocol config window */
GtkWidget *prototree=NULL;	/* Protocol tree */
GtkWidget *logtext;		/* Log window */
GtkWidget *menubar;		/* Pulldown menu bar */
GtkAcceleratorTable *accel;	/* The accelerator keys */
int protocoltag=0;

extern t_arp_rec *first_arp_rec;
extern ether_protocols *first_ether_protocol;
extern int stablenet;
extern int can_smashy;
extern GtkWidget *connectwindow, *connectlist;
extern int connect_row, connect_col;
extern int logfd;
extern int started, selected_row;
extern t_arp_rec *selected_ar;
extern t_karpski_stats karpski_stats;
extern char *device;
extern int all_conns_selected;
extern int needssave;
extern pthread_mutex_t ArpRecMutex;

/* Now make the log window */   

static void 
switchlog(GtkWidget *widget)
{

   GtkWidget *hscrollbar, *vscrollbar, *table, *separator;
   GtkWidget *box1, *box2, *button;
   char fn[256];
   int numread;
   
   if (!logwindow)
   {
      logwindow= gtk_window_new(GTK_WINDOW_TOPLEVEL);
      gtk_widget_set_name(logwindow, "log");
      gtk_widget_set_usize(logwindow, 300,280);
      
      gtk_widget_set_uposition(logwindow, 1024-300-5, 0);

      gtk_window_set_policy (GTK_WINDOW(logwindow), TRUE, TRUE, FALSE);
         
      gtk_signal_connect (GTK_OBJECT (logwindow), "destroy",
                          GTK_SIGNAL_FUNC(gtk_widget_destroyed), &logwindow);
      gtk_window_set_title (GTK_WINDOW (logwindow), "log");
      gtk_container_border_width (GTK_CONTAINER (logwindow), 0);
      box1 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (logwindow), box1);
      gtk_widget_show (box1);
      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
      gtk_widget_show (box2);

      table = gtk_table_new (2, 2, FALSE);
      gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
      gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
      gtk_box_pack_start (GTK_BOX (box2), table, TRUE, TRUE, 0);
      gtk_widget_show (table);
      logtext = gtk_text_new (NULL, NULL);
      gtk_text_set_editable (GTK_TEXT (logtext), FALSE);
      gtk_table_attach (GTK_TABLE (table), logtext, 0, 1, 0, 1,
                        GTK_EXPAND | GTK_SHRINK | GTK_FILL,
                        GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
      gtk_widget_show (logtext);
      
      hscrollbar = gtk_hscrollbar_new (GTK_TEXT (logtext)->hadj);
      gtk_table_attach (GTK_TABLE (table), hscrollbar, 0, 1, 1, 2,
      GTK_EXPAND | GTK_FILL | GTK_SHRINK, GTK_FILL, 0, 0);
      gtk_widget_show (hscrollbar);
      vscrollbar = gtk_vscrollbar_new (GTK_TEXT (logtext)->vadj);
      gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
      GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
      gtk_widget_show (vscrollbar);
      gtk_widget_realize(logtext);
      sprintf(strbuf,"karpski %s\n", KARPSKI_VERSION);
      add_textitem(strbuf, strlen(strbuf), &logtext, "Log");

      close(logfd);
      
      sprintf(fn, "%slogfile.dat", KARPSKI_DATA_DIR);
      if ((logfd = open(fn, O_RDONLY)) < 0)
      {
         perror("Open logfile readonly");
         exit(1);
      }
      
      while ((numread=read(logfd, strbuf, sizeof(strbuf)))>0)
         add_textitem(strbuf, numread, &logtext, "Log");
      
      close(logfd);
      logfd = open(fn, O_WRONLY | O_CREAT | O_APPEND);
      
      separator = gtk_hseparator_new ();
      gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 0);
      gtk_widget_show (separator);
      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, TRUE, 0);
      gtk_widget_show (box2);
      button = gtk_button_new_with_label ("close");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                GTK_SIGNAL_FUNC(gtk_widget_destroy),
                                GTK_OBJECT (logwindow));
      gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
      gtk_widget_show (button);
   }
   if (!GTK_WIDGET_VISIBLE(logwindow))
      gtk_widget_show(logwindow);
   else
   {
      gtk_widget_destroy(logwindow);
      logtext = NULL;
   }
      
   return;
}

static gint protocol_update()
{
   if (!prototree)
      return FALSE;
   if (!protowindow)
      return FALSE;
      
   gtk_tree_remove_items(GTK_TREE(prototree), GTK_TREE(prototree)->children);
   dump_protolist(prototree, -1, 0);
   
   return TRUE;
}

/* Now make the protocols window */   

static void 
switchprotocols(GtkWidget *widget)
{

   GtkWidget *scrolled_win, *separator;
   GtkWidget *box1, *box2, *button;
   
   if (!protowindow)
   {
      protowindow= gtk_window_new(GTK_WINDOW_TOPLEVEL);
      gtk_widget_set_name(protowindow, "Protocols");
      gtk_widget_set_usize(protowindow, 260,400);
      
      gtk_widget_set_uposition(protowindow, 1280-572-5, 0);

      gtk_window_set_policy (GTK_WINDOW(protowindow), TRUE, TRUE, FALSE);
         
      gtk_signal_connect (GTK_OBJECT (protowindow), "destroy",
                          GTK_SIGNAL_FUNC(gtk_widget_destroyed), &protowindow);
      gtk_window_set_title (GTK_WINDOW (protowindow), "Protocols");
      gtk_container_border_width (GTK_CONTAINER (protowindow), 0);
      box1 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (protowindow), box1);
      gtk_widget_show (box1);
      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
      gtk_widget_show (box2);

      scrolled_win = gtk_scrolled_window_new(NULL, NULL);
      gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win),
                                     GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
      gtk_box_pack_start(GTK_BOX(box2), scrolled_win, TRUE, TRUE, 0);
      gtk_widget_show(scrolled_win);

      prototree = gtk_tree_new ();
      gtk_container_add(GTK_CONTAINER(scrolled_win), prototree);
      gtk_tree_set_selection_mode(GTK_TREE(prototree),
      GTK_SELECTION_BROWSE); gtk_tree_set_view_mode(GTK_TREE(prototree), 0);
      gtk_tree_set_view_lines(GTK_TREE(prototree), 1);
      gtk_widget_show(prototree);

      dump_protolist(prototree, -1, 0); 
      separator = gtk_hseparator_new ();
      gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 0);
      gtk_widget_show (separator);
      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, TRUE, 0);
      gtk_widget_show (box2);
      button = gtk_button_new_with_label ("close");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                GTK_SIGNAL_FUNC(gtk_widget_destroy),
                                GTK_OBJECT (protowindow));
      gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
      gtk_widget_show (button);
      protocoltag = gtk_timeout_add(1000*UPDATE_PROTO_FREQ, protocol_update, NULL);
   }
   if (!GTK_WIDGET_VISIBLE(protowindow))
      gtk_widget_show(protowindow);
   else
   {
      gtk_timeout_remove(protocoltag);
      gtk_widget_destroy(protowindow);
      prototree = NULL;
   }
      
   return;
}


/* Now make the stats window */   

static void 
switchstats(GtkWidget *widget)
{

   GtkWidget *box1, *box2, *button, *separator, *label;
   
   if (!statswindow)
   {
      statswindow= gtk_window_new(GTK_WINDOW_TOPLEVEL);
      gtk_widget_set_name(statswindow, "Statistics");
/*      gtk_widget_set_usize(statswindow, 300,280);
      
      gtk_widget_set_uposition(statswindow, 1024-300-5, 0); */

      gtk_window_set_policy (GTK_WINDOW(statswindow), TRUE, TRUE, FALSE);
         
      gtk_signal_connect (GTK_OBJECT (statswindow), "destroy",
                          GTK_SIGNAL_FUNC(gtk_widget_destroyed), &statswindow);
      gtk_window_set_title (GTK_WINDOW (statswindow), "Statistics");
      gtk_container_border_width (GTK_CONTAINER (statswindow), 0);
      box1 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (statswindow), box1);
      gtk_widget_show (box1);

      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
      gtk_widget_show (box2);
      
      label = gtk_label_new("K.ARP.SKI stats");
      gtk_box_pack_start(GTK_BOX(box2), label, TRUE, TRUE, 0);
      gtk_widget_show(label);

      separator = gtk_hseparator_new();
      gtk_box_pack_start(GTK_BOX(box2), separator, FALSE, TRUE, 0);
      gtk_widget_show(separator);

      sprintf(strbuf, "%-20s %10s", "Capturing device:", device);
      label = gtk_label_new(strbuf);
      gtk_box_pack_start(GTK_BOX(box2), label, TRUE, TRUE, 0);
      gtk_widget_show(label);
      
      sprintf(strbuf, "%-20s %10s", "Capturing data:", (started) ? "Yes" : "No");
      label2 = gtk_label_new(strbuf);
      gtk_misc_set_alignment(GTK_MISC(label2), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(box2), label2, TRUE, TRUE, 0);
      gtk_widget_show(label2);

      sprintf(strbuf, "%-20s %10d", "MACs captured:", karpski_stats.nhosts);
      label1 = gtk_label_new(strbuf);
      gtk_misc_set_alignment(GTK_MISC(label1), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(box2), label1, TRUE, TRUE, 0);
      gtk_widget_show(label1);

      sprintf(strbuf,"%-20s %10d", "Number warnings:", karpski_stats.nwarnings);
      label3 = gtk_label_new(strbuf);
      gtk_misc_set_alignment(GTK_MISC(label3), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(box2), label3, TRUE, TRUE, 0);
      gtk_widget_show(label3);

      sprintf(strbuf, "%-20s %10d", "Num. Connections:", karpski_stats.nconnections);
      label4 = gtk_label_new(strbuf);
      gtk_misc_set_alignment(GTK_MISC(label4), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(box2), label4, TRUE, TRUE, 0);
      gtk_widget_show(label4);

      sprintf(strbuf, "%-20s %10d", "Num. Datagrams:", karpski_stats.ndatagrams);
      ndgrams_label = gtk_label_new(strbuf);
      gtk_misc_set_alignment(GTK_MISC(ndgrams_label), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(box2), ndgrams_label, TRUE, TRUE, 0);
      gtk_widget_show(ndgrams_label);
      
      sprintf(strbuf, "%-20s %10ld", "Bytes read:", karpski_stats.nbytesread);
      nb_read_label = gtk_label_new(strbuf);
      gtk_misc_set_alignment(GTK_MISC(nb_read_label), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(box2), nb_read_label, TRUE, TRUE, 0);
      gtk_widget_show(nb_read_label);
      
      gtk_widget_show(box2);

      separator = gtk_hseparator_new();
      gtk_box_pack_start(GTK_BOX(box1), separator, FALSE, TRUE, 0);
      gtk_widget_show(separator);

      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
      gtk_widget_show (box2);
      button = gtk_button_new_with_label ("close");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                GTK_SIGNAL_FUNC(gtk_widget_destroy),
                                GTK_OBJECT (statswindow));
      gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
      gtk_widget_show (button);
   }
   if (!GTK_WIDGET_VISIBLE(statswindow))
      gtk_widget_show(statswindow);
   else
   {
      gtk_widget_destroy(statswindow);
      reset_overall_update();
   }
      
   return;
}

static void 
switchinfo(GtkWidget *widget)
{

   GtkWidget *box1, *box2, *button, *separator;
   
   if (!selected_ar)
      return;
      
   if (!infowindow)
   {
      infowindow= gtk_window_new(GTK_WINDOW_TOPLEVEL);
      gtk_widget_set_name(infowindow, "Info");
      /* Give default size */
      gtk_window_set_policy (GTK_WINDOW(infowindow), TRUE, TRUE, FALSE);
         
      gtk_signal_connect (GTK_OBJECT (infowindow), "destroy",
                          GTK_SIGNAL_FUNC(gtk_widget_destroyed), &infowindow);
      gtk_window_set_title (GTK_WINDOW (infowindow), "Info");
      gtk_container_border_width (GTK_CONTAINER (infowindow), 0);
      box1 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (infowindow), box1);
      gtk_widget_show (box1);

      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
      gtk_widget_show (box2);
      
      sprintf(strbuf, "Info about %s", selected_ar->hw_addr);
      label_info_title = gtk_label_new(strbuf);
      gtk_box_pack_start(GTK_BOX(box2), label_info_title, TRUE, TRUE, 0);
      gtk_widget_show(label_info_title);

      separator = gtk_hseparator_new();
      gtk_box_pack_start(GTK_BOX(box2), separator, FALSE, TRUE, 0);
      gtk_widget_show(separator);
      
      sprintf(strbuf, "%-20s %20s", "HW Addr:", selected_ar->hw_addr);
      label_info_1 = gtk_label_new(strbuf);
      gtk_misc_set_alignment(GTK_MISC(label_info_1), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(box2), label_info_1, TRUE, TRUE, 0);
      gtk_widget_show(label_info_1);

      if (selected_ar->machine_addr)
         sprintf(strbuf, "%-20s %20s", "Machine addr:", selected_ar->machine_addr);
      else
         sprintf(strbuf, "%-20s %20s", "Machine addr:", "Not available");
      label_info_2 = gtk_label_new(strbuf);
      gtk_misc_set_alignment(GTK_MISC(label_info_2), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(box2), label_info_2, TRUE, TRUE, 0);
      gtk_widget_show(label_info_2);


      if (selected_ar->machine_name[0])
         sprintf(strbuf, "%-20s %20s", "Machine name:", selected_ar->machine_name);
      else
         sprintf(strbuf, "%-20s %20s", "Machine name:", "N/A");
      label_info_3 = gtk_label_new(strbuf);
      gtk_misc_set_alignment(GTK_MISC(label_info_3), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(box2), label_info_3, TRUE, TRUE, 0);
      gtk_widget_show(label_info_3);


      sprintf(strbuf, "%-20s %20s", "Alias:", selected_ar->alias);
      label_info_4 = gtk_label_new(strbuf);
      gtk_misc_set_alignment(GTK_MISC(label_info_4), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(box2), label_info_4, TRUE, TRUE, 0);
      gtk_widget_show(label_info_4);

      sprintf(strbuf, "%-20s %20s", "Watching:", (selected_ar->watching) ? "Yes" : "No");
      label_info_5 = gtk_label_new(strbuf);
      gtk_misc_set_alignment(GTK_MISC(label_info_5), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(box2), label_info_5, TRUE, TRUE, 0);
      gtk_widget_show(label_info_5);

      sprintf(strbuf, "%-20s %20s", "Possible role:", selected_ar->role);
      label_info_6 = gtk_label_new(strbuf);
      gtk_misc_set_alignment(GTK_MISC(label_info_6), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(box2), label_info_6, TRUE, TRUE, 0);
      gtk_widget_show(label_info_6);


      sprintf(strbuf, "%-20s %20s", "NIC vendor:", selected_ar->vend_str);
      label_info_7 = gtk_label_new(strbuf);
      gtk_misc_set_alignment(GTK_MISC(label_info_7), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(box2), label_info_7, TRUE, TRUE, 0);
      gtk_widget_show(label_info_7);


      sprintf(strbuf, "%-20s %20d", "Num. connections:", selected_ar->nconns);
      label_info_8 = gtk_label_new(strbuf);
      gtk_misc_set_alignment(GTK_MISC(label_info_8), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(box2), label_info_8, TRUE, TRUE, 0);
      gtk_widget_show(label_info_8);


      sprintf(strbuf, "%-20s %20d", "Num. datagrams:", selected_ar->ndgrams);
      label_info_9 = gtk_label_new(strbuf);
      gtk_misc_set_alignment(GTK_MISC(label_info_9), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(box2), label_info_9, TRUE, TRUE, 0);
      gtk_widget_show(label_info_9);


      sprintf(strbuf, "%-20s %20ld", "Num. bytes:", selected_ar->nbytes);
      label_info_10 = gtk_label_new(strbuf);
      gtk_misc_set_alignment(GTK_MISC(label_info_10), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(box2), label_info_10, TRUE, TRUE, 0);
      gtk_widget_show(label_info_10);

      separator = gtk_hseparator_new();
      gtk_box_pack_start(GTK_BOX(box1), separator, FALSE, TRUE, 0);
      gtk_widget_show(separator);

      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
      gtk_widget_show (box2);
      button = gtk_button_new_with_label ("close");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                GTK_SIGNAL_FUNC(gtk_widget_destroy),
                                GTK_OBJECT (infowindow));
      gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
      gtk_widget_show (button);
   }
   if (!GTK_WIDGET_VISIBLE(infowindow))
      gtk_widget_show(infowindow);
   else
   {
      gtk_widget_destroy(infowindow);
      reset_info_update();
   }
      
   return;
}


void switchabout()
{

   GtkWidget *box1;
   GtkWidget *button;
   GtkWidget *wpixmap;
   GtkStyle *style;
   GdkPixmap *pixmap;
   GdkBitmap *mask;
   char fn[256];
   
   if (!aboutwindow)
   {
      aboutwindow= gtk_window_new(GTK_WINDOW_TOPLEVEL);
      gtk_widget_set_name(aboutwindow, "About");
      gtk_widget_set_uposition(aboutwindow, 377, 189);  

      gtk_window_set_policy (GTK_WINDOW(aboutwindow), TRUE, TRUE, FALSE);
         
      gtk_signal_connect (GTK_OBJECT (aboutwindow), "destroy",
                          GTK_SIGNAL_FUNC(gtk_widget_destroyed), &aboutwindow);
      gtk_window_set_title (GTK_WINDOW (aboutwindow), "About");
      gtk_container_border_width (GTK_CONTAINER (aboutwindow), 0);

      box1 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (aboutwindow), box1);
      gtk_widget_show (box1);

      button = gtk_button_new();
      gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(switchabout), NULL);
      gtk_box_pack_start(GTK_BOX(box1), button, TRUE, TRUE, 0);
      gtk_widget_show(button);
      
      style = gtk_widget_get_style(box1);
      sprintf(fn, "%ssplash_karpski.xpm", KARPSKI_PIXMAP_DIR);
      pixmap = gdk_pixmap_create_from_xpm(mainwindow->window, &mask, &style->bg[GTK_STATE_NORMAL], fn);
      wpixmap = gtk_pixmap_new(pixmap, mask);
      gtk_container_add(GTK_CONTAINER(button), wpixmap);
      gtk_widget_show(wpixmap);

   }
   if (!GTK_WIDGET_VISIBLE(aboutwindow))
      gtk_widget_show(aboutwindow);
   else
      gtk_widget_destroy(aboutwindow);
      
   return;
}

void printinfo()
{
   char strbuf[256];
   
   if (!infowindow)
      return;

   sprintf(strbuf, "Info about %s", selected_ar->hw_addr);
   gtk_label_set(GTK_LABEL(label_info_title), strbuf);

   sprintf(strbuf, "%-20s %20s", "HW Addr:", selected_ar->hw_addr);
   gtk_label_set(GTK_LABEL(label_info_1), strbuf);

   if ((selected_ar->machine_addr) && (selected_ar->machine_addr[0]))
      sprintf(strbuf, "%-20s %20s", "Machine addr:", selected_ar->machine_addr);
   else
      sprintf(strbuf, "%-20s %20s", "Machine addr:", "Not available");

   gtk_label_set(GTK_LABEL(label_info_2), strbuf);

   sprintf(strbuf, "%-20s %20s", "Machine name:", selected_ar->machine_name);
   gtk_label_set(GTK_LABEL(label_info_3), strbuf);

   sprintf(strbuf, "%-20s %20s", "Alias:", selected_ar->alias);
   gtk_label_set(GTK_LABEL(label_info_4), strbuf);

   sprintf(strbuf, "%-20s %20s", "Watching:", (selected_ar->watching) ? "Yes" : "No");
   gtk_label_set(GTK_LABEL(label_info_5), strbuf);

   sprintf(strbuf, "%-20s %20s", "Possible role:", selected_ar->role);
   gtk_label_set(GTK_LABEL(label_info_6), strbuf);

   sprintf(strbuf, "%-20s %20s", "NIC vendor:", selected_ar->vend_str);
   gtk_label_set(GTK_LABEL(label_info_7), strbuf);

   sprintf(strbuf, "%-20s %20d", "Num. connections:", selected_ar->nconns);
   gtk_label_set(GTK_LABEL(label_info_8), strbuf);

   sprintf(strbuf, "%-20s %20d", "Num. datagrams:", selected_ar->ndgrams);
   gtk_label_set(GTK_LABEL(label_info_9), strbuf);

   sprintf(strbuf, "%-20s %20ld", "Num. bytes:", selected_ar->nbytes);
   gtk_label_set(GTK_LABEL(label_info_10), strbuf);
   
   return;
}

void select_clist(GtkWidget *widget, gint row, gint column, GdkEventButton *bevent)
{
   char *hw_addr;
   char *machine_addr;
   char maddr2[64];
   
   selected_row = row;
   gtk_clist_get_text(GTK_CLIST(widget), row, 1, &hw_addr);
   gtk_clist_get_text(GTK_CLIST(widget), row, 2, &machine_addr);
   strcpy(maddr2, machine_addr);
   if (!strcasecmp(maddr2, "not avail."))
      maddr2[0] = '\0';
   selected_ar = find_arp_rec(hw_addr, maddr2, NULL, NULL, NULL);
   
   if (!selected_ar)
   {
      fprintf(stderr,"ERROR can't find item %s / %s\n", hw_addr, machine_addr);
      exit(1);
   }

   printinfo();
   if ((!connectwindow) || (!connectlist) || (all_conns_selected))
      return;
   
   clear_copylist();
   
   gtk_clist_clear (GTK_CLIST(connectlist));

   if (selected_ar)
      display_connections(selected_ar->first_connect, 0);
   else
      fprintf(stderr,"Can't find hw_addr %s!!\n", hw_addr);
}

void switch_watch()
{
   char *watching;
   char *srcstr, *dststr, *tmpstr;
   char *seladdrstr;
   t_connect_rec *last_connect, *this_connect;
   time_t timet;
   struct in_addr src, dst;
   int sport, dport;
   GtkWidget *table, *hscrollbar, *vscrollbar, *box1, *box2, *separator, *button;
   
   if (connect_row < 0)
      return;
   gtk_clist_get_text(GTK_CLIST(connectlist), connect_row, 0, &watching);
   gtk_clist_get_text(GTK_CLIST(connectlist), connect_row, 1, &srcstr);
   gtk_clist_get_text(GTK_CLIST(connectlist), connect_row, 2, &tmpstr);
   sport = atoi(tmpstr);
   gtk_clist_get_text(GTK_CLIST(connectlist), connect_row, 3, &dststr);
   gtk_clist_get_text(GTK_CLIST(connectlist), connect_row, 4, &tmpstr);
   dport = atoi(tmpstr);
   
   if (connect_col == 3)
      seladdrstr = dststr;
   else
      seladdrstr = srcstr;
      
   src.s_addr = inet_addr(srcstr);
   dst.s_addr = inet_addr(dststr);

   if (all_conns_selected)
      this_connect = find_connection(first_arp_rec, &last_connect, src, sport, dst, dport, 0, NULL, seladdrstr);
   else
      this_connect = find_connection(selected_ar, &last_connect, src, sport, dst, dport, 1, NULL, NULL);
   
   if (!this_connect)
   {
      fprintf(stderr,"Error: Couldn't find connection %s->%s!!\n", srcstr, dststr);
      return;
   }

   if (this_connect->watchwindow)
   {
      gtk_widget_destroy(this_connect->watchwindow);
      this_connect->watchwindow = NULL;
      gtk_clist_set_text(GTK_CLIST(connectlist), connect_row, 0, "No");
   }
   else
   {
      this_connect->watchwindow= gtk_window_new(GTK_WINDOW_TOPLEVEL);
      gtk_widget_set_name(this_connect->watchwindow, "Connections");
      gtk_widget_set_usize(this_connect->watchwindow, 380,280);
      
      gtk_widget_set_uposition(this_connect->watchwindow, 619, 300);

      gtk_window_set_policy (GTK_WINDOW(this_connect->watchwindow), TRUE, TRUE, FALSE);
         
      gtk_signal_connect (GTK_OBJECT (this_connect->watchwindow), "destroy",
                          GTK_SIGNAL_FUNC(gtk_widget_destroyed), &this_connect->watchwindow);
      gtk_window_set_title (GTK_WINDOW (this_connect->watchwindow), "Watch");
      gtk_container_border_width (GTK_CONTAINER (this_connect->watchwindow), 0);

      box1 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (this_connect->watchwindow), box1);
      gtk_widget_show (box1);
      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
      gtk_widget_show (box2);
      
      table = gtk_table_new (2, 2, FALSE);
      gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
      gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
      gtk_box_pack_start (GTK_BOX (box2), table, TRUE, TRUE, 0);
      gtk_widget_show (table);
      this_connect->watchtextbox = gtk_text_new (NULL, NULL);
      gtk_text_set_editable (GTK_TEXT (this_connect->watchtextbox), FALSE);
      gtk_table_attach (GTK_TABLE (table), this_connect->watchtextbox, 0, 1, 0, 1,
                        GTK_EXPAND | GTK_SHRINK | GTK_FILL,
                        GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
      gtk_widget_show (this_connect->watchtextbox);
      
      hscrollbar = gtk_hscrollbar_new (GTK_TEXT (this_connect->watchtextbox)->hadj);
      gtk_table_attach (GTK_TABLE (table), hscrollbar, 0, 1, 1, 2,
      GTK_EXPAND | GTK_FILL | GTK_SHRINK, GTK_FILL, 0, 0);
      gtk_widget_show (hscrollbar);
      vscrollbar = gtk_vscrollbar_new (GTK_TEXT (this_connect->watchtextbox)->vadj);
      gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
      GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
      gtk_widget_show (vscrollbar);
      gtk_widget_realize(this_connect->watchtextbox);
      timet = time(NULL);
      sprintf(strbuf, "Capture started: %s...\n", ctime(&timet));
      add_textitem(strbuf, strlen(strbuf), &this_connect->watchtextbox, "ConWat");
      separator = gtk_hseparator_new ();
      gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 0);
      gtk_widget_show (separator);
      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, TRUE, 0);
      gtk_widget_show (box2);

      button = gtk_button_new_with_label ("close");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
      				GTK_SIGNAL_FUNC(switch_watch),
      				NULL);
      gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
      gtk_widget_show (button);
      gtk_widget_show (this_connect->watchwindow);
      gtk_clist_set_text(GTK_CLIST(connectlist), connect_row, 0, "Yes");
   }
}


void close_watchall(t_arp_rec *selected_ar)
{
   if (selected_ar->row<0)
      return;
   
/*   gtk_clist_set_text(GTK_CLIST(main_clist), selected_ar->row, 0, "No"); */
   mutex_enter(ArpRecMutex);
   selected_ar->needs_update=2;
   mutex_exit(ArpRecMutex);
   if (GTK_WIDGET_VISIBLE(selected_ar->watchwindow))
      gtk_widget_destroy(selected_ar->watchwindow);
   selected_ar->watchwindow = NULL;
   selected_ar->watchtextbox = NULL;

   return;   
}

void switchwatchall()
{
   GtkWidget *table, *hscrollbar, *vscrollbar, *box1, *box2, *separator, *button;
   time_t timet;

   if ((!selected_ar) || (selected_row < 0))
      return;
   selected_ar->watching = (!selected_ar->watching);
   gtk_clist_set_text(GTK_CLIST(main_clist), selected_row, 0, (selected_ar->watching) ? "Yes" : "No");

   if ((selected_ar->watchwindow) && (GTK_WIDGET_VISIBLE(selected_ar->watchwindow)))
   {
      gtk_widget_destroy(selected_ar->watchwindow);
      selected_ar->watchwindow = NULL;
      gtk_clist_set_text(GTK_CLIST(main_clist), selected_row, 0, "No");
   }
   else
   {
      selected_ar->watchwindow= gtk_window_new(GTK_WINDOW_TOPLEVEL);
      sprintf(strbuf, "Watch %s", selected_ar->machine_addr);
      gtk_widget_set_name(selected_ar->watchwindow, strbuf);
      gtk_widget_set_usize(selected_ar->watchwindow, 380,280);
      gtk_widget_set_uposition(selected_ar->watchwindow, 619, 300);
      gtk_window_set_policy (GTK_WINDOW(selected_ar->watchwindow), TRUE, TRUE, FALSE);
         
      gtk_signal_connect (GTK_OBJECT (selected_ar->watchwindow), "destroy",
                          GTK_SIGNAL_FUNC(gtk_widget_destroyed), &selected_ar->watchwindow);
      gtk_window_set_title (GTK_WINDOW (selected_ar->watchwindow), strbuf);
      gtk_container_border_width (GTK_CONTAINER (selected_ar->watchwindow), 0);

      box1 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (selected_ar->watchwindow), box1);
      gtk_widget_show (box1);
      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
      gtk_widget_show (box2);
      
      table = gtk_table_new (2, 2, FALSE);
      gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
      gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
      gtk_box_pack_start (GTK_BOX (box2), table, TRUE, TRUE, 0);
      gtk_widget_show (table);
      selected_ar->watchtextbox = gtk_text_new (NULL, NULL);
      gtk_text_set_editable (GTK_TEXT (selected_ar->watchtextbox), FALSE);
      gtk_table_attach (GTK_TABLE (table), selected_ar->watchtextbox, 0, 1, 0, 1,
                        GTK_EXPAND | GTK_SHRINK | GTK_FILL,
                        GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
      gtk_widget_show (selected_ar->watchtextbox);
      
      hscrollbar = gtk_hscrollbar_new (GTK_TEXT (selected_ar->watchtextbox)->hadj);
      gtk_table_attach (GTK_TABLE (table), hscrollbar, 0, 1, 1, 2,
      GTK_EXPAND | GTK_FILL | GTK_SHRINK, GTK_FILL, 0, 0);
      gtk_widget_show (hscrollbar);
      vscrollbar = gtk_vscrollbar_new (GTK_TEXT (selected_ar->watchtextbox)->vadj);
      gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
      GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
      gtk_widget_show (vscrollbar);
      gtk_widget_realize(selected_ar->watchtextbox);
      timet = time(NULL);
      sprintf(strbuf, "Capture started: %s...\n", ctime(&timet));
      add_textitem(strbuf, strlen(strbuf), &selected_ar->watchtextbox, "ArWat");
      separator = gtk_hseparator_new ();
      gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 0);
      gtk_widget_show (separator);
      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, TRUE, 0);
      gtk_widget_show (box2);

      button = gtk_button_new_with_label ("close");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                GTK_SIGNAL_FUNC(close_watchall),
                                (GtkObject *)selected_ar);
      gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
      gtk_widget_show (button);
      gtk_widget_show (selected_ar->watchwindow);
      gtk_clist_set_text(GTK_CLIST(main_clist), selected_row, 0, "Yes");
   }

   return;
}


void getquotstr(char *line, int strnum, char buf[])
{
   int bufpos = 0;
   int linepos= 0;
   int linelen;
   int nquotes;
   int found = 0;
   
   nquotes = strnum * 2 + 1;
   
   linelen = strlen(line);
   
   for (linepos = 0; ((linepos < linelen) && (nquotes)) ; linepos ++)
   {
      if (line[linepos] == '\'')
      {
         nquotes--;
         if (!nquotes)
            found = 1;
      }
      
   }
   
   if (!found)
   {
      fprintf(stderr,"There are not %d strings in line %s.\n", strnum, line);
      return;
   }
   
   while ((linepos < linelen) && (line[linepos] != '\''))
   {
      buf[bufpos++] = line[linepos];
      linepos++;
   }
      
   buf[bufpos] = '\0';
   return;
}

void clearlist()
{
   t_arp_rec *t_arp, *next_arp;
   for (t_arp = first_arp_rec; t_arp; t_arp = next_arp)
   {
      next_arp = t_arp->next;
      if (t_arp->watchtextbox)
         gtk_widget_destroy(t_arp->watchtextbox);
      if (t_arp->watchwindow)
         gtk_widget_destroy(t_arp->watchwindow);
      /* Free conections, kill their watches @@@ */
      free(t_arp);
   }
   
   first_arp_rec = NULL;
   gtk_clist_clear(GTK_CLIST(main_clist));
   stablenet = 0;
   bzero(&karpski_stats, sizeof(karpski_stats));
}

void open_selection_ok(GtkWidget *w, GtkFileSelection *fs)
{
   char fn[BUFSIZ];
   char *vend;
   FILE *infile;
   t_arp_rec *new_arp;
   char line[BUFSIZ];
   char t1[64], t2[64], t3[64], t4[64], t5[64], t6[8];
   
   strcpy(fn, gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
   /* fprintf(stderr,"Opening %s\n", fn); */
   gtk_widget_destroy(GTK_WIDGET(fs));
   
   if (!(infile = fopen(fn, "r")))
   {
      perror("Can't open file for reading: ");
      return;
   }

   clearlist();
   
   while (fgets(line, BUFSIZ, infile))
   {
      getquotstr(line, 0, t1);
      getquotstr(line, 1, t2);
      getquotstr(line, 2, t3);
      getquotstr(line, 3, t4);
      getquotstr(line, 4, t5);
      getquotstr(line, 5, t6);
      new_arp = MALLOC(sizeof(t_arp_rec), "new arp rec - gui.c");
      bzero(new_arp, sizeof(t_arp_rec));
      strcpy(new_arp->hw_addr, t1);
      strcpy(new_arp->machine_addr, t2);
      strcpy(new_arp->machine_name, t3);
      strcpy(new_arp->alias, t4);
      strcpy(new_arp->role, t5);
      vend = find_vendstr(new_arp->hw_addr);
      if (vend)
         strcpy(new_arp->vend_str, vend);
      else
         strcpy(new_arp->vend_str, "Unknown vendor");
      
      strcpy(new_arp->methodstr, t6);

      if (first_arp_rec == NULL)
         selected_ar = new_arp;
         
      new_arp->next = first_arp_rec;
      set_main_list_update(new_arp);
      first_arp_rec = new_arp;
   }
   stablenet = 1;
   fclose(infile);
}

void save_selection_ok(GtkWidget *w, GtkFileSelection *fs)
{
   char fn[BUFSIZ];
   t_arp_rec *t_arp;
   FILE *outfile;
   
   strcpy(fn, gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
   gtk_widget_destroy(GTK_WIDGET(fs));
   
   if (!(outfile = fopen(fn,"w")))
   {
      perror("Can't open file for writing: ");
      return;
   }

   t_arp = first_arp_rec;
   while (t_arp)
   {
      fprintf(outfile,"'%s' '%s' '%s' '%s' '%s' '%s'\n",
         t_arp->hw_addr,
         t_arp->machine_addr,
         t_arp->machine_name,
         t_arp->alias,
         t_arp->role,
         t_arp->methodstr);
      t_arp = t_arp->next;
   }
   stablenet = 1;
   needssave = 0;
   fclose(outfile);
}

int activate_protocol_by_name(char *protoname)
{
   ether_protocols *t_ep;
   protocols *t_pr;
   int done=0;

   for (t_ep=first_ether_protocol; ((t_ep) && (!done)); t_ep=t_ep->next)
   {
      if (!strcasecmp(t_ep->ether_type_name, protoname))
      {
/*         printf("Activated %s\n", t_ep->ether_type_name); */
         t_ep->active=done=1;
      }
      else
         if (t_ep->first_protocol)
            for (t_pr=t_ep->first_protocol; ((t_pr) && (!done)); t_pr=t_pr->next)
               if (!strcasecmp(t_pr->protocol_short_name, protoname))
                  t_pr->active=done=1;
   }
   return(done);
}


/*

This function is very very gtk dependant.  It looks at structures that are
probably not meant to be dereferenced like this.

*/

void selection_changed(GtkTree *tree)
{
   ether_protocols *t_ep;
   protocols *t_pr;
   GList *selected_list, *cur_pos;
   GtkContainer *container;
   GtkTreeItem *ti;
   GtkItem *item;
   GtkBin *bin;
   GtkLabel *label;
   int eplook;
   
   int nb_selected;
   
   selected_list = GTK_TREE_SELECTION(tree);
   nb_selected = g_list_length(selected_list);

/* First zero the actives */
   
   for (t_ep=first_ether_protocol; t_ep; t_ep=t_ep->next)
   {
      t_ep->active=0;
      for (t_pr=t_ep->first_protocol; t_pr; t_pr=t_pr->next)
         t_pr->active=0;
   }
   
   t_ep = first_ether_protocol;
   t_pr = NULL;
   eplook = 1;
   for (cur_pos = g_list_first(selected_list); cur_pos; cur_pos = g_list_next(cur_pos))
   {
      container = GTK_CONTAINER(cur_pos->data);
      ti = GTK_TREE_ITEM(&container->widget);
      item = GTK_ITEM(&ti->item);
      bin = GTK_BIN(&item->bin);
      if (bin->child)
      {
         label=GTK_LABEL(bin->child);
/*         printf("Activating %s %c\n", label->label, (cur_pos->next) ? 'y': 'n'); */
         if (!activate_protocol_by_name(label->label))
            printf("Can't find protocol %s!\n", label->label);
      }
   }

}

void protoconfig()
{
   GtkWidget *scrolled_win, *separator;
   GtkWidget *box1, *box2, *button;
   GtkWidget *protoconfigtree;
   protocols *t_pr;
   ether_protocols *t_ep;
   GtkWidget *root_item;
   int selcnt = 0;
   
   if (!protoconfigwindow)
   {
      protoconfigwindow= gtk_window_new(GTK_WINDOW_TOPLEVEL);
      gtk_widget_set_name(protoconfigwindow, "Protocol configuration");
      gtk_widget_set_usize(protoconfigwindow, 260,400);
      
      gtk_widget_set_uposition(protoconfigwindow, 1280-572-5, 0);

      gtk_window_set_policy (GTK_WINDOW(protoconfigwindow), TRUE, TRUE, FALSE);
         
      gtk_signal_connect (GTK_OBJECT (protoconfigwindow), "destroy",
                          GTK_SIGNAL_FUNC(gtk_widget_destroyed), &protoconfigwindow);
      gtk_window_set_title (GTK_WINDOW (protoconfigwindow), "Protocols");
      gtk_container_border_width (GTK_CONTAINER (protoconfigwindow), 0);
      box1 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (protoconfigwindow), box1);
      gtk_widget_show (box1);
      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
      gtk_widget_show (box2);

      scrolled_win = gtk_scrolled_window_new(NULL, NULL);
      gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win),
                                     GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
      gtk_box_pack_start(GTK_BOX(box2), scrolled_win, TRUE, TRUE, 0);
      gtk_widget_show(scrolled_win);

      protoconfigtree = gtk_tree_new ();
      gtk_container_add(GTK_CONTAINER(scrolled_win), protoconfigtree);
      gtk_tree_set_selection_mode(GTK_TREE(protoconfigtree), GTK_SELECTION_MULTIPLE);
      gtk_tree_set_view_mode(GTK_TREE(protoconfigtree), 0);
      gtk_tree_set_view_lines(GTK_TREE(protoconfigtree), 1);
      GTK_TREE(protoconfigtree)->root_tree = GTK_TREE(protoconfigtree);
      gtk_widget_show(protoconfigtree);

      separator = gtk_hseparator_new ();
      gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 0);
      gtk_widget_show (separator);
      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, TRUE, 0);
      gtk_widget_show (box2);
      button = gtk_button_new_with_label ("close");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                GTK_SIGNAL_FUNC(gtk_widget_destroy),
                                GTK_OBJECT (protoconfigwindow));
      gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
      gtk_widget_show (button);
      for (t_ep=first_ether_protocol; t_ep; t_ep = t_ep->next)
      {
         GtkWidget *pr_item, *pr_tree;
         
         root_item = gtk_tree_item_new_with_label(t_ep->ether_type_name);
         gtk_tree_append(GTK_TREE(protoconfigtree), root_item);
         gtk_widget_show(root_item);
         if (t_ep->active)
            gtk_tree_select_item(GTK_TREE(protoconfigtree), selcnt++);
         if (t_ep->first_protocol)
         {
            int cnt;
            
            cnt=0;
            pr_tree = gtk_tree_new();
            gtk_widget_show(pr_tree);
            gtk_tree_item_set_subtree(GTK_TREE_ITEM(root_item), pr_tree);
            GTK_TREE(pr_tree)->root_tree = GTK_TREE(protoconfigtree);
            gtk_signal_emit_by_name(GTK_OBJECT(root_item), "expand");
            for (t_pr=t_ep->first_protocol; t_pr; t_pr=t_pr->next)
            {
               pr_item = gtk_tree_item_new_with_label(t_pr->protocol_short_name);
               gtk_tree_append(GTK_TREE(pr_tree), pr_item);
               if ((t_pr->active) && (t_ep->active))
                  gtk_tree_select_item(GTK_TREE(pr_tree), cnt++);
               gtk_widget_show(pr_item);
            }
         }
      }
      gtk_signal_connect(GTK_OBJECT(protoconfigtree), "selection_changed",
                        (GtkSignalFunc)selection_changed, NULL);
      selection_changed(GTK_TREE(protoconfigtree));
   }
   if (!GTK_WIDGET_VISIBLE(protoconfigwindow))
      gtk_widget_show(protoconfigwindow);
   else
   {
      gtk_timeout_remove(protocoltag);
      gtk_widget_destroy(protoconfigwindow);
   }
      
   return;
}

void openlist()
{
   static GtkWidget *window = NULL;
   
   if (!window)
   {
      window = gtk_file_selection_new("Get list dialog");
      gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(window));
      gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
      
      gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window);
      gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window)->ok_button),
                         "clicked", GTK_SIGNAL_FUNC(open_selection_ok),
                         window);
      gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(window)->cancel_button),
                         "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
                         GTK_OBJECT(window));
   }
   if (!GTK_WIDGET_VISIBLE(window))
      gtk_widget_show(window);
   else
      gtk_widget_destroy(window);
}     

void savelist()
{
   static GtkWidget *window = NULL;
   
   if (!window)
   {
      window = gtk_file_selection_new("Save list dialog");
      gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
      
      gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window);
      gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window)->ok_button),
                         "clicked", GTK_SIGNAL_FUNC(save_selection_ok),
                         window);
      gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(window)->cancel_button),
                         "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
                         GTK_OBJECT(window));
   }
   if (!GTK_WIDGET_VISIBLE(window))
      gtk_widget_show(window);
}

static GtkWidget *create_filemenu(GtkAcceleratorTable *accel)
{
   GtkWidget *menu;
   GtkWidget *menuitem;
   
   menu = gtk_menu_new();
   gtk_menu_set_accelerator_table(GTK_MENU(menu), accel);
   menuitem = gtk_menu_item_new_with_label("Open list   Ctl-O");
   gtk_menu_append(GTK_MENU(menu), menuitem);
   gtk_accelerator_table_install(accel, GTK_OBJECT(menuitem), "activate", 'O', GDK_CONTROL_MASK);
   gtk_widget_show(menuitem);
   gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
                             GTK_SIGNAL_FUNC(openlist), NULL);
   
   menuitem = gtk_menu_item_new_with_label("Save list   Ctl-S");
   gtk_menu_append(GTK_MENU(menu), menuitem);
   gtk_widget_show(menuitem);
   gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
                             GTK_SIGNAL_FUNC(savelist), NULL);

   menuitem = gtk_menu_item_new();
   gtk_menu_append(GTK_MENU(menu), menuitem);
   gtk_accelerator_table_install(accel, GTK_OBJECT(menuitem), "activate", 'S', GDK_CONTROL_MASK);
   gtk_widget_show(menuitem);
   
   menuitem = gtk_menu_item_new_with_label("Clear list");
   gtk_menu_append(GTK_MENU(menu), menuitem);
   gtk_widget_show(menuitem);
   gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
                             GTK_SIGNAL_FUNC(clearlist), NULL);

   menuitem = gtk_menu_item_new();
   gtk_menu_append(GTK_MENU(menu), menuitem);
   gtk_widget_show(menuitem);
   menuitem = gtk_menu_item_new_with_label("Exit        Ctl-Q");
   gtk_menu_append(GTK_MENU(menu), menuitem);
   gtk_widget_show(menuitem);
   
   gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
                             GTK_SIGNAL_FUNC(karpski_quit), NULL);
   return menu;
}

static GtkWidget *create_configmenu(GtkAcceleratorTable *accel)
{
   GtkWidget *menu;
   GtkWidget *menuitem;
   
   menu = gtk_menu_new();
   gtk_menu_set_accelerator_table(GTK_MENU(menu), accel);

   menuitem = gtk_menu_item_new_with_label("Configure protocols");
   gtk_menu_append(GTK_MENU(menu), menuitem);
   gtk_accelerator_table_install(accel, GTK_OBJECT(menuitem), "activate", 'O', GDK_CONTROL_MASK);
   gtk_widget_show(menuitem);
   gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
                             GTK_SIGNAL_FUNC(protoconfig), NULL);


   return menu;
}

static GtkWidget *create_helpmenu(GtkAcceleratorTable *accel)
{
   GtkWidget *menu;
   GtkWidget *menuitem;
   
   menu = gtk_menu_new();
   gtk_menu_set_accelerator_table(GTK_MENU(menu), accel);
   menuitem = gtk_menu_item_new_with_label("About");
   gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
                             GTK_SIGNAL_FUNC(switchabout), NULL);
   gtk_menu_append(GTK_MENU(menu), menuitem);
   gtk_widget_show(menuitem);
   menuitem = gtk_menu_item_new_with_label("Help");
   gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
                             GTK_SIGNAL_FUNC(switchhelp), NULL);
   gtk_menu_append(GTK_MENU(menu), menuitem);
   gtk_widget_show(menuitem);
   return menu;
}

void create_main_window()
{
   GtkWidget *box1, *box2;
   GtkWidget *button;
   GtkWidget *separator;
   GtkWidget *menuitem;
   GtkTooltips *tooltips;
   
   static char *titles[NUM_MAIN_CLIST_COLS] =
   {
      "Watching",
      "MAC Address",
      "IP Address",
      "Hostname",
      "NIC vendor",
      "Acq. Method"
   };
   
   mainwindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   
   gtk_signal_connect(GTK_OBJECT(mainwindow), "destroy", 
                      GTK_SIGNAL_FUNC(karpski_quit),
                      NULL);
   gtk_signal_connect(GTK_OBJECT(mainwindow), "delete_event", 
                      GTK_SIGNAL_FUNC(gtk_false),
                      NULL);
   
   gtk_widget_set_usize(mainwindow, 900, 580);
   gtk_widget_realize(mainwindow);
   gtk_widget_set_uposition(mainwindow,0,0);
   sprintf(strbuf, "karpski %s", KARPSKI_VERSION);
   gtk_window_set_title(GTK_WINDOW(mainwindow), strbuf);
   gtk_container_border_width(GTK_CONTAINER(mainwindow), 0);
   
   accel = gtk_accelerator_table_new();
   gtk_window_add_accelerator_table(GTK_WINDOW(mainwindow), accel);

   box1 = gtk_vbox_new(FALSE, 0);
   gtk_container_add(GTK_CONTAINER(mainwindow), box1);
   gtk_widget_show(box1);
   
   tooltips = gtk_tooltips_new();
   gtk_object_set_data(GTK_OBJECT(mainwindow), "tooltips", tooltips);
   
   menubar = gtk_menu_bar_new();
   gtk_box_pack_start(GTK_BOX(box1), menubar, FALSE, TRUE, 0);
   gtk_widget_show(menubar);

   menuitem = gtk_menu_item_new_with_label("File");
   gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), create_filemenu(accel));
   gtk_menu_bar_append(GTK_MENU_BAR(menubar), menuitem);
   gtk_widget_show(menuitem);

   menuitem = gtk_menu_item_new_with_label("Config");
   gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), create_configmenu(accel));
   gtk_menu_bar_append(GTK_MENU_BAR(menubar), menuitem);
   gtk_widget_show(menuitem);

   menuitem = gtk_menu_item_new_with_label("Help");
   gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), create_helpmenu(accel));
   gtk_menu_item_right_justify(GTK_MENU_ITEM(menuitem));
   gtk_menu_bar_append(GTK_MENU_BAR(menubar), menuitem);
   gtk_widget_show(menuitem);
   
   box2 = gtk_vbox_new (FALSE, 10);
   gtk_container_border_width(GTK_CONTAINER(box2), 10);
   gtk_box_pack_start(GTK_BOX(box1), box2, TRUE, TRUE, 0);
   gtk_widget_show(box2);
   
   main_clist = gtk_clist_new_with_titles(NUM_MAIN_CLIST_COLS, titles);
   
   gtk_clist_set_row_height(GTK_CLIST(main_clist), 20);

   gtk_clist_set_column_width(GTK_CLIST(main_clist), 0, 60);
   gtk_clist_set_column_width(GTK_CLIST(main_clist), 1, 115);
   gtk_clist_set_column_width(GTK_CLIST(main_clist), 2, 100);
   gtk_clist_set_column_width(GTK_CLIST(main_clist), 3, 200);
   gtk_clist_set_column_width(GTK_CLIST(main_clist), 4, 140);
   gtk_clist_set_column_width(GTK_CLIST(main_clist), 5, 80);
   
   gtk_clist_set_column_justification(GTK_CLIST(main_clist), 5, GTK_JUSTIFY_CENTER);

   gtk_clist_set_selection_mode(GTK_CLIST(main_clist), GTK_SELECTION_SINGLE);
   gtk_clist_set_policy(GTK_CLIST(main_clist), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
   
   gtk_signal_connect( GTK_OBJECT(main_clist), "select_row", (GtkSignalFunc) select_clist, NULL);

   gtk_container_border_width(GTK_CONTAINER(main_clist), 5);
   gtk_box_pack_start(GTK_BOX(box2), main_clist, TRUE, TRUE, 0);
   gtk_widget_show(main_clist);
   
   separator = gtk_hseparator_new();
   gtk_box_pack_start(GTK_BOX(box1), separator, FALSE, TRUE, 0);
   gtk_widget_show(separator);

   box2 = gtk_hbox_new(FALSE, 10);
   gtk_container_border_width(GTK_CONTAINER(box2), 10);
   gtk_box_pack_start(GTK_BOX(box1), box2, FALSE, FALSE, 0);
   gtk_widget_show(box2);
   
   button = gtk_button_new_with_label("Start");
   gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);
   gtk_signal_connect(GTK_OBJECT(button), "clicked",
                      (GtkSignalFunc) start_capturing,
                      NULL);
   gtk_widget_show(button);
   gtk_accelerator_table_install(accel, GTK_OBJECT(button), "clicked", 'S', 0);
   gtk_tooltips_set_tip(tooltips, button, "Start the scanning process (shortcut=S)", "ContextHelp/buttons/start");
   
   button = gtk_button_new_with_label("Stop");
   gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);
   gtk_signal_connect(GTK_OBJECT(button), "clicked",
                      (GtkSignalFunc) stop_capturing,
                      NULL);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(tooltips, button, "Stop the scanner from scanning (shortcut=O)", "ContextHelp/buttons/stop");
   gtk_accelerator_table_install(accel, GTK_OBJECT(button), "clicked", 'O', 0);

   separator = gtk_vseparator_new();
   gtk_box_pack_start(GTK_BOX(box2), separator, FALSE, TRUE, 0);
   gtk_widget_show(separator);

   button = gtk_button_new_with_label("Log");
   gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);
   gtk_signal_connect(GTK_OBJECT(button), "clicked",
                      (GtkSignalFunc) switchlog,
                      NULL);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(tooltips, button, "View/Hide the log window (shortcut=L)", "ContextHelp/buttons/log");
   gtk_accelerator_table_install(accel, GTK_OBJECT(button), "clicked", 'L', 0);

   button = gtk_button_new_with_label("Overall Stats");
   gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);
   gtk_signal_connect(GTK_OBJECT(button), "clicked",
                      (GtkSignalFunc) switchstats,
                      NULL);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(tooltips, button, "Look at the overall K.ARP.SKI statistics (shortcut=V)", "ContextHelp/buttons/stats");
   gtk_accelerator_table_install(accel, GTK_OBJECT(button), "clicked", 'V', 0);

   separator = gtk_vseparator_new();
   gtk_box_pack_start(GTK_BOX(box2), separator, FALSE, TRUE, 0);
   gtk_widget_show(separator);
   
   button = gtk_button_new_with_label("Connections");
   gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);
   gtk_signal_connect(GTK_OBJECT(button), "clicked",
                      (GtkSignalFunc) switchconnect,
                      NULL);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(tooltips, button, "View the connections associated with this MAC address (shortcut=C)", "ContextHelp/buttons/connections");
   gtk_accelerator_table_install(accel, GTK_OBJECT(button), "clicked", 'C', 0);

   button = gtk_button_new_with_label("All connections");
   gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);
   gtk_signal_connect(GTK_OBJECT(button), "clicked",
                      (GtkSignalFunc) switchallconnect,
                      NULL);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(tooltips, button, "View a list of all connections (shortcut=A)", "ContextHelp/buttons/allconnections");
   gtk_accelerator_table_install(accel, GTK_OBJECT(button), "clicked", 'A', 0);

   button = gtk_button_new_with_label("Launch");
   gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);
   gtk_signal_connect(GTK_OBJECT(button), "clicked",
                      (GtkSignalFunc) switch_smashy_window,
                      NULL);
   if (!can_smashy)
   {
      gtk_widget_set_sensitive(button, FALSE);
   }
   gtk_widget_show(button);
   gtk_tooltips_set_tip(tooltips, button, "Launch a program vs. the selected MAC address (shortcut=L) ", "ContextHelp/buttons/smashy");
   gtk_accelerator_table_install(accel, GTK_OBJECT(button), "clicked", 'L', 0);
   
   button = gtk_button_new_with_label("Watch");
   gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);
   gtk_signal_connect(GTK_OBJECT(button), "clicked",
                      (GtkSignalFunc) switchwatchall,
                      NULL);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(tooltips, button, "Start watching all traffic to/from the selected MAC address (shortcut=W)", "ContextHelp/buttons/watchall");
   gtk_accelerator_table_install(accel, GTK_OBJECT(button), "clicked", 'W', 0);

   
   button = gtk_button_new_with_label("Protocols");
   gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);
   gtk_signal_connect(GTK_OBJECT(button), "clicked",
                      (GtkSignalFunc) switchprotocols,
                      NULL);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(tooltips, button, "View/Hide a semi-realtime list of the protocols used (shortcut=P)", "ContextHelp/buttons/protocols");
   gtk_accelerator_table_install(accel, GTK_OBJECT(button), "clicked", 'P', 0);

   
   button = gtk_button_new_with_label("Info");
   gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);
   gtk_signal_connect(GTK_OBJECT(button), "clicked",
                      (GtkSignalFunc) switchinfo,
                      NULL);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(tooltips, button, "View info on the selected MAC address (shortcut=I)", "ContextHelp/buttons/info");
   gtk_accelerator_table_install(accel, GTK_OBJECT(button), "clicked", 'I', 0);

   button = gtk_button_new_with_label("Quit");
   gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                             GTK_SIGNAL_FUNC(karpski_quit),
                             NULL);
                             
   gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(tooltips, button, "Quit without saving anything (shortcut=Ctrl-Q)", "ContextHelp/buttons/quit");
   gtk_widget_show(mainwindow);
   gtk_accelerator_table_install(accel, GTK_OBJECT(button), "clicked",
   				 'Q', GDK_CONTROL_MASK);
   
   return;

}
