/*

Karspki connection routines
Brian Costello

*/

#ifndef KARPSKI_CONNECT_H

#define KARPSKI_CONNECT_H

/* One connection record */

typedef struct s_connect_rec
{
   struct in_addr src, dst;
   unsigned int sport, dport;
   GtkWidget *watchwindow;
   GtkWidget *watchtextbox;
   char startstring[15];
   struct s_connect_rec *next;
   u_char connect_stage; /* 1  = open SYN seen
   			  * 2  = open, SYN already seen
   			  * 5  = closed
   			  * 10 = Datagram
   			  */
} t_connect_rec;

/*

Prototypes

*/

#include "karpski.h"

void select_conlist(GtkWidget *widget, gint row, gint column, GdkEventButton *bevent);
void draw_new_connections();
void display_connections(t_connect_rec *first_connect, int);
t_connect_rec *find_connection(t_arp_rec *first_ar, t_connect_rec **last_connect, struct in_addr src, int sport, struct in_addr dst, int dport, int, t_arp_rec **, char *);
int add_connection(t_arp_rec *t_ar, struct in_addr src, int sport, struct in_addr dst, int dport, int our_clist_showing, packet_parse *, char *);
void switchconnect();
void switchallconnect();
void clear_copylist();

#endif 	/* KARPSKI_CONNECTS_H */
