/*********************************************************************
 * IP Flow Meter                                                     *
 * http://www.via.ecp.fr/~tibob/ipfm                                 *
 * ipfm@via.ecp.fr                                                   *
 *********************************************************************

 (c) 1999-2002 Robert Cheramy <robert@cheramy.net>
 (c) 2000      Samuel Hocevar <sam@via.ecp.fr>
 (c) 1999      Andres Krapf <dae@via.ecp.fr>

 *********************************************************************
 * This program uses the libpap for best portability.                *
 * libpcap can be found at ftp://ftp.ee.lbl.gov/libpcap.tar.Z        *
 *********************************************************************

 200010: sam & tibob : clear and dump options
         sam : PID file & daemon mode handling
 200210: tibob : configurable PID file

 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <unistd.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>

#include "config.h"
#include "data.h"
#include "filter.h"
#include "init.h"
#include "pcap.h"
#include "utils.h"
#include "debug.h"

struct AllLogsType * pAllLogs = NULL;
extern int run_as_daemon;
extern struct OptionsType Options;
time_t NextDumpGlobal=0;

int main(int argc, char *argv[]) {
  struct ip *p_packet;
  struct AllLogsType * pTempLog;
#ifdef DEBUG_MESSAGES
  char *stringTime, *timezonestring;
  extern ipfm_timezone tz;
#endif
	  
  DEBUG_MSG("Starting IPFM\n");
  
  ParseCmdLine(argc, argv);
  DEBUG_MSG("Command line parsed.\n");

  Init();
  
  DEBUG_MSG("Init OK.\n");
  
#ifdef DEBUG_MESSAGES
  for (pTempLog = pAllLogs; NULL != pTempLog; pTempLog = pTempLog->Next) {
    stringTime = timefile("%Y/%m/%d %H:%M:%S", pTempLog->NextDump);
    if (tz == local) {
      timezonestring = "local time";
    } else {
      timezonestring = "UTC";
    }

     DEBUG_MSG("Dumping at %s (%s) every %d seconds, clearing every %i dumps, in %i dumps\n",
		stringTime, timezonestring, pTempLog->DumpInterval,
		pTempLog->ClearInterval, pTempLog->ClearCounter);
    xfree(stringTime);
  }
#endif
  
  if (run_as_daemon) {
    /* Check PID */
    if (check_pid(Options.PidFile)) {
      printf ("Already running, exiting.\n");
      exit (1);
    }

    if (1 != getppid()) {
      signal (SIGTTOU, SIG_IGN);
      signal (SIGTTIN, SIG_IGN);
      signal (SIGTSTP, SIG_IGN);
    }
    daemon (0, 0);
    umask (022);

    /* Write PID file */
    if (!write_pid(Options.PidFile)) {
      exit (1);
    }
  }
  
  for(;;) {
    p_packet = (struct ip *) getnextippkt();

    dofilter(p_packet);

    /* Well that's an approximation. I should perhaps use an alarm() */
    if (NextDumpGlobal < time(NULL)) {
      /* NextDumpGlobal check will at least be done within next
         DEFAULT_OPTIONS_DUMPINTERVAL */
      NextDumpGlobal = time(NULL) + DEFAULT_OPTIONS_DUMPINTERVAL;
      for (pTempLog = pAllLogs; NULL != pTempLog; pTempLog = pTempLog->Next) {
      DEBUG_MSG("time %d nextdump %d delta %d\n", time(NULL), pTempLog->NextDump, pTempLog->NextDump - time(NULL));
        if (time(NULL) > pTempLog->NextDump) {
          data_dump(pTempLog);
          /* Check if we have to clear the logs as well */
          if (0 != pTempLog->ClearInterval) {
            pTempLog->ClearCounter--;
            if (0 >= pTempLog->ClearCounter) {
              data_clear(pTempLog);
              pTempLog->PrevClear = pTempLog->NextDump;
              pTempLog->NextClear = pTempLog->NextDump +
                            pTempLog->ClearInterval * pTempLog->DumpInterval;
              pTempLog->ClearCounter = pTempLog->ClearInterval;
            }
          }
          pTempLog->PrevDump = pTempLog->NextDump;
          pTempLog->NextDump += pTempLog->DumpInterval;
          /* Set NextDumpGlobal to the right time */
          if (NextDumpGlobal > pTempLog->NextDump) {
            NextDumpGlobal = pTempLog->NextDump;
          }
        }
      }
    }
  }

  /* Exit(0); */ /* unreachable */
}
