.\" -*-nroff-*-
.\"
.\"     Copyright (c) 1999-2002 Robert CHERAMY <robert@cheramy.net>
.\"     Copyright (c) 2001 Loc Tortay & IN2P3 Computing Center <tortay@cc.in2p3.fr>
.\"
.\"     This program is free software; you can redistribute it and/or modify
.\"     it under the terms of the GNU General Public License as published by
.\"     the Free Software Foundation; either version 2 of the License, or
.\"     (at your option) any later version.
.\"
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.TH IPFM 8 "Last change: 06 october 2002"

.SH NAME
ipfm \- IP Flow Meter

.SH SYNOPSIS
.B ipfm
[\-c
.I config-file
][\-\-config
.I config-file
] [-h][--help] [-n][--nodaemon] [\-p
.I pid-file
] [--pid
.I pid-file
] [-r
.I file
] [--readfrom
.I file
]

.SH DESCRIPTION
.B ipfm
is a bandwidth analysis tool. It counts how much data was send and
received by specified hosts through an Internet link.

.B ipfm
is based on the libpcap (ftp://ftp.ee.lbl.gov/libpcap-0.4.tar.Z, see
http://www.tcpdump.org/ for newer versions) and should be portable.

.B
ipfm is developed under Linux libc6 (Debian woody and sid).

It was reported to work under Linux libc5 (slackware) and libc6 (RedHat,
SuSE), FreeBSD, OpenBSD, IRIX, Solaris, HP-UX and AIX.
As we can't test new versions under these OSes, there might be problems. Please
report them at ipfm@via.ecp.fr.

.SH OPTIONS
Note that depending on the OS, long options may no be supported.

.IP "-c config-file, --config config-file"
.I config-file
specifies an alternate configuration file to use. By default,
.IR __CONFIGURATION_FILE
is used.
.IP "-n, --nodaemon"
does not run as a daemon
.IP "-h, --help"
displays an help message on standard output and exit
.IP "-p pid-file, --pid pid-file"
.I pid-file
specifies an alternate pid file to use. By default,
.IR __PIDFILE
is used.
.IP "-r file, --readfrom file"
.I file
is a raw tcpdump log file (crated by using tcpdump -w). When using this option, IPFM will ignore the "device" keyword in the configuration file, read the packets from
.I file
, dump logs and exit.

.SH SIGNALS
.B ipfm
reacts to certain signals.

.TP
.I SigHUP
This causes
.B ipfm
to dump (and clear) its data tables in the log file (see
.BR ipfm.conf (8)
), close pcap descriptor, reload configuration file and restart.

.TP
.I SigTERM
This causes
.B ipfm
to dump (and clear) its data tables in the log file (see
.BR ipfm.conf (8)
) and exit.

.TP
.I SigKILL
This causes
.B ipfm
to exit.

.TP
.I SigINT (ctrl-c)
This causes
.B ipfm
to exit after having dumped and cleared its buffers.

.TP
.I SigUSR1
This causes
.B ipfm
to dump its data tables in the log file without exiting or clearing them.

.SH SEE ALSO
.BR ipfm.conf (8)

.SH AUTHORS
Robert CHERAMY <tibob@via.ecp.fr>, Andres KRAPF <dae@via.ecp.fr>

.PP
IPFM home page can be found at http://www.via.ecp.fr/~tibob/ipfm/
