/*
 * sxid - suid, sgid file and directory checking
 * structs.h - global structures and related defines
 *
 * Copyright (C) 1999 Ben Collins <bcollins@debian.org>
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with sxid; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#ifndef _STRUCTS_H
#define _STRUCTS_H 1

#include <strings.h>
#include <pwd.h>
#include <grp.h>
#include <sys/types.h>

#ifndef MAXBUF
#define MAXBUF 2048
#endif

/* Configuration info */
struct config_opt {
    char search_paths[MAXBUF];
    char exclude_paths[MAXBUF];
    char ignore_dirs[MAXBUF];
    char email[MAXBUF];
    char log_file[MAXBUF];
    char forbidden_paths[MAXBUF];
    char mail_prog[MAXBUF];
    int keep_logs;
    unsigned int flags;
};

/* Flags for config file */
#define FLAG_ANOT	0x0001
#define FLAG_AROT	0x0002
#define FLAG_EFOR	0x0004
#define FLAG_LALL       0x0010
#define FLAG_SPOT       0x0020

/* File entry information */
struct file_entry {
    struct file_entry *next;
    char *path;
    uid_t uid;
    gid_t gid;
    uid_t old_uid;
    gid_t old_gid;
    mode_t mode;
    mode_t old_mode;
    char *md5;
    ino_t inode;
    u_int flags;
};

/* Flags for file entries */
#define FE_OLD		0x0001	/* Old entry (default, get's unset if current) */
#define FE_NEW		0x0002	/* New entry */
#define FE_CHMODE       0x0004	/* Changed mode (r,w or x) */
#define FE_CHSUM	0x0010	/* Changed md5sum (files only) */
#define FE_CHINODE      0x0020	/* Changed inode */
#define FE_CHUSER       0x0040	/* User id changed */
#define FE_CHGRP        0x0100	/* Group id changed */
#define FE_CHANGEDATTR  0x0174	/* Mask for anything changed */

#endif /* _STRUCTS_H */
