/*
 * sxid - suid, sgid file and directory checking
 * search.c - directory search functions, also functions to scan
 *    the file_entry struct for changes
 *
 * Copyright (C) 1999 Ben Collins <bcollins@debian.org>
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with sxid; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <limits.h>

#include "structs.h"
#include "globals.h"
#include "search.h"
#include "logging.h"
#include "md5sum.h"

void start_search (void)
{
    char *tok, *s;

    /*
     * FIXME: No more than 24 paths in a single
     * config file entry, make this dynamic
     */
    char *paths[24];
    int count = 0, i;

    s = strdup (config_options.search_paths);

    for (tok = strtok (s, " "); (tok != NULL) && (count < 24);
	tok = strtok (NULL, " "), count++)
	paths[count] = tok;

    for (i = 0; i < count; i++)
	if (!excluded (paths[i]))
	    search_path (paths[i]);

    free (s);
    s = strdup (config_options.forbidden_paths);
    count = 0;
    for (tok = strtok (s, " "); (tok != NULL) && (count < 24);
	tok = strtok (NULL, " "), count++)
	paths[count] = tok;

    for (i = 0; i < count; i++)
	if (!searched (paths[i]))
	    search_path (paths[i]);

    return;
}

void search_path (char *dir)
{
    DIR *dir_list;
    struct dirent *dir_entry;
    char buf[PATH_MAX];
    struct stat dirent_stat;

    dir_list = opendir (dir);
    if (dir_list == NULL)
	return;

    for (dir_entry = readdir (dir_list); dir_entry != NULL; dir_entry = readdir (dir_list)) {
	if (strcmp (dir_entry->d_name, "..") && strcmp (dir_entry->d_name, ".")) {
	    sprintf (buf, "%s%s%s", dir, strlen (dir) == 1
		? "" : "/", dir_entry->d_name);

	    lstat (buf, &dirent_stat);

	    if (dirent_stat.st_mode & S_IFDIR) {
		if (dirent_stat.st_mode & (S_ISUID | S_ISGID))
		    add_file_entry (buf, dirent_stat, NULL);
		if (!excluded (buf))
		    search_path (buf);
	    } else {
		if (dirent_stat.st_mode & S_IFREG &&
		    dirent_stat.st_mode & (S_ISUID | S_ISGID)) {
		    FILE *fp = NULL;
		    unsigned char digest[16 + 1];
		    int i;
		    char digest_hex[(16 * 2) + 1], *p;

		    fp = fopen (buf, "r");
		    if (fp == NULL) {
			fprintf (stderr, "W: opening %s for md5 read\n", buf);
			continue;
		    }
		    if (mdfile (fp, digest)) {
			fprintf (stderr, "W: reading %s for md5\n", buf);
			continue;
		    }
		    fclose (fp);
		    p = digest_hex;

		    for (i = 0; i < 16; ++i) {
			sprintf (p, "%02x", digest[i]);
			p += 2;
		    }
		    add_file_entry (buf, dirent_stat, digest_hex);
		}
	    }
	}
    }
    closedir (dir_list);
    return;
}

int excluded (char *dir)
{
    char *tok, *e;
    int exclude = 0;

    e = strdup (config_options.exclude_paths);

    tok = strtok (e, " ");
    while (tok != NULL) {
	if (!strcmp (tok, dir))
	    exclude = 1;
	tok = strtok (NULL, " ");
    }

    return exclude;
}

int searched (char *dir)
{
    char *tok, *e;
    int searched = 0;

    e = strdup (config_options.search_paths);

    tok = strtok (e, " ");
    while (tok != NULL) {
	if (!strncmp (tok, dir, strlen (tok) - 1))
	    searched = 1;
	tok = strtok (NULL, " ");
    }

    return searched;
}

int forbidden (char *dir)
{
    char *tok, *e;
    int forbidden = 0;

    e = strdup (config_options.forbidden_paths);

    tok = strtok (e, " ");
    while (tok != NULL) {
	if (!strncmp (tok, dir, strlen (tok) - 1))
	    forbidden = 1;
	tok = strtok (NULL, " ");
    }

    return forbidden;
}
