/*
 * utmp.c	Write system and radius utmp files.
 *
 * Version:	#(#)utmp.c  1.00  12-Nov-1997  miquels@cistron.nl
 *
 */
#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <utmp.h>
#include "server.h"

int update_utmp(int port, struct auth *ai, int islogin)
{
	struct utmp tmp, *utmptr;
	FILE *fp;
	pid_t pid;

	pid = getpid();

	if (lineconf[port].sysutmp && islogin) {
		/*
		 *	Init should have setup this for us, so we
		 *	only update the entry if it exists (and only
		 *	at login - init does logout for us).
		 */
		setutent();
		while((utmptr = getutent()) != NULL)
			if (utmptr->ut_pid == pid)
				break;
		if (utmptr) {
			tmp = *utmptr;
			tmp.ut_type = USER_PROCESS;
			tmp.ut_time = time(NULL);
			strncpy(tmp.ut_user, ai->login, UT_NAMESIZE);
			strncpy(tmp.ut_line, lineconf[port].tty,
				UT_LINESIZE);
			if (ai->address) {
				/*
				 *	Fill in ut_host as
				 *	port:X.55.2
				 */
				char *p = dotted(ai->address);
				int i = 0;

				while(*p && i < 2)
					if (*p++ == '.') i++;

				sprintf(tmp.ut_host, "%03d:%c.%s", port,
					ai->proto, p);
			} else
				strncpy(tmp.ut_host, "%03d:", port);
#ifdef __linux__
			tmp.ut_addr = ai->address;
#endif
			setutent();
			pututline(&tmp);
			endutent();
			if (lineconf[port].syswtmp &&
			    (fp = fopen(WTMP_FILE, "a")) != NULL) {
				fwrite(&tmp, sizeof(tmp), 1, fp);
				fclose(fp);
			}
		}
	}

#if 0 /* To be implemented */
	if (lineconf[port].radutmp == 0)
		return 0;

	/*
	 *	Now update the /var/log/radutmp file.
	 */
	memset(&rtmp, 0, sizeof(rtmp));
	strncpy(rtmp.login, ai->login, sizeof(rtmp.login));
	rtmp.nas_port = 
	memcpy(rtmp.session_id, ai->session, 16);
	rtmp.nas_address = ai->localip;
	rtmp.framed_address = ai->addres;
	rtmp.proto = ai->proto;
	rtmp.time = time(NULL);
	rtmp.type = islogin ? P_LOGIN : P_IDLE;
#endif

	return 0;
}

