/*
 * main.c	Main part of the portslave.
 *
 * Version:	@(#)main.c  1.35  08-Nov-1997  MvS.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <termios.h>
#include <signal.h>
#include <ctype.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "server.h"


/*
 *	Change argv[0] te reflect what we're doing.
 */
static void title(char **argv, char *n, int port)
{
  char buf[32];
  int i, len;
  char *s;

  len = strlen(argv[0]);

  for(i = 0; argv[i]; i++) {
	for(s = argv[i]; *s; s++)
		*s = ' ';
	argv[i][0] = 0;
  }
  sprintf(buf, "%s %d", n, port);
  strncpy(argv[0], buf, len);
}


/*
 *	Main loop for 1 login channel.
 */
int main(int argc, char **argv)
{
  struct auth ai;
  char namebuf[64], pass[64];
  char *name = namebuf;
  char *tty = NULL;
  int i, r = 0;
  int do_acct = 0;
  int thisport = -1;
  int printed = 0;

  /*
   *	Check the syntax.
   */
  if (argc < 2 || (argv[1][0] != '-'  &&
      (thisport = atoi(argv[1])) == 0 && argv[1][0] != '0')) {
	nsyslog(LOG_ERR, "Usage: portslave <port>\n");
	exit(1);
  }

  if (argv[1][0] == '-') {
	thisport = -2;
	tty = ttyname(0);
	if (tty == NULL) {
		fprintf(stderr,
			"portslave: standard input is not a tty\n");
		exit(1);
	}
  }

  /*
   *	Read the config file.
   */
  if ((thisport = rad_init(thisport, &ai, tty)) < 0)
	return 1;
  if (lineconf[thisport].tty == NULL) {
	nsyslog(LOG_ERR, "port %d has no tty defined", thisport);
	exit(1);
  }
  nsyslog(LOG_INFO, "portslave started on port %d (%s)", thisport,
		lineconf[thisport].tty);

  /*
   *	Now put a getty on the port.
   */
  if (lineconf[thisport].emumodem)
	r = emumodem(thisport, ai.conn_info);
  else
	r = getty(thisport, ai.conn_info);
  if (r < 0) exit(1);

  nsyslog(LOG_INFO, "Connected - waiting for login");

  /*
   *	Do login/password if needed.
   */
  if (lineconf[thisport].authtype) {
	for(i = 0; i < 3; i++) {
		if (do_login(thisport, name, pass) < 0)
			exit(1);

		do_acct = 0;

		/*
		 *	Do authentication if needed.
		 */
		if (mainconf.locallogins && name[0] == '!') {
			strcpy(ai.login, name + 1);
			ai.passwd[0] = 0;
			ai.proto = P_LOCAL;
			break;
		}
		if (strcmp(name, "AutoPPP") == 0) {
			ai.proto = P_AUTOPPP;
			break;
		}

		strcpy(ai.login, name);
		strcpy(ai.passwd, pass);

		do_acct++;

		if (rad_client(thisport, &ai, 0) < 0) {
			if (ai.message[0])
				printf("%s\n", ai.message);
			else
				printf("Login incorrect.\n");
			fflush(stdout);
		} else
			break;
	}

	if (i == 3) {
		/*
		 *	3 login failures - exit!
		 */
		fflush(stdout);
		usleep(250000);
		exit(1);
	}

	setenv("LOGNAME", ai.login, 1);

	if (do_acct) {
		/*
		 *	While messing around with accounting, we have to
		 *	block, but not ignore, SIGHUP and friends.
		 */
		block(SIGHUP);
		block(SIGTERM);

		rad_acct(thisport, &ai, 1);

#if 0 /* XXX - DEBUG */
		printf("Protocol:     %c\n", ai.proto);
		printf("address    :  %s\n", dotted(ai.address));
		printf("netmask:      %s\n", dotted(ai.netmask));
		printf("mtu:          %d\n", ai.mtu);
#endif
	}
  }
  /*
   *	Okay, we are logged in here (or authentication comes later).
   */
  if (ai.message[0]) {
	printf("%s\n", ai.message);
	printed = 1;
  }

  switch(ai.proto) {
	case P_AUTOPPP:
		nsyslog(LOG_INFO, "PPP frames detected - switching to PPP mode");
		break;
	case P_SLIP:
	case P_CSLIP:
		nsyslog(LOG_INFO, "%s/SLIP session (%s)", ai.login,
			dotted(ai.address));
		break;
	case P_PPP:
		nsyslog(LOG_INFO, "%s/PPP session (%s)", ai.login,
			dotted(ai.address));
		break;
	case P_RLOGIN:
		nsyslog(LOG_INFO, "%s/rlogin to %s", ai.login,
			dotted(ai.address));
		break;
	default:
		nsyslog(LOG_INFO, "%s/type %c starting", ai.login, ai.proto);
		break;
  }

  if (ai.proto == P_AUTOPPP) title(argv, "-AUTO", thisport);
  if (ai.proto == P_PPP)     title(argv, "-PPP", thisport);
  if (ai.proto == P_SLIP)    title(argv, "-SLIP", thisport);
  if (ai.proto == P_CSLIP)   title(argv, "-CSLIP", thisport);

  /*
   *	Print a portmaster compatible SLIP/PPP banner.
   */
  if (strchr("PCS", ai.proto)) {
	printf("%s session from (%s) ",
		ai.proto == 'P' ? "PPP" : "SLIP", dotted(mainconf.ipno));
	printf("to %s beginning....\n", dotted(ai.address));
	printed = 1;
  }

  /*
   *	Wait for output to drain.
   */
  fflush(stdout);
  if (printed) sleep(2);
  tcdrain(1);

  /*
   *	Start the protocol.
   */
  r = spawnit(thisport, &ai);

  /*
   *	If the protocol returned, tell the accounting server we're done.
   */
  if (do_acct) rad_acct(thisport, &ai, 0);

  if (ai.proto != P_PPP)
	nsyslog(LOG_INFO, "Session done.");

  return (r == 0 ? 0 : 1);
}
