/*
 * ctlp-subs.c	Here's where most SIOC* calls for ctlportslave live.
 *
 * Version:	@(#)ctlp-subs.c  1.00  13-Nov-1997  miquels@cistron.nl
 *
 */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <linux/if_ppp.h>

#define MAX_IFS 128
extern int sockfd;

/*
 *	Find the idle time of a certain device.
 */
int idle_stat(char *dev, int *idle)
{
	char buf[128];
	int fd;
	struct termios tty;
	struct ppp_idle ppp_idle;
	struct stat st;
	time_t now;

	*idle = 0;

	if (dev[0] != '/') {
		sprintf(buf, "/dev/%s", dev);
		dev = buf;
	}
	if ((fd = open(dev, O_RDONLY|O_NONBLOCK)) < 0) {
		perror(dev);
		return -1;
	}
	if (tcgetattr(fd, &tty) < 0) {
		perror(dev);
		close(fd);
		return -1;
	}
	switch(tty.c_line) {
		case N_TTY:
			if (fstat(fd, &st) < 0) break;
			now = time(NULL);
			*idle = now - st.st_mtime;
			break;
		case N_PPP:
			if (ioctl(fd, PPPIOCGIDLE, &ppp_idle) == 0) {
				if (ppp_idle.recv_idle < ppp_idle.xmit_idle)
					*idle = ppp_idle.recv_idle;
				else
					*idle = ppp_idle.xmit_idle;
			}
			break;
		default:
			break;
	}

	close(fd);

	return 0;
}


/*
 *	Find the device with a certain IP address.
 *	Return packets in/out if we can retrieve such information.
 */
int traffic_stats(struct in_addr saddr, int *in, int *out)
{
	int ifs_len;
	struct ifreq *ifr, *ifs;
	struct ifconf ifc;
	struct ifpppstatsreq req;
	struct in_addr ina;
	int ret = -1;

	*in = *out = 0;

	ifs_len = MAX_IFS * sizeof (struct ifreq);
	ifs = (struct ifreq *) malloc (ifs_len);
	ifc.ifc_len = ifs_len;
	ifc.ifc_req = ifs;

	if (ioctl(sockfd, SIOCGIFCONF, &ifc) < 0) {
		perror("ioctl(SIOCGIFCONF)");
		free(ifs);
		return -1;
	}
	ifs_len = ifc.ifc_len;

	for (ifr = ifc.ifc_req; ifs_len > 0; ifr++) {
		ifs_len -= sizeof(struct ifreq);
		ifr->ifr_dstaddr.sa_family = AF_INET;
		if (ioctl(sockfd, SIOCGIFDSTADDR, ifr) < 0)
			continue;
		if (ifr->ifr_dstaddr.sa_family != AF_INET)
			continue;
		ina = ((struct sockaddr_in *) &ifr->ifr_dstaddr)->sin_addr;
		/*printf("CHECK: %s %s\n", ifr->ifr_name, inet_ntoa(ina));*/
		if (ina.s_addr == saddr.s_addr) {
			ret = 0;
			break;
		}
	}

	if (ret == 0 && strncmp(ifr->ifr_name, "ppp", 3) == 0) {
		/*
		 *	Get bytes transfered
		 *	for a PPP interface.
		 */
		char *name = ifr->ifr_name;
		memset (&req, 0, sizeof (req));
#ifdef __linux__
		req.stats_ptr = (caddr_t) &req.stats;
#		undef ifr_name
#		define ifr_name ifr__name
#endif
		strcpy(req.ifr_name, name);
		if (ioctl(sockfd, SIOCGPPPSTATS, &req) == 0) {
			*in  = req.stats.p.ppp_ibytes;
			*out = req.stats.p.ppp_obytes;
		}
        }

	free(ifs);

	return ret;
}

#ifdef STANDALONE
int sockfd;

int main(int argc, char **argv)
{
	struct in_addr ina;
	int r, in, out;

	sockfd = socket(AF_INET, SOCK_DGRAM, 0);
	inet_aton(argv[1], &ina);
	r = traffic_stats(ina, &in, &out);
	printf("r = %d, in = %d, out = %d\n", r, in, out);

	return 0;
}
#endif

