/*
 * auth.h	Header file for the authentication stuff.
 *		We only use radius, but anyway this is
 *		a try to hide the authentication protocol
 *		from the rest of the system.
 *
 * Version:	@(#)auth.h  1.00  05-Jul-1996  miquels@cistron.nl
 *
 */

/*
 *	Types of connection.
 */
#define P_UNKNOWN	0
#define P_LOCAL		'L'
#define P_RLOGIN	'R'
#define P_SLIP		'S'
#define P_CSLIP		'C'
#define P_PPP		'P'
#define P_AUTOPPP	'A'
#define P_TELNET	'E'
#define P_TCPCLEAR      'T'
#define P_TCPLOGIN      'U'
#define P_CONSOLE	'!'
#define P_SHELL		'X'

/*
 *	Authentication info. This struct
 *	contains all info we get back from
 *	the authentication protocol.
 */
struct auth {
  /* Input */
  char login[32];
  char passwd[32];
  time_t start;
  /* Output */
  char session[16];
  char message[256];
  char conn_info[128];
  int  proto;
  int  port;
  unsigned int address;
  unsigned int localip;
  unsigned int netmask;
  int mtu;
  int mru;
  int idletime;
  int porttype;
  int sent_bytes;
  int recv_bytes;
};

int rad_client(int port, struct auth *ai, int ppp);
int rad_acct(int port, struct auth *ai, int islogin);
unsigned int rad_sessionid(char *s);
int rad_init(int port, struct auth *ai, char *tty);
int rad_portno(char *tty);
char *dotted(unsigned int ipno);
