/*
 * pppd.h	Contains a subset of the structures and definitions
 *		of ppp-2.2.0f for libportslave.c
 *
 * Version:	@(#)pppd.h  1.10  27-Oct-1997  miquels@cistron.nl
 *
 */

#define UPAP_AUTHACK 2
#define UPAP_AUTHNAK 3

#define u_short   unsigned short
#define u_char    unsigned char
#define u_int_32t unsigned int

typedef struct lcp_options {
    int passive : 1;		/* Don't die if we don't get a response */
    int silent : 1;		/* Wait for the other end to start first */
    int restart : 1;		/* Restart vs. exit after close */
    int neg_mru : 1;		/* Negotiate the MRU? */
    int neg_asyncmap : 1;	/* Negotiate the async map? */
    int neg_upap : 1;		/* Ask for UPAP authentication? */
    int neg_chap : 1;		/* Ask for CHAP authentication? */
    int neg_magicnumber : 1;	/* Ask for magic number? */
    int neg_pcompression : 1;	/* HDLC Protocol Field Compression? */
    int neg_accompression : 1;	/* HDLC Address/Control Field Compression? */
    int neg_lqr : 1;		/* Negotiate use of Link Quality Reports */
#ifdef PPP_23X
    int neg_cbcp : 1;		/* Negotiate use of CBCP */
#endif
    u_short mru;		/* Value of MRU */
    u_char chap_mdtype;		/* which MD type (hashing algorithm) */
    u_int32_t asyncmap;		/* Value of async map */
    u_int32_t magicnumber;
    int numloops;		/* Number of loops during magic number neg. */
    u_int32_t lqr_period;	/* Reporting period for LQR 1/100ths second */
} lcp_options;

extern lcp_options lcp_wantoptions[];
extern lcp_options lcp_allowoptions[];
extern u_int32_t netmask;
extern int logged_in;
extern int idle_time_limit;

extern int setipaddr(char *arg);

extern void (*ppp_openlog)();
extern void (*ppp_syslog)();
extern void (*ppp_closelog)();

