#ifndef EXTERN
#  define EXTERN extern
#endif

#include "conf.h"
#include "rwconf.h"
#include "auth.h"

#define syslog		nsyslog
#define vsyslog		nvsyslog
#define openlog		nopenlog
#define setlogmask	nsetlogmask
#define closelog	ncloselog
#include <syslog.h>

/*
 * Global functions for the portslave.
 */
int tty_copy(int crnl, int in, int out);
void *xmalloc(int size);
void block(int sig);
void unblock(int sig);
int getline(int ppp, char *prompt, int echo, char *line, int len);
int chatarray(int fd, int argc, char **argv, char *);
int chat_expect(int fd, char *s, char *);
int chat(int fd, char *s, char *);
void unescape(char *);
char *dotted(unsigned int);
int getty(int port, char *conn_info);
int emumodem(int port, char *conn_info);
int do_login(int port, char *login, char *pass);
int spawnit(int port, struct auth *ai);
char *percent(int port, struct auth *ai, char *in);
int do_slip(int port, struct auth *ai);
int update_utmp(int port, struct auth *ai, int islogin);

#define nsyslog syslog

/* Global variables. */
extern int chat_timeout;
extern int chat_send_delay;
extern void (*chat_debug_printf)(const char *, ...);
extern int thisport;

