/*
 * rwconf.h	Definitions for the configuration stuff in conf.c.
 *		You cannot set any compile-time directives here.
 *
 * Version:	@(#)rwconf.h  1.10  14-Oct-1996  miquels@cistron.nl
 *
 */

#ifndef EXTERN
#  define EXTERN extern
#endif

/*
 *	General system configuration.
 */
struct main_cfg {
  char *hostname;
  unsigned int ipno;
  char *lockdir;
  char *rlogin;
  char *telnet;
  char *pppd;
  int locallogins;
  unsigned int syslog;
  int facility;
};
EXTERN struct main_cfg mainconf;

/*
 *	Configuration, per line.
 */
struct line_cfg {
  /* Networking options */
  int authtype;
  unsigned int authhost1;
  unsigned int authhost2;
  unsigned int accthost1;
  unsigned int accthost2;
#ifdef UUCPHACK
  unsigned int uauthhost1;
  unsigned int uauthhost2;
  unsigned int uaccthost1;
  unsigned int uaccthost2;
#endif
  char *secret;
  int protocol;
  int host;
  unsigned int ipno;
  unsigned int netmask;
  int mtu, mru;
  char *autoppp;
  char *pppopt;
  char *tty;
  /* Other options */
  char *issue;
  char *prompt;
  char *term;
  /* Modem options */
  int flow;
  int dcd;
  int speed;
  int checktime;
  int debug;
  int emumodem;
  int porttype;
  int sysutmp;
  int syswtmp;
  char *checkchat;
  char *initchat;
  char *waitfor;
  char *answer;
  int aa;
};
EXTERN struct line_cfg lineconf[MAXLINES];
EXTERN struct line_cfg allconf;

/*
 *	Flow control definitions.
 */
#define FLOW_NONE	0
#define FLOW_HARD	1
#define FLOW_SOFT	2

/*
 *	Functions.
 */
void initcfg(void);
int readcfg(void);
int writecfg(void);
int portno(char *tty);
