#! /bin/sh

set -x

DIR=/usr/local/portslave
DAEMON=daemon

for i in $DIR $DIR/bin $DIR/etc $DIR/lib
do
  [ ! -d $i ] && install -m 755 -d $i
done

if [ -f $DIR/etc/server.cfg ]
then
	install -m 644 src/server.cfg	$DIR/etc/server.cfg.sample
else
	install -m 644 src/server.cfg	$DIR/etc/server.cfg
fi
install -m 755 src/portslave		$DIR/bin/portslave
install -m 755 src/radinit		$DIR/bin/radinit
install -o root -g $DAEMON -m 4750 src/ctlportslave	$DIR/bin/ctlportslave
install -m 755 rlogin-8.10/rlogin	$DIR/bin/rlogin
install -m 755 ppp-2.2.0f-radius/pppd/pppd	$DIR/bin/pppd
install -m 644 libpsr/libpsr.so		$DIR/lib/libpsr.so

rm -f $DIR/bin/in.fingerd
ln -s ctlportslave $DIR/bin/in.fingerd

if [ -d /etc/rc.boot ] && [ ! -f /etc/rc.boot/radinit ]
then
	install -m 755  src/radinit.sh /etc/rc.boot/radinit
fi

