/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConcat;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.util.FileManager;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import virtuoso.jena.driver.VirtGraph;
import virtuoso.jena.driver.VirtModel;

public class VirtuosoQueryExecution
implements QueryExecution {
    private QueryIterConcat output = null;
    String virt_graph = null;
    private VirtGraph graph;
    private String virt_query;
    int prefetchSize = 200;
    java.sql.Statement stmt = null;

    public VirtuosoQueryExecution(String string, VirtGraph virtGraph) {
        this.graph = virtGraph;
        this.virt_graph = this.graph.getGraphName();
        this.prefetchSize = this.graph.getFetchSize();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "";
        while (stringTokenizer.hasMoreTokens() && !(string2 = stringTokenizer.nextToken().toLowerCase()).equals("describe") && !string2.equals("construct") && !string2.equals("ask")) {
        }
        this.virt_query = string2.equals("describe") || string2.equals("construct") || string2.equals("ask") ? "sparql\n define output:format '_JAVA_'\n " + string : "sparql\n " + string;
    }

    public ResultSet execSelect() {
        Object var1_1 = null;
        try {
            Connection connection = this.graph.getConnection();
            this.stmt = connection.createStatement();
            this.stmt.setFetchSize(this.prefetchSize);
            java.sql.ResultSet resultSet = this.stmt.executeQuery(this.virt_query);
            return new VResultSet(this.graph, resultSet);
        }
        catch (Exception exception) {
            throw new JenaException("Can not create ResultSet.:" + exception);
        }
    }

    public void setFileManager(FileManager fileManager) {
        throw new JenaException("UnsupportedMethodException");
    }

    public void setInitialBinding(QuerySolution querySolution) {
        throw new JenaException("UnsupportedMethodException");
    }

    public Dataset getDataset() {
        return null;
    }

    public Context getContext() {
        return null;
    }

    public Model execConstruct() {
        return this.execConstruct(ModelFactory.createDefaultModel());
    }

    public Model execConstruct(Model model) {
        try {
            Connection connection = this.graph.getConnection();
            this.stmt = connection.createStatement();
            this.stmt.setFetchSize(this.prefetchSize);
            java.sql.ResultSet resultSet = this.stmt.executeQuery(this.virt_query);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                Node node;
                Node node2;
                Node node3 = VirtGraph.Object2Node(resultSet.getObject(1));
                Statement statement = ModelUtils.tripleToStatement((Model)model, (Triple)new Triple(node3, node2 = VirtGraph.Object2Node(resultSet.getObject(2)), node = VirtGraph.Object2Node(resultSet.getObject(3))));
                if (statement == null) continue;
                model.add(statement);
            }
            this.stmt.close();
            this.stmt = null;
        }
        catch (Exception exception) {
            throw new JenaException("Convert results are FAILED.:" + exception);
        }
        return model;
    }

    public Model execDescribe() {
        return this.execDescribe(ModelFactory.createDefaultModel());
    }

    public Model execDescribe(Model model) {
        try {
            Connection connection = this.graph.getConnection();
            this.stmt = connection.createStatement();
            this.stmt.setFetchSize(this.prefetchSize);
            java.sql.ResultSet resultSet = this.stmt.executeQuery(this.virt_query);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                Node node;
                Node node2;
                Node node3 = VirtGraph.Object2Node(resultSet.getObject(1));
                Statement statement = ModelUtils.tripleToStatement((Model)model, (Triple)new Triple(node3, node2 = VirtGraph.Object2Node(resultSet.getObject(2)), node = VirtGraph.Object2Node(resultSet.getObject(3))));
                if (statement == null) continue;
                model.add(statement);
            }
            this.stmt.close();
            this.stmt = null;
        }
        catch (Exception exception) {
            throw new JenaException("Convert results are FAILED.:" + exception);
        }
        return model;
    }

    public boolean execAsk() {
        boolean bl = false;
        try {
            Connection connection = this.graph.getConnection();
            this.stmt = connection.createStatement();
            java.sql.ResultSet resultSet = this.stmt.executeQuery(this.virt_query);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                if (resultSet.getInt(1) != 1) continue;
                bl = true;
            }
            this.stmt.close();
            this.stmt = null;
        }
        catch (Exception exception) {
            throw new JenaException("Convert results are FAILED.:" + exception);
        }
        return bl;
    }

    public void abort() {
        if (this.stmt != null) {
            try {
                this.stmt.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void close() {
        if (this.stmt != null) {
            try {
                this.stmt.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VResultSet
    implements ResultSet {
        ResultSetMetaData rsmd;
        java.sql.ResultSet rs;
        boolean v_finished = false;
        boolean v_prefetched = false;
        VirtModel m;
        Binding v_row;
        List<String> resVars;
        int row_id = 0;

        protected VResultSet(VirtGraph virtGraph, java.sql.ResultSet resultSet) {
            this.rs = resultSet;
            this.m = new VirtModel(virtGraph);
            try {
                this.rsmd = this.rs.getMetaData();
                for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                    this.resVars.add(this.rsmd.getColumnLabel(i));
                }
                if (VirtuosoQueryExecution.this.virt_graph != null && !VirtuosoQueryExecution.this.virt_graph.equals("virt:DEFAULT")) {
                    this.resVars.add("graph");
                }
            }
            catch (Exception exception) {
                throw new JenaException("ViruosoResultBindingsToJenaResults is FAILED.:" + exception);
            }
        }

        public boolean hasNext() {
            if (!this.v_finished && !this.v_prefetched) {
                this.moveForward();
            }
            return !this.v_finished;
        }

        public QuerySolution next() {
            Binding binding = this.nextBinding();
            if (this.v_finished) {
                throw new NoSuchElementException();
            }
            return new ResultBinding((Model)this.m, binding);
        }

        public QuerySolution nextSolution() {
            return this.next();
        }

        public Binding nextBinding() {
            if (!this.v_finished && !this.v_prefetched) {
                this.moveForward();
            }
            this.v_prefetched = false;
            if (this.v_finished) {
                throw new NoSuchElementException();
            }
            return this.v_row;
        }

        public int getRowNumber() {
            return this.row_id;
        }

        public List<String> getResultVars() {
            return this.resVars;
        }

        public Model getResourceModel() {
            return this.m;
        }

        protected void finalize() throws Throwable {
            if (!this.v_finished) {
                try {
                    VirtuosoQueryExecution.this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void moveForward() throws JenaException {
            try {
                if (!this.v_finished && this.rs.next()) {
                    this.extractRow();
                    this.v_prefetched = true;
                } else {
                    VirtuosoQueryExecution.this.close();
                }
            }
            catch (Exception exception) {
                throw new JenaException("Convert results are FAILED.:" + exception);
            }
        }

        protected void extractRow() throws Exception {
            this.v_row = new BindingMap();
            ++this.row_id;
            try {
                for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                    this.v_row.add(Var.alloc((String)this.rsmd.getColumnLabel(i)), VirtGraph.Object2Node(this.rs.getObject(i)));
                }
                if (VirtuosoQueryExecution.this.virt_graph != null && !VirtuosoQueryExecution.this.virt_graph.equals("virt:DEFAULT")) {
                    this.v_row.add(Var.alloc((String)"graph"), Node.createURI((String)VirtuosoQueryExecution.this.virt_graph));
                }
            }
            catch (Exception exception) {
                throw new JenaException("ViruosoResultBindingsToJenaResults is FAILED.:" + exception);
            }
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException(this.getClass().getName() + ".remove");
        }
    }
}

