/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.io;

import java.io.IOException;
import java.io.Reader;

public class LookAheadReader
extends Reader {
    private Reader in = null;
    private char[] laBuf;
    private int curLA = 0;

    public LookAheadReader(Reader r, int bufSize) {
        this.in = r;
        this.laBuf = bufSize >= 1 ? new char[bufSize] : new char[1];
    }

    public LookAheadReader(Reader r) {
        this(r, 8);
    }

    public boolean nextInputIs(String s) throws IOException {
        int inBuf = this.fillLABuf(s.length());
        if (s.length() > inBuf) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (this.laBuf[i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean nextInputIgnoreCaseIs(String s) throws IOException {
        int inBuf = this.fillLABuf(s.length());
        if (s.length() > inBuf) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.toUpperCase(this.laBuf[i]) == Character.toUpperCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public int charAt(int lookAhead) throws IOException {
        int inBuf = this.fillLABuf(lookAhead + 1);
        if (lookAhead >= inBuf) {
            return -1;
        }
        return this.laBuf[lookAhead];
    }

    public boolean moreInput() throws IOException {
        int inBuf = this.fillLABuf(1);
        return inBuf > 0;
    }

    public int fillLABuf(int charsNeeded) throws IOException {
        int toRead = charsNeeded - this.curLA;
        if (toRead > 0) {
            int charsRead;
            if (charsNeeded > this.laBuf.length) {
                char[] newBuf = new char[charsNeeded];
                System.arraycopy(this.laBuf, 0, newBuf, 0, this.curLA);
                this.laBuf = newBuf;
            }
            if ((charsRead = this.in.read(this.laBuf, this.curLA, toRead)) != -1) {
                this.curLA += charsRead;
            }
        }
        return this.curLA;
    }

    public int read() throws IOException {
        int result;
        if (this.curLA == 0) {
            result = this.in.read();
        } else {
            result = this.laBuf[0];
            --this.curLA;
            System.arraycopy(this.laBuf, 1, this.laBuf, 0, this.curLA);
        }
        return result;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.curLA == 0) {
            return this.in.read(cbuf, off, len);
        }
        if (len <= this.curLA) {
            System.arraycopy(this.laBuf, 0, cbuf, off, len);
            this.curLA -= len;
            if (this.curLA > 0) {
                System.arraycopy(this.laBuf, len, this.laBuf, 0, this.curLA);
            }
            return len;
        }
        System.arraycopy(this.laBuf, 0, cbuf, off, this.curLA);
        int charsRead = this.curLA;
        this.curLA = 0;
        int fromStream = this.in.read(cbuf, off + this.curLA, len - this.curLA);
        if (fromStream != -1) {
            charsRead += fromStream;
        }
        return charsRead;
    }

    public long skip(long n) throws IOException {
        if (this.curLA == 0) {
            return this.in.skip(n);
        }
        if (n <= (long)this.curLA) {
            this.curLA = (int)((long)this.curLA - n);
            if (this.curLA > 0) {
                System.arraycopy(this.laBuf, (int)n, this.laBuf, 0, this.curLA);
            }
            return n;
        }
        long skipped = this.curLA;
        this.curLA = 0;
        return skipped += this.in.skip(n);
    }

    public void close() throws IOException {
        this.curLA = 0;
        this.in.close();
    }
}

