/*
 * resize.c - change console video mode
 *
 * Version 0.88
 *
 * How to use this:
 *
 * 1. Get svgalib, make restoretextmode, put it somewhere in your path.
 * 2. Put vga=ask in /etc/lilo/config, boot your machine a number of times,
 *    each time with a different vga mode, and run the command
 *        "restoretextmode -w COLSxROWS".
 *    For me this resulted in the files 80x25, 80x28, 80x50, 80x60, 100x40,
 *    132x25, 132x28, 132x44. Put these files in /usr/lib/kbd/videomodes
 *    (or in your current dir).
 * 3. Now "resize COLSxROWS" will change your video mode. (Assuming you have
 *    an appropriate kernel, and svgalib works for your video card.)
 *
 * Note: this is experimental, but it works for me. Comments are welcome.
 * You may have to be root to get the appropriate ioperm permissions.
 * It is not safe to make this program suid root.
 *
 * Maybe it is possible to collect a set of videomodes for each of the
 * common video cards. You might mail me your settings, together with
 * a precise description of the card.
 *
 * aeb@cwi.nl - 940924
 *
 */

#include <stdio.h>
#include <errno.h>
#include <linux/types.h>
#include <linux/vt.h>
#include <linux/termios.h>
#include "paths.h"

extern char *index();

char *dirpath[] = { "", DATADIR "/" VIDEOMODEDIR "/", 0};
char *suffixes[] = { "", 0 };
extern char pathname[];
extern FILE *findfile(char *fnam);

main(argc, argv) int argc; char **argv; {
    int rr, cc, fd, i;
    struct vt_sizes vtsizes;
    struct vt_stat vtstat;
    struct winsize winsize;
    char *p;
    char tty[12], cmd[80], infile[1024];
    FILE *fin;

    if (argc < 2)
      usage();
    cc = atoi(argv[1]);
    if (argc == 2 && (p = index(argv[1], 'x')) != 0)
      rr = atoi(p+1);
    else if(argc == 3)
      rr = atoi(argv[2]);
    else
      usage();

    /* prepare for: restoretextmode -r 80x25 */
    sprintf(infile, "%dx%d", cc, rr);
    fin = findfile(infile);
    if (!fin) {
	fprintf(stderr, "resize: cannot find videomode file %s\n", infile);
	exit(1);
    }
    fclose(fin);

    vtsizes.v_rows = rr;
    vtsizes.v_cols = cc;
    vtsizes.v_scrollsize = 0;

    /* we do not want to read, but only need some fd */
    if ((fd = open("/dev/console", 0)) < 0)
      fd = 0;

    if(ioctl(fd, TIOCGWINSZ, &winsize)) {
	perror("TIOCGWINSZ");
	exit(1);
    }

    if(ioctl(fd, VT_GETSTATE, &vtstat)) {
	perror("VT_GETSTATE");
	exit(1);
    }

    if(ioctl(fd, VT_RESIZE, &vtsizes)) {
	perror("VT_RESIZE");
	exit(1);
    }

    /* do: restoretextmode -r 25x80 */
    sprintf(cmd, "restoretextmode -r %s\n", pathname);
    errno = 0;
    if(system(cmd)) {
	if(errno)
	  perror("restoretextmode");
	fprintf(stderr, "resize: the command `%s' failed\n", cmd);
	exit(1);
    }

    /*
     * for i in /dev/tty[0-9] /dev/tty[0-9][0-9]
     * do
     *     stty rows $rr cols $cc < $i
     * done
     */
    winsize.ws_row = rr;
    winsize.ws_col = cc;
    for (i=0; i<16; i++)
      if (vtstat.v_state & (1<<i)) {
	  sprintf(tty, "/dev/tty%d", i);
	  if ((fd = open(tty, 0)) > 0) {
	      if(ioctl(fd, TIOCSWINSZ, &winsize))
		perror("TIOCSWINSZ");
	      close(fd);
	  }
      }

    /* do: setfont default8x16 */
    /* (other people might wish other fonts - this should be settable) */
    sprintf(cmd, "setfont default8x%d", (rr > 40) ? 9 : 16);
    errno = 0;
    if(system(cmd)) {
	if(errno)
	  perror("setfont");
	fprintf(stderr, "resize: the command `%s' failed\n", cmd);
	exit(1);
    }

    fprintf(stderr, "resize: don't forget to change TERM (maybe to con%dx%d)\n",
	    cc, rr);

    return 0;
}

usage() {
    fprintf(stderr, "resize: call is:  resize COLSxROWS  or:  resize COLS ROWS\n");
    exit(1);
}
