LIBVER=4.5.26
crunch() {
	LIBDIR=$1
	LIBPREFIX=$2
	for f in $LIBDIR/$LIBPREFIX.so.$LIBVER
	do
		bname=`basename $f`
		cp $f $LIBDIR/t$bname || exit 1
		rm -f $f
		mv $LIBDIR/t$bname $f
	done
}
crunch lib libc;
crunch lib libm;
# Better have a static 'ln' ;^)
( cd lib ; ln -sf libc.so.$LIBVER libc.so.4 )
( cd lib ; ln -sf libm.so.$LIBVER libm.so.4 )
# Move any old shared libs into /tmp
for LIBS in lib/libc.so.*.*.* ; do
 if [ ! "$LIBS" = "lib/libc.so.$LIBVER" ]; then
  mv $LIBS tmp
 fi
done
for LIBS in lib/libm.so.*.*.* ; do
 if [ ! "$LIBS" = "lib/libm.so.$LIBVER" ]; then
  mv $LIBS tmp
 fi
done
