#!/bin/sh
# $Id: srv.sh,v 1.4 2002/03/28 22:34:14 ca Exp $
#
H=localhost
P=1235
ERRS=0
SRVL="server.log"
rm -f $SRVL
./server -i -l . -b $H:$P > $SRVL 2>&1 &
status=$?
SRVPID=$!
if [ "x$status" != "x0" ]
then
  echo "FAIL: cannot start server $status"
  exit $status
fi
sleep 3
if grep "ERROR" $SRVL > /dev/null
then
  echo "found ERROR in $SRVL"
  ERRS=`expr $ERRS + 1 `
fi
if kill -USR1 $SRVPID
then
  :
else
  echo "kill -USR1 failed: $?"
  exit 1
fi
sleep 2

if grep "^Address *$H:$P" $SRVL > /dev/null
then
  :
else
  echo "failed to listen on $H:$P"
  ERRS=`expr $ERRS + 1 `
fi
if grep "^Thread.* 8/" $SRVL > /dev/null
then
  :
else
  echo "failed to start threads"
  ERRS=`expr $ERRS + 1 `
fi
if grep "^Waiting threads *8" $SRVL > /dev/null
then
  :
else
  echo "wrong number of waiting threads"
  ERRS=`expr $ERRS + 1 `
fi
if grep "^Busy threads *0" $SRVL > /dev/null
then
  :
else
  echo "wrong number of busy threads"
  ERRS=`expr $ERRS + 1 `
fi
if grep "^Requests served *0" $SRVL > /dev/null
then
  :
else
  echo "wrong number of requests"
  ERRS=`expr $ERRS + 1 `
fi

kill -TERM $SRVPID

if [ "$ERRS" = "0" ]
then
  exit 0
else
  echo "$ERRS error(s)"
  exit 1
fi
