#!/bin/sh
# $Id: t-mcp-0.sh,v 1.20 2005/08/15 23:32:40 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
test -s stop && exit 1

ERRS=0
OUT=mcp.out
RPLY=clt.out
PIDS=pids
CONF=mcp.conf0
SOCK=sock
VERBOSE=false
SD=`dirname $0`
. ${SD}/../check2/user.sh

if test $# -ge 1
then
  if test "X"$1 = "X-v"
  then
    VERBOSE=true;
  fi
fi

rm -f ${PIDS} ${OUT} ${SOCK} ${RPLY}

cat > ${CONF} <<EOF
inout {
	listen_socket { type=unix; path = ${SOCK};
	umask = 027;
	user = ${USER}; }
	start_action = nostartaccept;
	min_processes = 1;
	max_processes = 1;
	user = ${USER};
	path = ./inou1;
	arguments = "inou1";
}

inout {
	listen_socket { type=unix; path = ${SOCK};
	umask = 027;
	user = ${USER}; }
	start_action = nostartaccept;
	min_processes = 1;
	max_processes = 1;
	user = ${USER};
	path = ./inou2;
	arguments = "inou2";
}
EOF

# ./mcp -d ${CONF} > ${OUT} 2>&1
# ST=$?
# if test ${ST} = 0
# then
#   ERRS=`expr ${ERRS} + 1 `
#   ${VERBOSE} && echo "expected error at startup"
# fi

cat > ${CONF} <<EOF
inout {
	listen_socket { type=unix; path = ${SOCK}; umask = 027;
			user = ${USER}; }
	start_action = nostartaccept;
	min_processes = 1;
	max_processes = 1;
	user = ${USER};
	path = ./inout;
	arguments = "inout";
}
EOF

./mcp -t -d ${CONF} > ${OUT} 2>&1 &
echo $! >> ${PIDS}
sleep 1

i=0
while test ! -w ${SOCK}
do
  i=`expr ${i} + 1`
  test ${i} -ge 3 && break
  sleep 1
done

# test socket
test -w ${SOCK} || ERRS=`expr ${ERRS} + 1 `
PERM=`ls -l ${SOCK} | sed -e 's/ .*$//'`
if test X"${PERM}" != "Xsrwxr-x---"
then
  ERRS=`expr ${ERRS} + 1 `
  ${VERBOSE} && echo "permission: expected=srwxr-x---, got=${PERM}"
fi

# connect to it?
#../misc/t-unixcl -r sock >${RPLY} 2>&1 <<EOF
../misc/t-unixcl -r sock >${RPLY} 2>/dev/null <<EOF
ABCDEFz
EOF
ST=$?

if test ${ST} != 0
then
  ERRS=`expr ${ERRS} + 1 `
  ${VERBOSE} && echo "t-unixcl: expected=0, got=${ST}"
fi

sleep 1
WC=`wc -c < ${RPLY} | sed -e 's/ //g'`
if test "X"${WC} != X6
then
  ERRS=`expr ${ERRS} + 1 `
  ${VERBOSE} && echo "wc: expected=6, got=${WC}"
fi

for i in `cat ${PIDS}`
do
  kill ${i}
done

exit ${ERRS}
