/*
 * Copyright (c) 2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strspace.c,v 1.4 2005/06/09 00:43:40 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/limits.h"
#include "sm/str.h"
#include "sm/str-int.h"

#if SM_STR_CHECK
/*
**  SM_STR_SPACE -- Make sure buffer has a certain len.
**
**	Parameters:
**		str -- sm_str_P to resize.
**		new_len -- Total length of new buffer size.
**
**	Returns:
**		usual error code
*/

sm_ret_T
sm_str_space(sm_str_P str, uint new_len)
{
	if (new_len <= str->sm_str_size)
		return SM_SUCCESS;
	return sm_str_resize_data(str, new_len);
}
#endif /* SM_STR_CHECK */
