/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strrmtrailsp.c,v 1.3 2005/06/09 00:43:40 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/ctype.h"
#include "sm/str-int.h"

/*
**  SM_STR_RM_TRAIL_SP -- Remove trailing spaces from string
**
**	Parameters:
**		str -- sm_str_P object to modify.
**
**	Returns:
**		0: nothing changed
**		>0: removed that many characters
**		<0: usual error code (doesn't happen)
*/

sm_ret_T
sm_str_rm_trail_sp(sm_str_P str)
{
	uint i;
	uchar c;
	int n;

	SM_IS_BUF(str);
	SM_REQUIRE(str->sm_str_base != NULL);

	n = 0;
	i = str->sm_str_len;
	if (i == 0)
		return 0;
	while (i > 0)
	{
		c = (str->sm_str_base[i - 1]);
		if (c == '\0' || !ISSPACE(c))
		{
			if (i < str->sm_str_len)
				str->sm_str_base[i] = '\0';
			break;
		}
		--i;
		++n;
	}
	str->sm_str_len = i;
	return n;
}
